package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.files.CycleBasedInterface
import com.yakindu.sct.generator.cpp.files.TimerHeader
import com.yakindu.sct.generator.cpp.files.TimerServiceSource
import com.yakindu.sct.generator.cpp.files.Types
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sctunit.generator.c.CSCTUnitFileSystemAccessFactory
import com.yakindu.sctunit.generator.c.extensions.GenerationHelper
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import org.eclipse.xtext.generator.IFileSystemAccess

class TimerServiceDependencies {
	
	@Inject protected GeneratorEntry entry
	@Inject IGenArtifactConfigurations locations
	@Inject protected ExecutionFlow flow
	@Inject protected extension StatechartAnnotations
	@Inject protected extension GenerationHelper
	
	@Inject protected extension CppFileNaming
	
	@Inject protected TimerHeader regularTimerHeader;
	@Inject protected com.yakindu.sct.generator.cpp.files.TimerServiceHeader regularTimerServiceHeader;
	@Inject protected TimerServiceSource regularTimerServiceSource;
	@Inject protected CycleBasedInterface regularCycleBasedInterface
	@Inject protected Types regularTypesInterface;
	
	def generateTimerServiceDependencies(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {		
		fsa.generateFile(typesModule.h, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT, regularTypesInterface.content(flow, entry, locations))
		fsa.generateFile(cycleBasedModule.h, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT, regularCycleBasedInterface.content(flow, entry, locations))
		fsa.generateFile(timerModule.h, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT, regularTimerHeader.content(flow, entry, locations))
		fsa.generateFile(timerServiceModule.h, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT, regularTimerServiceHeader.content(flow, entry, locations))
		fsa.generateFile(timerServiceModule.cpp, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT, regularTimerServiceSource.content(flow, entry, locations))
	}
	
}