/**
 * Copyright (c) 2018-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.sct.generator.cpp.qt

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.qt.codemodel.QtEventAccessors
import com.yakindu.sct.generator.cpp11.submodules.Cpp11EventRaisingCode
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * TODO: care about raising external events
 * 
 * @author terfloth
 * 
 */
class QtEventRaisingCode extends Cpp11EventRaisingCode {

	@Inject extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension QtEventAccessors
	
	override protected outEventObservable(EventRaisingExpression it, CharSequence valueCode)'''
		«IF generateValue»«event.definition.event.typeSpecifier.targetLanguageName» «eventValueIfPresent» = «value.code»;«ENDIF»
		«event.definition.event.observableAccess».next(«IF !(value instanceof PrimitiveValueExpression)»«eventValueIfPresent»«ELSE»«value.code»«ENDIF»)'''		
	

	override protected raiseOutEventStatements(EventRaisingExpression expr, CharSequence valueCode) {
		return super.raiseOutEventStatements(expr, valueCode) => [
			it += '''emit «expr.event.definition.event.signalSlotName»(«IF useOutEventGetters || (useOutEventObservables && !(expr.value instanceof PrimitiveValueExpression))»«expr.eventValueIfPresent»«ELSEIF expr.value !== null»«expr.value.code»«ENDIF»)'''
		]
	}
	
	def protected generateValue(EventRaisingExpression it){
		useOutEventObservables && !useOutEventGetters && value !== null && !(value instanceof PrimitiveValueExpression)
	}
	
	override protected eventValueIfPresent(EventRaisingExpression it) '''«IF value !== null»«event.definition.event.valueAccess»«ENDIF»'''

}
