/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
/** 
 * @author Oliver bohl
 */
package com.yakindu.sctunit.ui.labeling

import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider
import com.google.inject.Inject
import com.yakindu.sctunit.sCTUnit.AssertionStatement
import com.yakindu.sctunit.sCTUnit.EnterExpression
import com.yakindu.sctunit.sCTUnit.ExitExpression
import com.yakindu.sctunit.sCTUnit.ExpressionStatement
import com.yakindu.sctunit.sCTUnit.LoopStatement
import com.yakindu.sctunit.sCTUnit.ProceedExpression
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.sCTUnit.TestPackage
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement

class SCTUnitLabelProvider extends DefaultEObjectLabelProvider {
	package String iconURI = "../icons/SCTUnit.png"
	package String stmURI = "../icons/brkpi_obj.gif"
	package String expURI = "../icons/brkpi_obj.gif"
	package String packageURI = "../icons/generic_element.gif"

	@Inject new(AdapterFactoryLabelProvider delegate) {
		super(delegate)
	}

	def package String image(TestPackage group) {
		return iconURI
	}

	def package String image(SCTUnitSuite suite) {
		return packageURI
	}

	def package String image(SCTUnitOperation tcase) {
		return packageURI
	}

	def package String image(TestStatement stm) {
		return stmURI
	}

	def package String text(EnterExpression es) {
		return "Enter"
	}

	def package String text(ProceedExpression rs) {
		return "proceed"
	}

	def package String text(AssertionStatement ^as) {
		if (^as.getErrorMsg() !== null) {
			return '''Assertion: "«^as.getErrorMsg()»"'''
		} else {
			return "Assertion"
		}
	}

	def package String text(LoopStatement ls) {
		return "Loop"
	}

	def package String text(ExpressionStatement es) {
		return "ExpressionStatement"
	}

	def package String text(ExitExpression es) {
		return "Exit"
	}

	def package String text(VariableDefinitionStatement vs) {
		return "VariableDefinition"
	}
}
