/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.simulation.core.util

import java.util.ArrayList
import java.util.List
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.types.Direction
import com.yakindu.sct.model.sgraph.RegularState
import com.yakindu.sct.model.sruntime.ExecutionContext
import com.yakindu.sct.model.sruntime.ExecutionSlot

class ExecutionContextExtensions {

	def clearOutEvents(ExecutionContext executionContext) {
		executionContext.allEvents.filter[executionContext.isOwner(it)].filter[direction == Direction.OUT].forEach [
			if(raised) raised = false	
		]
	}

	def clearLocalAndInEvents(ExecutionContext executionContext) {
		executionContext.allEvents.filter[executionContext.isOwner(it)].filter[direction == Direction.IN || direction == Direction.LOCAL].forEach [
			if(raised) raised = false
		]
	}

	def List<RegularState> getAllActiveStates(ExecutionContext context) {
		context.activeStates.filter(RegularState).map[stateHierachy].flatten.toList
	}

	def protected getStateHierachy(RegularState state) {
		var result = new ArrayList<RegularState>()
		result.add(state);
		var container = state.eContainer();
		while (container !== null) {
			if (container instanceof RegularState) {
				result.add(container);
			}
			container = container.eContainer();
		}
		return result
	}

	def protected isOwner(ExecutionContext context, ExecutionSlot it) {
		var EObject declaration = it
		while (!(declaration.eContainer instanceof ExecutionContext))
			declaration = declaration.eContainer
		return context == declaration.eContainer
	}

}
