/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.types.scoping

import com.google.inject.Inject
import com.yakindu.base.types.libraries.ITypeLibraryProvider
import org.eclipse.emf.ecore.resource.Resource
import java.util.Optional

/**
 * Maps the URIs for all registered type libraries to enable standard CREATE imports.
 * 
 * @author axel terfloth - initial contribution
 */
class TypeLibraryImport2URIMapper implements IPackageImport2URIMapper {
	
	@Inject ITypeLibraryProvider libraryProvider
	
	override findPackageImport(Resource context, String packageImport) {
		return Optional.ofNullable(registeredLibraryPackagesImports.findFirst[ name == packageImport ])
	}

	override getAllImports(Resource context) {
		return registeredLibraryPackagesImports.toSet
	}

	override canHandle(Resource context, String packageImport) {
		return registeredLibraryPackagesImports.findFirst[ name == packageImport ] !== null
	}

	def protected registeredLibraryPackagesImports() {
		libraryProvider.provide.map[ new IPackageImport2URIMapper.PackageImport(libraryPackage.name, libraryURI, libraryPackage.name) ]
	}

}