/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.submodules.EventCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.StatechartScope

/**
 * @author René Beckmann - Initial contribution and API
 */
class EventDrivenEventCode extends EventCode {

	@Inject protected extension EventQueue

	@Inject extension EventNaming eventNaming
	@Inject extension GeneratorPredicate
	@Inject extension SExecExtensions
	@Inject protected extension INamingService
	
	
	override generateEvents(ExecutionFlow it, StatechartScope scope)
		'''
			«FOR event : scope.incomingEvents»
				«generateEvent(event, scope)»
			«ENDFOR»
			«FOR event : scope.outgoingEvents»
				«generateEvent(event, scope)»
			«ENDFOR»
			«FOR event : scope.localEvents»
				«generateEvent(event, scope)»
			«ENDFOR»
		'''
	
	def generateEvent(ExecutionFlow it, EventDefinition event, StatechartScope scope)
		'''
			«event.generateEventComment(scope)»
			«IF event.needsRaiser»
				«generateInterfaceEventRaiser(event, scope)»
				«IF event.isQueued»«generateInternalInterfaceEventRaiser(event, scope)»«ENDIF»
			«ENDIF»
			«IF event.needsRaised»
				«generateInterfaceEventRaised(flow, event, scope)»
				«IF event.hasValue»
					«generateEventValueGetter(event, scope)»
				«ENDIF»
			«ENDIF»
			«IF event.needsObservable»
				«generateObservableGetter(event, scope)»
			«ENDIF»
		'''
	
	
	protected def CharSequence generateInternalInterfaceEventRaiser(ExecutionFlow it, EventDefinition event, StatechartScope scope)
		'''
		void «module»::«scope.scopedAccess»internal_«event.asRaiser»(«event.valueParams»)
		{
			«IF event.hasValue»
				«event.localValueAccess» = «event.asParameter»;
			«ENDIF»
			«event.localAccess» = true;
		}
	'''
	
	protected override CharSequence generateInterfaceEventRaiser(ExecutionFlow it, EventDefinition event, StatechartScope scope) {
		if( event.isQueued ) 
			event.generateInterfaceEventRaiserQueued 
		else 
			event.generateInterfaceEventRaiser
	}

	protected def generateInterfaceEventRaiserQueued(EventDefinition it) {
		'''
			void «flow.module»::«scope.scopedAccess»«it.asRaiser»(«it.valueParams»)
			{
				«queueEventCode»
        «IF scope.isNamedScope»«parentMember»->«ENDIF»«flow.runCycleFctID»();
			}
		'''
	}
	
	def queueEventCode(EventDefinition it){
		'''
		«IF it.hasValue»
		«IF scope.isNamedScope»«parentMember»->«ENDIF»«queue».push_back(new «event.eventClassName»(«event.eventEnumMemberName», «event.asParameter»));
		«ELSE»
		«IF scope.isNamedScope»«parentMember»->«ENDIF»«queue».push_back(new «event.eventClassName»(«event.eventEnumMemberName»));
		«ENDIF»
		'''
	}

	protected def generateInterfaceEventRaiser(EventDefinition it) 
		'''
			void «flow.module»::«scope.scopedAccess»«it.asRaiser»(«it.valueParams»)
			{
				«IF it.hasValue»
				«event.localValueAccess» = «event.asParameter»;
				«ENDIF»
				«event.localAccess» = true;
				
				«IF scope.isNamedScope»«parentMember»->«ENDIF»«flow.runCycleFctID»();
			}
		'''
	
	override CharSequence generateEventComment(EventDefinition it, StatechartScope scope)
		'''/* Functions for event «name» in interface «scope.interfaceName» */'''
		
	
	def queue(EventDefinition it) {
		return 
			if 		( isLocalEvent ) internalQueue 
			else if	( isInEvent )	 inEventQueue 
			else 					 null
	}
	
	override eventNextCode(ExecutionFlow it) '''
		«dispatchEventFctID»(«nextEventFctID»());
	'''
}
