/**
 * Copyright (c) 2021-2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.StringLiteral
import com.yakindu.base.expressions.expressions.TypeCastExpression
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.c.types.CTypeSystemAccess
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.c.typesystem.CTypeSystem
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp11.codemodel.EventAccessors
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.util.Strings

import static com.yakindu.sct.generator.c.typesystem.CTypeSystem.*

/**
 * The generated C++11 code handles strings differently than the C++98 code generator.
 * 
 * @author axel terfloth - Initial contribution.
 */
class Cpp11ExpressionsGenerator extends CppExpressionsGenerator{
	
	@Inject protected extension StateEnum
	@Inject protected extension ITypeValueProvider
	@Inject protected extension CppPointers
	@Inject protected extension EventAccessors
	
	override dispatch CharSequence code(InitializationExpression it) {		
		//Either names or order is correct
		val ogType = it.infer
		if(arguments.forall[a | a.parameter !== null && a.parameter.name !== null]){		
			if(ogType.type instanceof ComplexType)
				return '''{«FOR p : (ogType.type as ComplexType).features.filter(Property) SEPARATOR ','»«arguments.filter(pr | pr.parameter.name.equals(p.name)).head.value.code»«ENDFOR»}'''
		}
		return '''{«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»}'''	
	}
	
	override dispatch CharSequence code(EventRaisingExpression it) '''«raiseEvent(it, value?.code)»''' 
	
	override dispatch CharSequence code(TypeCastExpression it) '''(static_cast<«typeSpecifier.getTargetLanguageName»> («operand.code»))'''
	
	override dispatch CharSequence code(StringLiteral it) 
		'''"«Strings.convertToJavaString(value.escaped)»"'''

	override dispatch CharSequence code(ActiveStateReferenceExpression it) 
		'''«flow.stateActiveFctID»(«value.stateName»)'''

	override argumentsCode(ArgumentExpression it) '''«FOR arg : expressions SEPARATOR ', '»«arg.moveIfNecessary»«ENDFOR»'''
	
	override dispatch CharSequence code(ElementReferenceExpression it, VariableDefinition target) {
		if(eContainer instanceof AssignmentExpression){
			super._code(it, target)
		} else{
			if((target).typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)){
				super._code(it, target).stdMove
			} else {
				super._code(it, target)
			}			
		}		
	}
	
	def CharSequence getPointerType(Expression it){
		if(featureOrReference.getType.name.equals(CTypeSystem.SHARED_POINTER))
			return '''«sharedPtr»«IF (it instanceof FeatureCall)»«it.owner.pointerType»«ENDIF»«pointerType»'''
		else
			return '''«featureOrReference.getType»'''
	}
	
	def dispatch Type getType(EObject it){}
	
	def dispatch Type getType(TypedDeclaration it){
		type
	}
	
	override dispatch CharSequence code(FeatureCall it, Property target) {
		if (isExtensionProperty(target) && CTypeSystem.SHARED_POINTER.equals(target.name)) {
			return '''«makeSharedPtr»«it.owner.pointerType»«pointerType»(«it.owner.code»)'''
		}

		if (isValueOnPointer) {
			return '''(*(«it.owner.code»))'''
		}
		super._code(it, target)
	}
	
	def dispatch CharSequence moveIfNecessary(ElementReferenceExpression it){
		val definition = it.definition
		if(definition !== null && !(definition instanceof Property) && definition.getType !== null && definition.getType.name.equals(CTypeSystemAccess.UNIQUE_POINTER)) it.definition.moveIfNecessary
		else it.code(it.reference)
	}
	
	def dispatch CharSequence moveIfNecessary(Declaration it){
		if(it instanceof EventDefinition){
			if((it as EventDefinition).typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)){
				valueAccess.stdMove
			} else {
				valueAccess	
			}
		}else if(it instanceof VariableDefinition) {
			if((it as VariableDefinition).typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER)){
				localAccess.stdMove
			} else {
				localAccess
			}
		} else {
			val target = it.definition
			if(target !== null && target instanceof VariableDefinition && (target as VariableDefinition).typeSpecifier.type.name.equals(CTypeSystemAccess.UNIQUE_POINTER))
				code.stdMove
			else code
		}		
	}
	
	def dispatch CharSequence moveIfNecessary(Expression it){
		code
	}

	override stateEnumerator(Enumerator it) {

		val statechart = eContainer.getOriginStatechart
		val state = originState
		
		if (state === null) 
			statechart.noStateEnumerator.asLiteral
		else
			state.enumerator.asLiteral
	}
	
	override dispatch CharSequence code(FeatureCall it, Enumerator target) {
		it.enumeratorCode(target)
	}
	
	def dispatch CharSequence code(Expression it, Enumerator target) {
		it.enumeratorCode(target)
	}
	
	def dispatch CharSequence code(ArgumentExpression it) {
		'''«FOR a : expressions SEPARATOR ','»«a.code»«ENDFOR»'''
	}
	
	protected def enumeratorCode(Expression it, Enumerator target){
		if(target.eContainer.isOriginStatechart) {
			return target.stateEnumerator
		}
		return '''«target.type.asLiteral»::«target.access»'''
	}
	
	def dispatch CharSequence code(LogicalRelationExpression it, CTypes.PString lType, CTypes.PString rType) 
		'''(«leftOperand.code» «operator.literal» «rightOperand.code»)'''

	override calculateInitialValue(Property it){
		if(initialValue!==null){
			if(initialValue instanceof InitializationExpression)
				initialValue.code
			else
				'''{«initialValue.code»}'''
		} 	
		else if(typeSpecifier.type.defaultValue !== null) '''{«typeSpecifier.type.defaultValue.asLiteral»}'''
		else if(typeSpecifier.typeArguments.exists[type instanceof ComplexType && !CTypeSystem.POINTER_TYPES.exists[pt | type.name == pt]] ) '''«typeSpecifier.instantiateSmartPointer»'''
		else '''{}'''
	}
	
	def String instantiateSmartPointer(TypeSpecifier it) {
		if (type.name == SHARED_POINTER) {
			return '''= «makeSharedPtr»«getTargetLanguageName(typeArguments.head)»«pointerType»()'''
		}
		else if (type.name == UNIQUE_POINTER) {
			return '''{new «getTargetLanguageName(typeArguments.head)»{}}'''
		} else '''{}'''
	}
	
	override dispatch CharSequence castToReciever(ArgumentExpression it, String expression){
		if (featureOrReference instanceof VariableDefinition) {
			val originalType = infer(featureOrReference)
			return '''static_cast<«getTargetLanguageName(originalType.type)»> («expression»)'''
		}
	}
}