/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.submodules

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Operation
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.StatechartScope

/**
 * Uses code model to generate interface functions. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class Cpp11InterfaceFunctions extends InterfaceFunctions {
	
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension GeneratorAssignment
	@Inject protected extension Literals
	
	
	/** Deactivate base class creation of event related methods */
	override dispatch functionPrototypes(EventDefinition it) ''''''
	
	override publicNamedInterfaceClassMember(Scope it)
	'''
		«IF it.namedInterfaceClass !== null»
			«FOR m : it.namedInterfaceClass.features.filter[isPublic]»
				«m.declarationCode»
			«ENDFOR»
		«ENDIF»
	'''
	
	override dispatch privateFunctionPrototypes(Scope it)
	'''
		
		«IF it.namedInterfaceClass !== null»
			«FOR m : it.namedInterfaceClass.features.filter[isPrivate]»
				«m.declarationCode»
			«ENDFOR»
		«ENDIF»
	'''
	
	override generateCodeModelMethods(StatechartScope it) '''
		«IF namedInterfaceClass !== null»
			«FOR e : namedInterfaceClass.features.filter(Operation)»
				
				«e.definitionCode»
				
			«ENDFOR»
		«ENDIF»
	'''	
	
	override createOCBinstance(StatechartScope s) {
		if(entry.usePlainOperationCallbackPointers) super.createOCBinstance(s)
		else
		'''«IF s.hasOperations && !entry.useStaticOPC»«sharedPtr»«s.interfaceOCBName»«pointerType» «s.OCB_Instance»;«ENDIF»'''}	
}