/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class ITimed {

	@Inject extension Naming 
	@Inject extension GenmodelEntries
	@Inject extension OutputConfigProvider
	@Inject extension ICoreLibraryHelper
	@Inject extension StringHelper

	def generateITimed(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + iTimed.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def content(GeneratorEntry entry) {
		content(entry.licenseText, entry.libraryPackage)
	}
	
	def content(String licenseText, String pkg) {
		'''
			«licenseText»
			«IF !pkg.isNullOrEmpty»package «pkg»;«ENDIF»
			
			/**
			* Interface for state machines which use timed event triggers.
			*/
			public interface «iTimed» {
				
				/**
				* Callback method if a time event occurred.
				* 
				* @param eventID	the id of the occurred event
				*/
				public void raiseTimeEvent(int eventID);
				
				/**
				* Set the {@link «iTimerService»} for the state machine. It must be set
				* externally on a timed state machine before <code>enter()</code> is called.
				* 
				* @param timerService	the timer service implementation to be set.
				*/
				public void setTimerService(«iTimerService» timerService);
			}
		'''
	}
}
