/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.OutEventObservables
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class Observable {
	
	@Inject extension GenmodelEntries
	@Inject extension OutEventObservables
	@Inject extension Naming
	@Inject extension OutputConfigProvider
	@Inject extension ICoreLibraryHelper
	
	def generateObservable(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.rxPackagePath + '/' + observableClass.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, entry.content)
	}
	
	def private content(GeneratorEntry it)
	'''
		«licenseText»
		package «rxPackage»;
		
		import java.util.ArrayList;
		import java.util.List;
		
		public class Observable<T> {
		
			private List<Observer<T>> observers = new ArrayList<>();
		
			public void next(T value) {
				for (Observer<T> observer : observers) {
					observer.next(value);
				}
			}
		
			public boolean subscribe(Observer<T> observer) {
				return observer != null ? this.observers.add(observer) : false;
			}
		
			public boolean unsubscribe(Observer<T> observer) {
				return observer != null ? this.observers.remove(observer) : false;
			}
		}
	'''
	
}