/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.files

import com.google.inject.Inject
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class TraceEvent {
	
	
	@Inject extension Naming
	@Inject extension GenmodelEntries
	@Inject extension ICoreLibraryHelper
	@Inject extension OutputConfigProvider
	@Inject extension StringHelper


	def generateTraceEvent(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val fileName = entry.libraryPackage.toPath + '/' + traceEventClass.java
		fsa.generateFile(fileName, entry.libraryOutputConfig, content(entry))
	}
	
	def private content(GeneratorEntry it) {
		'''
			«licenseText»
			«IF !libraryPackage.isNullOrEmpty»package «libraryPackage»;«ENDIF»
			
			/**
			 * Instances represent state machine trace events. 
			 */
			public class «traceEventClass»<M extends «iStatemachine», S, F> {

				protected «traceEventTypeEnum» type;
				protected M machine;
				protected S state;
				protected F feature;
				protected Object value;

				public «traceEventClass»(«traceEventTypeEnum» type, M machine) {
					this(type, machine, null, null, null);
				}

				public «traceEventClass»(«traceEventTypeEnum» type, M machine, S state, F feature, Object value) {
					this.type = type;
					this.machine = machine;
					this.state = state;
					this.feature = feature;
					this.value = value;
				}

				public «traceEventTypeEnum» getType() {
					return type;
				}

				public M getMachine() {
					return machine;
				}
			
				public S getState() {
					return state;
				}
			
				public F getFeature() {
					return feature;
				}

				public Object getValue() {
					return value;
				}

			}
			
		'''
	}



}