/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.types.Operation
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.java.FlowCode
import com.yakindu.sct.generator.java.JavaExpressionsGenerator
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.naming.INamingService

/**
 * 
 * @author Thomas Kutz
 */
class MethodGenerator {

	@Inject extension VisibilityAnnotations
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension INamingService
	@Inject extension FlowCode
	@Inject extension Synchronized
	@Inject extension JavaExpressionsGenerator
	@Inject protected extension Documentation
	

	def dispatch CharSequence toImplementation(Iterable<Method> methods) '''
		«FOR m : methods»
			«m.toImplementation»
			
		«ENDFOR»
	'''
	
	def dispatch CharSequence toImplementation(Method it) '''
		«methodModifier»«typeSpecifier.targetLanguageName» «shortName»(«FOR p : parameters SEPARATOR ', '»«IF p.varArgs»...«ELSE»«p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR») {
			«body.code»
		}
	'''
	
	def dispatch CharSequence toImplementation(Operation it) '''
		/* «documentation» */
		«methodModifier»«typeSpecifier.targetLanguageName» «name.asEscapedIdentifier»(«FOR p : parameters SEPARATOR ', '»«IF p.varArgs»...«ELSE»«p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR») «implementation.code»
	'''
	
	protected def methodModifier(Operation it) {
		if (isPublic)
			'''public «sync»'''
		else 
			'''private '''
	}
}
