/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.simulation.core.sexec.interpreter

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.interpreter.DefaultExpressionInterpreter
import com.yakindu.base.expressions.interpreter.SlotResolutionExceptionSupplier
import com.yakindu.sct.model.sruntime.ExecutionEvent
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.simulation.core.util.ExecutionContextExtensions
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.naming.IQualifiedNameProvider

import static extension com.yakindu.base.expressions.interpreter.base.InterpreterAdapter.*
import org.eclipse.emf.ecore.util.EcoreUtil

/**
 * 
 * @author andreas muelder - Initial contribution and API 
 * @author axel terfloth - additions
 * 
 */
class StextExpressionInterpreter extends DefaultExpressionInterpreter {

	@Inject	extension IQualifiedNameProvider provider
	
	@Inject protected extension ExecutionContextExtensions

	def dispatch Object execute(EventRaisingExpression eventRaising) {
		val event = context.resolve(eventRaising.event).orElseThrow(
			SlotResolutionExceptionSupplier.forContext(eventRaising.event))
		if (event instanceof ExecutionEvent) {
			val value = eventRaising.value?.execute
			event.interpreter.raiseEvent(event, value)
		}
		null
	}

	def dispatch Object execute(ActiveStateReferenceExpression expression) {
		val state = expression.value
		return context.allActiveStates.exists[s|EcoreUtil.equals(state, s)]
	}

	def dispatch qname(FeatureCall e) {
		return e.feature.getFullyQualifiedName.toString
	}

	def dispatch qname(ElementReferenceExpression e) {
		e.reference.getFullyQualifiedName.toString
	}

	def String fqn(EObject obj) {
		obj.getFullyQualifiedName.toString
	}

}
