/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*/
package com.yakindu.sct.generator.python.files

/**
 * @autho Robin Herrmann
 */

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.python.GenmodelEntries
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class RXPython {
	
	@Inject extension Naming
	@Inject extension StringHelper
	@Inject extension GenmodelEntries
	@Inject extension PackageInit
	@Inject extension ICoreLibraryHelper
	@Inject extension OutputConfigProvider
	
	def generateObserver(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val path = entry.libraryPackage.toPath
		fsa.generateFile(path + '/' + rxpyModule.py, entry.libraryOutputConfig, content(entry))
		if (!path.nullOrEmpty)
			fsa.generatePyPackageInit(path, entry.libraryOutputConfig, entry)
	}
	
	def content(GeneratorEntry entry) '''
		"""Implementation for Observer and Observables used for out events.
		«entry.licenseText»
		"""
		
		
		class Observer():
			"""Observer implementation.
			"""
		
			def next(self, value=None):
				"""Abstract next method, which must be implemented."""
				raise NotImplementedError('user must define next() to use this base class')
		
		
		class Observable():
			"""Observable implementation.
			"""
		
			def __init__(self):
				self.observers = []
		
			def next(self, value=None):
				"""Calls next function from every observer.
				"""
				for observer in self.observers:
					if observer is not None:
						if value is None:
							observer.next()
						else:
							observer.next(value)
		
			def subscribe(self, observer):
				"""Subscribe on specified observer.
				"""
				if observer is not None:
					self.observers.append(observer)
					return True
				return False
		
			def unsubscribe(self, observer):
				"""Unsubscribe from specified observer.
				"""
				if observer is None:
					return False
				if observer in self.observers:
					self.observers.remove(observer)
					return True
				return False
	'''

}
