/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.itemis.create.base.generator.csharp.codemodel.CsharpClass
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codepattern.ClassCode
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Part
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.types.resource.Statechart2TypeTransformation
import java.util.List
import org.eclipse.emf.ecore.EObject

/**
 * This concept is responsible to create all required types for operation callbacks.
 * 
 * @author laszlo kovacs
 * 
 */
@Singleton
class CsharpStatemachineOperationCallbacks {

	public static String OPERATION_CALLBACK_INTERFACE = "OperationCallback"
	public static String OPERATION_CALLBACK_VARIABLE = "operationCallback"

	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	protected extension ExpressionsFactory eFactory = ExpressionsFactory.eINSTANCE
	@Inject protected extension StatemachineClass
	@Inject protected extension StatechartUtil
	@Inject protected extension CsharpNamedInterfaceClasses
	@Inject protected extension TypeBuilder
	@Inject protected extension Documentation
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension IMethodCode
	@Inject protected extension ClassCode
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension ITypeSystem
	@Inject protected extension OriginTracing
	@Inject protected extension ExpressionBuilder
	@Inject protected extension CsharpClass
	@Inject protected extension Statechart2TypeTransformation

	def operationCallback(ComplexType stmType, ComplexType implClass) {

		if (stmType instanceof ExecutionFlow) {
			stmType.scopes.filter[!members.filter(OperationDefinition).nullOrEmpty].forEach [ scopeType |
				scopeType.declarationsForScope(
					scopeType.namedInterface === null ? implClass : scopeType.createNamedInterfaceClass
				)
			]
		} else {
			stmType.declarationsForScope(implClass)
			stmType.eAllContents.filter(ComplexType).filter[!features.filter(OperationDefinition).nullOrEmpty].forEach [ scopeType |
				scopeType.toScopeIface(implClass)
			]
			stmType.getOriginStatechart.scopes.filter(InternalScope)?.filter [
				!members.filter(OperationDefinition).nullOrEmpty
			].head?.declarationsForScope(implClass)
		}

	}

	def protected toScopeIface(NamedElement scopeType, ComplexType implClass) {
		val scopeIface = implClass.eAllContents.filter(ComplexType).filter [
			origin === scopeType.origin || (origin !== null && (origin as EObject).origin === scopeType.origin)
		].head
		scopeType.declarationsForScope(scopeIface)
	}

	def protected declarationsForScope(EObject scopeType, ComplexType scopeIface) {

		val ocbIface = scopeType.ocbIfaceForScope(scopeIface)
		val List<EObject> content = scopeType instanceof Scope ? scopeType.members : scopeType.eAllContents.toList
		content.filter(OperationDefinition).forEach [ d |
			ocbIface.features += d.defineOperation
		]

	}

	def protected ocbIfaceForScope(EObject scopeType, ComplexType scopeIface) {
		val ocbIface = scopeType.defineOperationCallbackInterface
		if (scopeType instanceof NamedElement && !(scopeType as NamedElement).name.nullOrEmpty) {
			if (scopeIface === scopeType)
				scopeIface.features += ocbIface
			else {
				val namedIfaceForScope = scopeType instanceof Scope ? scopeType.namedInterface : (scopeIface.
				origin as Scope).namedInterface
				namedIfaceForScope.features += ocbIface
			}
		} else
			scopeIface.features += ocbIface

		val ocbVar = scopeType.ocbVarName.defineOperationCallbackVariable(ocbIface)

		if (scopeType instanceof NamedElement && !(scopeType as NamedElement).name.nullOrEmpty)
			scopeIface.features += ocbVar => [_public]
		else
			scopeIface.features += ocbVar => [_private]

		scopeIface.features += ocbVar.defineOperationCallbackSetter(ocbIface)
		ocbIface
	}

	def defineOperation(OperationDefinition od) {
		val method = _op(od.name == OPERATION_CALLBACK_INTERFACE ? od.name + "_" : od.name, if (od.type === null)
			createTypeSpecifier => [
				type = getType('void')
			]
		else
			od.typeSpecifier.copy) => [
			if (!od.parameters.nullOrEmpty) {
				od.parameters.forEach [ odParam |
					it.parameters += odParam.copy => [
						traceOrigin(odParam)
					]
				]
			}
			traceOrigin(od)
			// documentation('''Function declaration for operation«od.name» of «od.scope.scopeDescription».''')
			_public
			_abstract
			static = false
			generateDefinitionWith[methodDeclarationCode]
		]
		return method
	}

	def defineOperationCallbackSetter(Part ocbVar, ComplexType ocbClass) {
		val method = _op('Set' + OPERATION_CALLBACK_INTERFACE, getType('void')) => [
			documentation('''Function to set the operation callback for «ocbClass.name»«IF ocbClass.eContainer !== ocbClass.stateMachineClass» in interface '«(ocbClass.eContainer as NamedElement).name»'«ENDIF».''')
			val param = createParameter => [
				name = OPERATION_CALLBACK_INTERFACE.toFirstLower + 'ToRegister'
				typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = ocbClass
				]
			]
			parameters += param
			_public
			static = false
			implementation = createBlockExpression => [
				expressions += ocbVar._ref._assignment(param._ref)
			]
			generateDefinitionWith[methodDefinitionCode]
		]
		return method
	}

	def defineOperationCallbackInterface(EObject interfaceType) {
		_csharpInterface(
			interfaceType.operationCallbackInterfaceNaming + OPERATION_CALLBACK_INTERFACE
		)
	}

	def operationCallbackInterfaceNaming(EObject interfaceType) {
		if (!(interfaceType instanceof NamedElement))
			"IInternal"
		else
			"I"
	}

	def ocbVarName(EObject interfaceType) {
		if (interfaceType instanceof Scope && !(interfaceType instanceof InterfaceScope))
			"internal" + OPERATION_CALLBACK_VARIABLE.toFirstUpper
		else interfaceType.isNameCollided ? OPERATION_CALLBACK_VARIABLE + "_ID" : OPERATION_CALLBACK_VARIABLE
	}

	def dispatch isNameCollided(ComplexType interfaceType) {
		interfaceType.name == OPERATION_CALLBACK_INTERFACE && !interfaceType.isNamedIface
	}

	def dispatch isNameCollided(InterfaceScope interfaceType) {
		!interfaceType.name.nullOrEmpty
	}

	def defineOperationCallbackVariable(String ocbVarName, ComplexType ocbClass) {
		_part(ocbVarName, ocbClass) => [
			_required
			_user_declared
			generateDeclarationWith[variableDeclarationCode]
		]
	}
}
