/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.model.stext.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.ExpressionsPackage;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.RegularEventSpec;
import com.yakindu.base.expressions.expressions.TimeEventSpec;
import com.yakindu.base.expressions.util.ExpressionExtensions;
import com.yakindu.base.types.Direction;
import com.yakindu.base.types.Event;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.TypesPackage;
import com.yakindu.base.types.inferrer.ITypeSystemInferrer;
import com.yakindu.base.types.validation.IValidationIssueAcceptor;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.util.StatechartUtil;
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.model.stext.stext.EventDefinition;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.model.stext.stext.InternalScope;
import com.yakindu.sct.model.stext.validation.STextBaseValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class EventValidator
extends STextBaseValidator {
    @Inject
    private ITypeSystemInferrer typeInferrer;
    @Inject
    @Extension
    private ExpressionExtensions _expressionExtensions;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    @Extension
    private STextExtensions _sTextExtensions;
    @Inject
    @Extension
    private StatechartAnnotations _statechartAnnotations;
    @Inject
    @Extension
    private StatechartUtil _statechartUtil;
    public static final String OUT_EVENT_NEVER_RAISED = "Out event '%s' is never raised in this statechart. The transition trigger is therefore never active.";
    public static final String LOCAL_DECLARATIONS = "Local declarations are not allowed in interface scope. Violated by: ";
    public static final String IN_OUT_DECLARATIONS = "In/Out declarations are not allowed in internal scope. Violated by: ";
    private static final String UNRAISED_LOCAL_EVENT_MSG = "The local event '%s' is never raised.";
    public static final String UNRAISED_LOCAL_EVENT_CODE = "LocalEventNeverRaised";
    public static final String EVENT_RAISED_AND_NOT_CONSUMED = "The unbuffered event '%s' is raised but not consumed downstream. Unbuffered events are only visible 'downstream' in subsequent orthogonal regions within the same run-to-completion step.";
    public static final String EVENT_RAISED_AND_NOT_CONSUMED_CODE = "EventRaisedAndNotConsumed";
    public static final String UNBUFFERED_LOCAL_EVENT_NOT_RAISED = "The unbuffered local event '%s' is never raised. For unbuffered local events, event raising must happen before they are consumed, i.e. in preceding orthogonal regions.";
    public static final String UNBUFFERED_LOCAL_EVENT_NOT_RAISED_CODE = "UnbufferedLocalEventNotRaised";
    public static final String RAISING_SUBMACHINES_OUT_EVENT = "Out events of submachines can not be raised. Use an in event instead of: ";
    public static final String RAISING_SUBMACHINES_OUT_EVENT_CODE = "RasingSubmachinesOutEvent";
    public static final String RAISED_EVENT_NOT_SPECIFIED = "No valid event to raise is specified.";
    public static final String RAISED_EVENT_NOT_SPECIFIED_CODE = "RaisedEventNotSpecified";

    @Check(value=CheckType.FAST)
    public void checkExpression(TimeEventSpec expression) {
        this.typeInferrer.infer((EObject)expression, (IValidationIssueAcceptor)this);
    }

    @Check(value=CheckType.FAST)
    public void checkRaisingExpressionEvent(EventRaisingExpression expression) {
        EObject element = this._expressionExtensions.featureOrReference(expression.getEvent());
        if (element != null && !(element instanceof Event)) {
            String elementName = "";
            if (element instanceof NamedElement) {
                elementName = ((NamedElement)element).getName();
            }
            this.error(String.format("'%s' is not an event.", elementName), (EStructuralFeature)ExpressionsPackage.Literals.EVENT_RAISING_EXPRESSION__EVENT, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkNotRaisedOutEvent(EventDefinition event) {
        Functions.Function1 _function;
        boolean _notEquals;
        Direction _direction = event.getDirection();
        boolean bl = _notEquals = !Objects.equals(_direction, Direction.OUT);
        if (_notEquals) {
            return;
        }
        Collection usages = EcoreUtil.UsageCrossReferencer.find((EObject)event, (Resource)event.eResource());
        boolean isRaised = IterableExtensions.exists((Iterable)usages, (Functions.Function1)(_function = setting -> {
            EObject _eContainer = setting.getEObject().eContainer();
            return _eContainer instanceof EventRaisingExpression;
        }));
        if (!isRaised) {
            Functions.Function1 _function_1 = setting -> setting.getEObject() instanceof ElementReferenceExpression || setting.getEObject() instanceof FeatureCall;
            Consumer<EStructuralFeature.Setting> _function_2 = setting -> this.warning(String.format(OUT_EVENT_NEVER_RAISED, this._iQualifiedNameProvider.getFullyQualifiedName((EObject)event)), setting.getEObject(), null, -1);
            IterableExtensions.filter((Iterable)usages, (Functions.Function1)_function_1).forEach(_function_2);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkEventDefinition(EventDefinition event) {
        if (event.eContainer() instanceof InterfaceScope && event.getDirection() == Direction.LOCAL) {
            String _name = event.getName();
            String _plus = LOCAL_DECLARATIONS + _name;
            this.error(_plus, (EStructuralFeature)TypesPackage.Literals.EVENT__DIRECTION);
        }
        if (event.eContainer() instanceof InternalScope && event.getDirection() != Direction.LOCAL) {
            String _name_1 = event.getName();
            String _plus_1 = IN_OUT_DECLARATIONS + _name_1;
            this.error(_plus_1, (EStructuralFeature)TypesPackage.Literals.EVENT__DIRECTION);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkInternalEventsAreRaised(InternalScope scope) {
        Functions.Function1 _function = it -> this._expressionExtensions.featureOrReference(it.getEvent());
        Set allRaisedEvents = IteratorExtensions.toSet((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)Iterators.filter((Iterator)this._sTextExtensions.getStatechart(scope.eResource()).eAllContents(), EventRaisingExpression.class), (Functions.Function1)_function), Event.class));
        Set localEvents = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)scope.getDeclarations(), Event.class));
        Predicate<Event> _function_1 = it -> {
            Functions.Function1 _function_2 = it_1 -> it_1.getName();
            return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)allRaisedEvents, (Functions.Function1)_function_2)).contains(it.getName());
        };
        localEvents.removeIf(_function_1);
        Consumer<Event> _function_2 = it -> this.warning(String.format(UNRAISED_LOCAL_EVENT_MSG, it.getName()), (EObject)it, null, UNRAISED_LOCAL_EVENT_CODE, new String[0]);
        localEvents.forEach(_function_2);
    }

    @Check(value=CheckType.FAST)
    public void checkRaisedUnbufferedEventIsConsumedDownstream(EventRaisingExpression expression) {
        EObject element = this._expressionExtensions.featureOrReference(expression.getEvent());
        if (element == null || this._statechartUtil.isMultiSM(element.eContainer())) {
            return;
        }
        if (element instanceof Event && (Objects.equals(((Event)element).getDirection(), Direction.IN) || Objects.equals(((Event)element).getDirection(), Direction.LOCAL)) && !this.isBuffered((Event)element)) {
            List<Region> downstreamRegions = this.getDownstreamRegions((EObject)this._sTextExtensions.getContextElement((EObject)expression));
            for (Region r : downstreamRegions) {
                Functions.Function1 _function = it -> {
                    EObject _featureOrReference = this._expressionExtensions.featureOrReference((Expression)it);
                    return Objects.equals(_featureOrReference, element);
                };
                boolean _exists = IterableExtensions.exists((Iterable)EcoreUtil2.eAllOfType((EObject)r, ArgumentExpression.class), (Functions.Function1)_function);
                if (!_exists) continue;
                return;
            }
            this.warning(String.format(EVENT_RAISED_AND_NOT_CONSUMED, ((Event)element).getName()), (EObject)expression, null, EVENT_RAISED_AND_NOT_CONSUMED_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkUnbufferedLocalEventIsRaisedUpstream(RegularEventSpec trigger) {
        EObject element = this._expressionExtensions.featureOrReference(trigger.getEvent());
        if (element == null || this._statechartUtil.isMultiSM(element.eContainer())) {
            return;
        }
        if (element instanceof Event && Objects.equals(((Event)element).getDirection(), Direction.LOCAL) && !this.isBuffered((Event)element)) {
            List<Region> upstreamRegions = this.getUpstreamRegions((EObject)this._sTextExtensions.getContextElement((EObject)trigger));
            for (Region r : upstreamRegions) {
                Functions.Function1 _function = it -> {
                    EObject _featureOrReference = this._expressionExtensions.featureOrReference(it.getEvent());
                    return Objects.equals(_featureOrReference, element);
                };
                boolean _exists = IterableExtensions.exists((Iterable)EcoreUtil2.eAllOfType((EObject)r, EventRaisingExpression.class), (Functions.Function1)_function);
                if (!_exists) continue;
                return;
            }
            this.warning(String.format(UNBUFFERED_LOCAL_EVENT_NOT_RAISED, ((Event)element).getName()), (EObject)trigger, null, UNBUFFERED_LOCAL_EVENT_NOT_RAISED_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkNotRaisingSubmachinesOutEvent(EventRaisingExpression expression) {
        EObject event = this._expressionExtensions.featureOrReference(expression.getEvent());
        if (event instanceof EventDefinition && this._statechartUtil.isMultiSM(((EventDefinition)event).eContainer()) && Objects.equals(((EventDefinition)event).getDirection(), Direction.OUT)) {
            String _name = ((EventDefinition)event).getName();
            String _plus = RAISING_SUBMACHINES_OUT_EVENT + _name;
            this.error(_plus, (EObject)expression, null, RAISING_SUBMACHINES_OUT_EVENT_CODE, new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkRaisedEventSpecified(EventRaisingExpression expression) {
        EObject event = this._expressionExtensions.featureOrReference(expression.getEvent());
        if (event == null) {
            this.error(RAISED_EVENT_NOT_SPECIFIED, (EObject)expression, null, RAISED_EVENT_NOT_SPECIFIED_CODE, new String[0]);
        }
    }

    protected boolean isBuffered(Event ev) {
        Statechart statechart = this._sTextExtensions.getStatechart((EObject)ev);
        return Objects.equals(ev.getDirection(), Direction.IN) && this._statechartAnnotations.isInEventBuffer(statechart) || Objects.equals(ev.getDirection(), Direction.LOCAL) && this._statechartAnnotations.isInternalEventBuffer(statechart);
    }

    protected List<Region> getUpstreamRegions(EObject base) {
        Functions.Function1 _function = r -> this.getPredecessorRegions((Region)r);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)base), Region.class), (Functions.Function1)_function)));
    }

    protected List<Region> getPredecessorRegions(Region r) {
        List _xblockexpression = null;
        int idx = r.getComposite().getRegions().indexOf((Object)r);
        List _xifexpression = null;
        _xifexpression = idx > 0 ? r.getComposite().getRegions().subList(0, idx) : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected List<Region> getDownstreamRegions(EObject base) {
        Functions.Function1 _function = r -> this.getSuccessorRegions((Region)r);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)EcoreUtil2.getAllContainers((EObject)base), Region.class), (Functions.Function1)_function)));
    }

    protected List<Region> getSuccessorRegions(Region r) {
        List _xblockexpression = null;
        int idx = r.getComposite().getRegions().indexOf((Object)r);
        List _xifexpression = null;
        int _size = r.getComposite().getRegions().size();
        int _minus = _size - 1;
        boolean _lessThan = idx < _minus;
        _xifexpression = _lessThan ? r.getComposite().getRegions().subList(idx + 1, r.getComposite().getRegions().size()) : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

