/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ViewFilterAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;

abstract class AbstractThreadsViewFilterAction
extends ViewFilterAction
implements IDebugEventSetListener {
    AbstractThreadsViewFilterAction() {
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IJavaThread thread;
        if (!this.getPreferenceValue() && (thread = this.getJavaThread(element)) != null) {
            try {
                return this.selectThread(thread);
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return true;
    }

    private void refresh(Object source) {
        IJavaThread thread = this.getJavaThread(source);
        if (thread != null) {
            try {
                if (this.isCandidateThread(thread)) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            StructuredViewer viewer = AbstractThreadsViewFilterAction.this.getStructuredViewer();
                            if (viewer != null) {
                                viewer.refresh();
                            }
                        }
                    };
                    JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
                    return;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    protected abstract boolean isCandidateThread(IJavaThread var1) throws DebugException;

    protected abstract boolean selectThread(IJavaThread var1) throws DebugException;

    private IJavaThread getJavaThread(Object element) {
        IJavaThread thread = null;
        if (element instanceof IJavaThread) {
            thread = (IJavaThread)element;
        } else if (element instanceof IAdaptable) {
            thread = (IJavaThread)((IAdaptable)element).getAdapter(IJavaThread.class);
        }
        return thread;
    }

    @Override
    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.getValue()) {
            return;
        }
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            switch (event.getKind()) {
                case 1: {
                    if (event.getDetail() != 32) break;
                    this.refresh(event.getSource());
                }
            }
            ++n2;
        }
    }
}

