/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.cpp.features;

import com.yakindu.sct.generator.core.library.impl.CoreLibraryDefaultFeatureValueProvider;
import com.yakindu.sct.generator.cpp.features.CPPFeatureConstants;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sct.model.sgraph.Statechart;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CPPDefaultFeatureValueProvider
extends CoreLibraryDefaultFeatureValueProvider {
    private static final String VALID_IDENTIFIER_REGEX = "[_a-zA-Z][_a-zA-Z0-9]*";

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return "CPP Generator".equals(library.getName());
    }

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        super.setDefaultValue(featureType, parameterValue, contextElement);
        Statechart statechart = (Statechart)this.unwrap(contextElement);
        if (parameterValue.getParameter().getName().equals("moduleName")) {
            parameterValue.setValue(this.asIdentifier(statechart.getName(), "_"));
        } else if (parameterValue.getParameter().getName().equals("statemachinePrefix")) {
            parameterValue.setValue(StringExtensions.toFirstLower((String)this.asIdentifier(statechart.getName(), "_")));
        } else if (parameterValue.getParameter().getName().equals("separator")) {
            parameterValue.setValue("_");
        } else if ("headerFilenameExtension".equals(parameterValue.getParameter().getName())) {
            parameterValue.setValue("h");
        } else if ("sourceFilenameExtension".equals(parameterValue.getParameter().getName())) {
            parameterValue.setValue("cpp");
        } else if (parameterValue.getParameter().getName().equals("innerFunctionVisibility")) {
            parameterValue.setValue(CPPFeatureConstants.Visibility.PRIVATE.toString().toLowerCase());
        } else if (parameterValue.getParameter().getName().equals("staticOperationCallback")) {
            parameterValue.setValue(false);
        } else if (parameterValue.getParameter().getName().equals("smartPointers")) {
            parameterValue.setValue(false);
        } else if (parameterValue.getParameter().getName().equals("useRelativePaths")) {
            parameterValue.setValue(true);
        } else if (parameterValue.getParameter().getName().equals("generateAllSpecifiedIncludes")) {
            parameterValue.setValue(false);
        }
    }

    public IStatus validateParameterValue(FeatureParameterValue parameter) {
        IStatus superResult = super.validateParameterValue(parameter);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        String parameterName = parameter.getParameter().getName();
        if ("moduleName".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid module name");
            }
        } else if ("statemachinePrefix".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid function prefix name");
            }
        } else if ("separator".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid separator");
            }
        } else if ("headerFilenameExtension".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid filename extension");
            }
        } else if ("sourceFilenameExtension".equals(parameterName)) {
            if (!parameter.getStringValue().matches(VALID_IDENTIFIER_REGEX)) {
                return this.error("Invalid filename extension");
            }
        } else if ("innerFunctionVisibility".equals(parameterName)) {
            boolean found = false;
            for (CPPFeatureConstants.Visibility visibility : Arrays.asList(CPPFeatureConstants.Visibility.values())) {
                if (!visibility.toString().toLowerCase().equals(parameter.getStringValue())) continue;
                found = true;
                break;
            }
            if (!found) {
                return this.error("Visibility could only be private or protected");
            }
        } else if ("smartPointers".equals(parameterName) && parameter.getBooleanValue()) {
            return this.warning("Smart pointer based interfaces are experimental");
        }
        return Status.OK_STATUS;
    }

    private String asIdentifier(String it, String separator) {
        return it.replaceAll("[[^a-z]&&[^A-Z]&&[^0-9]]", separator);
    }
}

