/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.cpp.providers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations;
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess;
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator;
import com.yakindu.sct.generator.cpp.CppNaming;
import com.yakindu.sct.generator.cpp.CppSpecifiers;
import com.yakindu.sct.generator.cpp.providers.ISourceFragment;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sexec.extensions.SExecExtensions;
import com.yakindu.sct.model.stext.stext.StatechartScope;
import com.yakindu.sct.model.stext.stext.VariableDefinition;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ConstantsProvider
implements ISourceFragment {
    @Inject
    @Extension
    protected SExecExtensions _sExecExtensions;
    @Inject
    @Extension
    protected ICodegenTypeSystemAccess _iCodegenTypeSystemAccess;
    @Inject
    @Extension
    protected CppNaming _cppNaming;
    @Inject
    @Extension
    protected CppExpressionsGenerator _cppExpressionsGenerator;
    @Inject
    @Extension
    protected CppSpecifiers _cppSpecifiers;

    @Override
    public CharSequence get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable _statechartScopes = this._sExecExtensions.getStatechartScopes(it);
        for (StatechartScope scope : _statechartScopes) {
            Functions.Function1 _function = it_1 -> it_1.isConst() && this._cppSpecifiers.requiresInitialization((VariableDefinition)it_1);
            Iterable _filter = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)scope.getDeclarations(), VariableDefinition.class), (Functions.Function1)_function);
            boolean _hasElements = false;
            for (VariableDefinition d : _filter) {
                String _name;
                boolean _notEquals;
                if (!_hasElements) {
                    _hasElements = true;
                }
                boolean bl = _notEquals = !Objects.equals(_name = d.getType().getName(), "void");
                if (_notEquals) {
                    _builder.append("const ");
                    String _targetLanguageName = this._iCodegenTypeSystemAccess.getTargetLanguageName(d.getTypeSpecifier());
                    _builder.append(_targetLanguageName);
                    _builder.append(" ");
                    CharSequence _access = this._cppNaming.access((EObject)d);
                    _builder.append((Object)_access);
                    _builder.append(" = ");
                    CharSequence _code = this._cppExpressionsGenerator.code((EObject)d.getInitialValue());
                    _builder.append((Object)_code);
                    _builder.append(";");
                }
                _builder.newLineIfNotEmpty();
            }
            if (!_hasElements) continue;
            String _newLine = Strings.newLine();
            _builder.append(_newLine);
        }
        return _builder;
    }
}

