/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.commands;

import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.editparts.StateEditPart;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateSubdiagramCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Node state = this.unwrap(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (state == null) {
            return null;
        }
        CreateSubDiagramCommand cmd = new CreateSubDiagramCommand(state);
        this.executeCommand(cmd);
        return null;
    }

    protected void executeCommand(AbstractTransactionalCommand operation) {
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        try {
            history.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public Node unwrap(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (firstElement == null) {
            return null;
        }
        return (Node)((StateEditPart)((Object)firstElement)).getNotationView();
    }

    public boolean isEnabled() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        ISelection selection = activeWorkbenchWindow.getActivePage().getSelection();
        if (selection == null) {
            return false;
        }
        Node unwrap = this.unwrap(selection);
        if (unwrap == null) {
            return false;
        }
        State state = (State)unwrap.getElement();
        if (state == null || state.isComposite()) {
            return false;
        }
        BooleanValueStyle inlineStyle = DiagramPartitioningUtil.getInlineStyle((View)unwrap);
        if (inlineStyle != null && !inlineStyle.isBooleanValue()) {
            return false;
        }
        return super.isEnabled();
    }

    protected static class CreateSubDiagramCommand
    extends AbstractTransactionalCommand {
        private Node node;

        public CreateSubDiagramCommand(Node node) {
            super(TransactionUtil.getEditingDomain((EObject)node), "Create Subdiagram", Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)node.eResource())));
            this.node = node;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            BooleanValueStyle inlineStyle = DiagramPartitioningUtil.getInlineStyle((View)this.node);
            if (inlineStyle != null) {
                inlineStyle.setBooleanValue(false);
            } else {
                inlineStyle = DiagramPartitioningUtil.createInlineStyle();
                inlineStyle.setBooleanValue(false);
                this.node.getStyles().add((Object)inlineStyle);
            }
            Diagram subdiagram = ViewService.createDiagram((EObject)this.node.getElement(), (String)"org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor", (PreferencesHint)DiagramActivator.DIAGRAM_PREFERENCES_HINT);
            this.node.eResource().getContents().add((Object)subdiagram);
            return CommandResult.newOKCommandResult();
        }
    }
}

