/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.policies;

import com.google.common.collect.Lists;
import com.yakindu.base.gmf.runtime.router.ConnData;
import com.yakindu.base.gmf.runtime.router.RelativeBendpointUtil;
import com.yakindu.base.gmf.runtime.router.RubberBandRoutingSupport;
import com.yakindu.base.xtext.utils.gmf.commands.SetLabelsOffsetOperation;
import com.yakindu.base.xtext.utils.gmf.directedit.ExternalXtextLabelEditPart;
import com.yakindu.base.xtext.utils.gmf.figures.SyntaxColoringLabel;
import com.yakindu.base.xtext.utils.gmf.routing.EdgeLabelLocator;
import com.yakindu.sct.ui.editor.commands.SetConnectionBendpointsAndLabelCommmand;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;

public class FixedBendpointEditPolicy
extends GraphicalEditPolicy {
    public static final String ROLE = "Fixed_Bendpoints";
    private boolean connectionStart = true;
    private Rectangle originalBounds = null;
    private RubberBandRoutingSupport router = new RubberBandRoutingSupport();
    private RelativeBendpointUtil relbpUtil = new RelativeBendpointUtil();

    public Command createUpdateAllBendpointsCommand(ChangeBoundsRequest request) {
        CompoundCommand result = new CompoundCommand();
        for (ConnectionEditPart part : this.getAllConnectionParts(request)) {
            result.add(this.getBendpointsChangedCommand(part));
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.connectionStart = true;
        this.router.commitBoxDrag();
        for (ConnectionEditPart connectionEditPart : this.getAllConnectionParts(request)) {
            List children = connectionEditPart.getChildren();
            Connection connection = connectionEditPart.getConnectionFigure();
            for (Object child : children) {
                if (!(child instanceof ExternalXtextLabelEditPart)) continue;
                SyntaxColoringLabel figure = ((ExternalXtextLabelEditPart)child).getFigure();
                Object currentConstraint = connection.getLayoutManager().getConstraint((IFigure)figure);
                if (!(currentConstraint instanceof EdgeLabelLocator)) continue;
                EdgeLabelLocator edgeLabelLocator = (EdgeLabelLocator)currentConstraint;
                edgeLabelLocator.eraseFeedbackData();
            }
        }
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public List<ConnectionEditPart> getAllConnectionParts(ChangeBoundsRequest request) {
        ArrayList<ConnectionEditPart> conns = new ArrayList<ConnectionEditPart>();
        conns.addAll(this.getHost().getSourceConnections());
        conns.addAll(this.getHost().getTargetConnections());
        return this.filter(conns, request);
    }

    protected Command getBendpointsChangedCommand(ConnectionEditPart part) {
        Connection connection = part.getConnectionFigure();
        Point ptRef1 = connection.getSourceAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)ptRef1);
        Point ptRef2 = connection.getTargetAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)ptRef2);
        TransactionalEditingDomain editingDomain = this.getHost().getEditingDomain();
        SetConnectionBendpointsAndLabelCommmand sbbCommand = new SetConnectionBendpointsAndLabelCommmand(editingDomain);
        sbbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)part.getModel()));
        sbbCommand.setNewPointList(connection.getPoints(), ptRef1, ptRef2);
        sbbCommand.setLabelsToUpdate(part, this.getInitialPoints(connection));
        return new ICommandProxy((ICommand)sbbCommand);
    }

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            return this.createUpdateAllBendpointsCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    public IGraphicalEditPart getHost() {
        return (IGraphicalEditPart)super.getHost();
    }

    private PointList getInitialPoints(Connection connection) {
        ConnData cd = this.router.getCD((IFigure)connection);
        if (cd != null) {
            return this.relbpUtil.convertToPointList(cd.initialVisualPoints);
        }
        return connection.getPoints();
    }

    private List<Connection> getSourceConnections(ChangeBoundsRequest request) {
        ArrayList<Connection> result = new ArrayList<Connection>();
        List<ConnectionEditPart> sourceConnections = this.filter(this.getHost().getSourceConnections(), request);
        for (IGraphicalEditPart iGraphicalEditPart : sourceConnections) {
            Connection connection = (Connection)iGraphicalEditPart.getFigure();
            result.add(connection);
        }
        return result;
    }

    private List<Connection> getTargetConnections(ChangeBoundsRequest request) {
        ArrayList<Connection> result = new ArrayList<Connection>();
        List<ConnectionEditPart> targetConnections = this.filter(this.getHost().getTargetConnections(), request);
        for (IGraphicalEditPart iGraphicalEditPart : targetConnections) {
            Connection connection = (Connection)iGraphicalEditPart.getFigure();
            result.add(connection);
        }
        return result;
    }

    private void justKeepConnectionsInPlace(ChangeBoundsRequest request) {
        if (this.connectionStart) {
            IFigure figure = this.getHostFigure();
            this.originalBounds = this.getHostFigure().getBounds().getCopy();
            figure.translateToAbsolute((Translatable)this.originalBounds);
            this.originalBounds.translate(request.getMoveDelta().getNegated()).resize(request.getSizeDelta().getNegated());
            this.router.initBoxDrag(this.originalBounds, this.getSourceConnections(request), this.getTargetConnections(request));
            this.connectionStart = false;
        }
        this.router.updateBoxDrag(this.originalBounds);
    }

    private void routeInResponseToBoxDrag(ChangeBoundsRequest request) {
        if (this.connectionStart) {
            IFigure figure = this.getHostFigure();
            this.originalBounds = this.getHostFigure().getBounds().getCopy();
            figure.translateToAbsolute((Translatable)this.originalBounds);
            this.originalBounds.translate(request.getMoveDelta().getNegated()).resize(request.getSizeDelta().getNegated());
            this.router.initBoxDrag(this.originalBounds, this.getSourceConnections(request), this.getTargetConnections(request));
            this.connectionStart = false;
        }
        this.router.updateBoxDrag(request.getTransformedRectangle(this.originalBounds));
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (request.getEditParts().get(0) != this.getHost()) {
            this.justKeepConnectionsInPlace(request);
        } else {
            this.routeInResponseToBoxDrag(request);
        }
    }

    private void showLineFeedback(ConnectionEditPart connectionEditPart) {
        List children = connectionEditPart.getChildren();
        Connection connection = connectionEditPart.getConnectionFigure();
        for (Object child : children) {
            if (!(child instanceof ExternalXtextLabelEditPart)) continue;
            SyntaxColoringLabel figure = ((ExternalXtextLabelEditPart)child).getFigure();
            Object currentConstraint = connection.getLayoutManager().getConstraint((IFigure)figure);
            if (!(currentConstraint instanceof EdgeLabelLocator)) continue;
            EdgeLabelLocator edgeLabelLocator = (EdgeLabelLocator)currentConstraint;
            edgeLabelLocator.setFeedbackData(this.getInitialPoints(connection), new Vector((double)edgeLabelLocator.getOffset().x, (double)edgeLabelLocator.getOffset().y), SetLabelsOffsetOperation.isEdgeWithObliqueRoutingStyle((org.eclipse.gef.ConnectionEditPart)connectionEditPart));
        }
    }

    public void showSourceFeedback(Request request) {
        if ("drop".equals(request.getType())) {
            return;
        }
        if (request instanceof ChangeBoundsRequest) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
            for (ConnectionEditPart cep : this.getAllConnectionParts((ChangeBoundsRequest)request)) {
                this.showLineFeedback(cep);
            }
        }
    }

    protected List<ConnectionEditPart> filter(List<ConnectionEditPart> list, ChangeBoundsRequest request) {
        if (request.getEditParts() == null) {
            return list;
        }
        ArrayList result = Lists.newArrayList();
        for (org.eclipse.gef.ConnectionEditPart connectionEditPart : list) {
            if (request.getEditParts().contains(connectionEditPart.getTarget()) && request.getEditParts().contains(connectionEditPart.getSource())) continue;
            result.add((ConnectionEditPart)connectionEditPart);
        }
        return result;
    }
}

