/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.editor.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.yakindu.sct.model.sgraph.ui.validation.ISctIssueCreator;
import com.yakindu.sct.model.sgraph.ui.validation.SCTIssue;
import com.yakindu.sct.ui.editor.validation.IResourceChangeToIssueProcessor;
import com.yakindu.sct.ui.editor.validation.IValidationIssueStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class DefaultValidationIssueStore
implements IValidationIssueStore,
IResourceChangeListener {
    @Inject
    private ISctIssueCreator issueCreator;
    @Inject
    private IResourceChangeToIssueProcessor resourceChangeToIssues;
    protected final List<IValidationIssueStore.IValidationIssueStoreListener> listener = Lists.newArrayList();
    protected Multimap<String, SCTIssue> visibleIssues = ArrayListMultimap.create();
    protected boolean connected = false;
    protected Resource connectedResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIssueStoreListener(IValidationIssueStore.IValidationIssueStoreListener newListener) {
        List<IValidationIssueStore.IValidationIssueStoreListener> list = this.listener;
        synchronized (list) {
            this.listener.add(newListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIssueStoreListener(IValidationIssueStore.IValidationIssueStoreListener oldListener) {
        List<IValidationIssueStore.IValidationIssueStoreListener> list = this.listener;
        synchronized (list) {
            this.listener.remove(oldListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        List<IValidationIssueStore.IValidationIssueStoreListener> list = this.listener;
        synchronized (list) {
            for (IValidationIssueStore.IValidationIssueStoreListener iResourceIssueStoreListener : this.listener) {
                iResourceIssueStoreListener.issuesChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(String semanticURI) {
        List<IValidationIssueStore.IValidationIssueStoreListener> list = this.listener;
        synchronized (list) {
            for (IValidationIssueStore.IValidationIssueStoreListener currentListener : this.listener) {
                String uriToListen = currentListener.getSemanticURI();
                if (semanticURI.equals(uriToListen)) {
                    currentListener.issuesChanged();
                    continue;
                }
                if (!currentListener.notifyOnChildChange() || this.connectedResource == null || !EcoreUtil.isAncestor((EObject)this.connectedResource.getEObject(uriToListen), (EObject)this.connectedResource.getEObject(semanticURI))) continue;
                currentListener.issuesChanged();
            }
        }
    }

    @Override
    public void connect(Resource resource) {
        if (this.connected) {
            throw new IllegalStateException("Issue store is already connected to a resource");
        }
        this.connectedResource = resource;
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && file.isAccessible()) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.connected = true;
        }
        this.initFromPersistentMarkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFromPersistentMarkers() {
        ArrayListMultimap newVisibleIssues = ArrayListMultimap.create();
        List<IMarker> markers = this.getMarkersOfConnectedResource();
        for (IMarker iMarker : markers) {
            SCTIssue issue = this.issueCreator.createFromMarker(iMarker, iMarker.getAttribute("elementId", ""));
            newVisibleIssues.put((Object)issue.getSemanticURI(), (Object)issue);
        }
        Multimap<String, SCTIssue> multimap = this.visibleIssues;
        synchronized (multimap) {
            this.visibleIssues.clear();
            this.visibleIssues.putAll((Multimap)newVisibleIssues);
        }
        this.notifyListeners();
    }

    protected List<IMarker> getMarkersOfConnectedResource() {
        ArrayList markers = Lists.newArrayList();
        try {
            IFile file = WorkspaceSynchronizer.getFile((Resource)this.connectedResource);
            if (file != null && file.isAccessible()) {
                markers.addAll(Arrays.asList(file.findMarkers("com.yakindu.sct.ui.editor.diagnostic", true, 2)));
                markers.addAll(Arrays.asList(file.findMarkers("com.yakindu.sct.ui.editor.task", true, 2)));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return markers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(Resource resource) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && file.isAccessible()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.connected = false;
            this.connectedResource = null;
            List<IValidationIssueStore.IValidationIssueStoreListener> list = this.listener;
            synchronized (list) {
                this.listener.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
        ArrayListMultimap newVisibleIssues = ArrayListMultimap.create();
        for (Issue issue : issues) {
            if (!(issue instanceof SCTIssue)) continue;
            String semanticURI = ((SCTIssue)issue).getSemanticURI();
            newVisibleIssues.put((Object)semanticURI, (Object)((SCTIssue)issue));
        }
        ArrayListMultimap oldVisibleIssues = ArrayListMultimap.create();
        Iterator<Issue> iterator = this.visibleIssues;
        synchronized (iterator) {
            oldVisibleIssues.putAll(this.visibleIssues);
            Iterable persistentIssues = Iterables.filter((Iterable)this.visibleIssues.values(), (Predicate)new Predicate<SCTIssue>(){

                public boolean apply(SCTIssue input) {
                    CheckType type = input.getType();
                    Severity severity = input.getSeverity();
                    return CheckType.NORMAL == type || CheckType.EXPENSIVE == type || Severity.INFO == severity;
                }
            });
            for (Object sctIssue : persistentIssues) {
                newVisibleIssues.put((Object)sctIssue.getSemanticURI(), sctIssue);
            }
            this.visibleIssues.clear();
            this.visibleIssues.putAll((Multimap)newVisibleIssues);
        }
        Sets.SetView changes = Sets.symmetricDifference((Set)oldVisibleIssues.keySet(), (Set)newVisibleIssues.keySet());
        for (String string : changes) {
            this.notifyListeners(string);
        }
        Sets.SetView intersection = Sets.intersection((Set)oldVisibleIssues.keySet(), (Set)newVisibleIssues.keySet());
        for (String string : intersection) {
            if (!this.changedSeverity(string, (Multimap<String, SCTIssue>)oldVisibleIssues, (Multimap<String, SCTIssue>)newVisibleIssues) && !this.changedErrorCount(string, (Multimap<String, SCTIssue>)oldVisibleIssues, (Multimap<String, SCTIssue>)newVisibleIssues)) continue;
            this.notifyListeners(string);
        }
    }

    protected boolean changedErrorCount(String semanticElementID, Multimap<String, SCTIssue> oldVisibleIssues, Multimap<String, SCTIssue> newVisibleIssues) {
        return oldVisibleIssues.get((Object)semanticElementID).size() != newVisibleIssues.get((Object)semanticElementID).size();
    }

    protected boolean changedSeverity(String semanticElementID, Multimap<String, SCTIssue> oldVisibleIssues, Multimap<String, SCTIssue> newVisibleIssues) {
        Severity minOldSeverity = this.getMinSeverity(oldVisibleIssues.get((Object)semanticElementID));
        Severity minNewSeverity = this.getMinSeverity(newVisibleIssues.get((Object)semanticElementID));
        return minNewSeverity.ordinal() != minOldSeverity.ordinal();
    }

    protected Severity getMinSeverity(Collection<SCTIssue> issues) {
        Severity minNewSeverity = Severity.IGNORE;
        for (SCTIssue sctIssue : issues) {
            Severity severity = minNewSeverity = minNewSeverity.ordinal() > sctIssue.getSeverity().ordinal() ? sctIssue.getSeverity() : minNewSeverity;
        }
        return minNewSeverity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SCTIssue> getIssues(String uri) {
        ArrayList result = Lists.newArrayList();
        Multimap<String, SCTIssue> multimap = this.visibleIssues;
        synchronized (multimap) {
            Iterables.addAll((Collection)result, (Iterable)this.visibleIssues.get((Object)uri));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        if (1 != event.getType()) {
            return;
        }
        IResourceChangeToIssueProcessor.ResourceDeltaToIssueResult markerChangeResult = null;
        Multimap<String, SCTIssue> multimap = this.visibleIssues;
        synchronized (multimap) {
            markerChangeResult = this.resourceChangeToIssues.process(event, this.connectedResource, this.visibleIssues);
            if (markerChangeResult != null) {
                this.visibleIssues = markerChangeResult.getIssues();
            }
        }
        if (markerChangeResult != null) {
            for (String elementID : markerChangeResult.getChangedElementIDs()) {
                this.notifyListeners(elementID);
            }
        }
    }
}

