/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.yet.sct.debugger.ui.logging;

import com.yakindu.yet.core.logging.IConsoleLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class YETConsoleLogger
implements IConsoleLogger {
    public static final String DEFAULT_NAME = "YET Console";
    private MessageConsoleStream info;
    private MessageConsoleStream error;
    private MessageConsole console;
    private String name;

    public YETConsoleLogger() {
        this(DEFAULT_NAME);
    }

    public YETConsoleLogger(String name) {
        this.name = name != null ? name : DEFAULT_NAME;
        this.init();
    }

    public void init() {
        if (Platform.isRunning()) {
            this.console = this.getConsole();
            this.info = this.console.newMessageStream();
            this.error = this.console.newMessageStream();
            this.error.setActivateOnWrite(true);
            this.getConsoleManager().showConsoleView((IConsole)this.console);
        }
    }

    protected MessageConsole getConsole() {
        IConsoleManager consoleManager = this.getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (this.name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole console = new MessageConsole(this.name, null);
        consoleManager.addConsoles(new IConsole[]{console});
        return console;
    }

    protected IConsoleManager getConsoleManager() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        return consoleManager;
    }

    public void close() {
        try {
            this.info.close();
            this.error.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void logError(Throwable t) {
        if (this.error != null && !this.error.isClosed() && PlatformUI.isWorkbenchRunning()) {
            this.getConsoleManager().showConsoleView((IConsole)this.console);
            PrintWriter printWriter = new PrintWriter((OutputStream)this.error);
            t.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
        }
    }

    public void log(String line) {
        if (this.info != null && !this.info.isClosed() && PlatformUI.isWorkbenchRunning()) {
            this.info.println(line);
        }
    }
}

