/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.interpreter.scheduling;

import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.core.rx.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.stream.Collectors;

public class TaskScheduler {
    protected long stopTime = 0L;
    protected long currentTime = 0L;
    protected long scheduleCount = 0L;
    protected Queue<ITimeTaskScheduler.TimeTask> tasks;
    protected Observable<Void> scheduleChanged = new Observable();
    protected Observable<ITimeTaskScheduler.TimeTask> nextTaskChanged = new Observable();

    public TaskScheduler() {
        this.tasks = new PriorityQueue<ITimeTaskScheduler.TimeTask>();
    }

    public void timeLeap(long ms) {
        this.stopTime = this.currentTime + ms;
        this.processTasks();
        this.currentTime = this.stopTime;
    }

    public void cycleLeap(int cycles) {
        int elapsedCycles = 0;
        while (elapsedCycles < cycles) {
            Optional<ITimeTaskScheduler.TimeTask> cycleTask = this.getActiveTask("$cycle");
            if (!cycleTask.isPresent()) {
                return;
            }
            long timeToNextCycle = cycleTask.get().getNextExecutionTime() - this.currentTime;
            this.timeLeap(timeToNextCycle);
            ++elapsedCycles;
        }
    }

    public synchronized long timeLeapWithoutExecuting(long leapTime) {
        ITimeTaskScheduler.TimeTask nextTask = this.tasks.peek();
        long timeToNextTask = (nextTask != null ? nextTask.getNextExecutionTime() : Long.MAX_VALUE) - this.currentTime;
        long deltaT = Math.min(leapTime, timeToNextTask);
        this.currentTime += deltaT;
        return deltaT;
    }

    protected synchronized void processTasks() {
        boolean processTasks = !this.tasks.isEmpty();
        while (processTasks) {
            ITimeTaskScheduler.TimeTask task = this.tasks.peek();
            if (task == null) break;
            if (task.isCanceled) {
                this.tasks.remove();
                continue;
            }
            long executionTime = task.getNextExecutionTime();
            if (executionTime <= this.stopTime) {
                this.currentTime = task.getNextExecutionTime();
                task = this.tasks.poll();
                if (task.period > -1L) {
                    this.schedulePeriodicalTask(task, task.period, task.period);
                }
                task.run();
                continue;
            }
            this.currentTime = this.stopTime;
            processTasks = false;
        }
    }

    public synchronized void scheduleTask(ITimeTaskScheduler.TimeTask task, boolean isPeriodical, long duration) {
        if (duration <= 0L) {
            duration = 1L;
        }
        if (isPeriodical) {
            this.schedulePeriodicalTask(task, duration, duration);
        } else {
            this.scheduleTask(task, duration);
        }
    }

    public synchronized void unschedulTask(String taskId) {
        Optional<ITimeTaskScheduler.TimeTask> timerTask = this.getActiveTask(taskId);
        if (timerTask.isPresent()) {
            timerTask.get().cancel();
            if (this.tasks.peek() == timerTask.get()) {
                this.nextTaskChanged.next((Object)timerTask.get());
            }
            this.scheduleChanged.next(null);
        }
    }

    protected void schedulePeriodicalTask(ITimeTaskScheduler.TimeTask task, long interval, long period) {
        this.scheduleInternal(task, interval, period);
    }

    public void scheduleTask(ITimeTaskScheduler.TimeTask task, long interval) {
        this.scheduleInternal(task, interval, -1L);
    }

    protected synchronized void scheduleInternal(ITimeTaskScheduler.TimeTask task, long time, long period) {
        task.setNextExecutionTime(this.computeNextExecutionTime(time));
        task.period = period;
        task.scheduleOrder = this.scheduleCount++;
        this.tasks.add(task);
        if (this.tasks.size() > 1 && this.tasks.peek() == task) {
            this.nextTaskChanged.next((Object)task);
        }
        this.scheduleChanged.next(null);
    }

    protected long computeNextExecutionTime(long interval) {
        return this.currentTime + interval;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public synchronized List<ITimeTaskScheduler.TimeTask> getScheduledTimeTasks() {
        return new ArrayList<ITimeTaskScheduler.TimeTask>(this.tasks.stream().filter(t -> !t.isCanceled()).sorted().collect(Collectors.toList()));
    }

    protected Optional<ITimeTaskScheduler.TimeTask> nextTask() {
        return this.tasks.stream().filter(t -> !t.isCanceled()).findFirst();
    }

    public Observable<Void> scheduleChanged() {
        return this.scheduleChanged;
    }

    protected synchronized Optional<ITimeTaskScheduler.TimeTask> getActiveTask(String eventName) {
        return this.tasks.stream().filter(task -> !task.isCanceled() && task.name.equals(eventName)).findFirst();
    }
}

