/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.refactor.impl;

import com.yakindu.base.xtext.utils.jface.viewers.util.ActiveEditorTracker;
import com.yakindu.sct.model.sgraph.Entry;
import com.yakindu.sct.model.sgraph.Exit;
import com.yakindu.sct.model.sgraph.ReactionProperty;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.SGraphFactory;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.model.sgraph.Vertex;
import com.yakindu.sct.model.stext.stext.EntryPointSpec;
import com.yakindu.sct.model.stext.stext.ExitPointSpec;
import com.yakindu.sct.model.stext.stext.StextFactory;
import com.yakindu.sct.refactoring.refactor.AbstractRefactoring;
import com.yakindu.sct.ui.editor.DiagramActivator;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sct.ui.editor.utils.GMFNotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorPart;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public class ExtractSubdiagramRefactoring
extends AbstractRefactoring<View> {
    protected PreferencesHint preferencesHint = DiagramActivator.DIAGRAM_PREFERENCES_HINT;
    private Diagram subdiagram;

    @Override
    public boolean isExecutable() {
        EObject element = ((View)this.getContextObject()).getElement();
        if (!(element instanceof State)) {
            return false;
        }
        State state = (State)element;
        BooleanValueStyle inlineStyle = DiagramPartitioningUtil.getInlineStyle((View)((View)this.getContextObject()));
        return super.isExecutable() && state.isComposite() && (inlineStyle == null || inlineStyle.isBooleanValue());
    }

    @Override
    protected void internalExecute() {
        this.setNotationStyle();
        this.subdiagram = this.createSubdiagram();
        this.createEntryExitPoints(this.subdiagram);
        this.setPreferredSize();
    }

    @Override
    protected boolean internalDoUndo() {
        return DiagramPartitioningUtil.closeSubdiagramEditors((State)((State)this.subdiagram.getElement()));
    }

    protected void createEntryExitPoints(Diagram subdiagram) {
        TreeIterator eAllContents = subdiagram.eAllContents();
        ArrayList<Edge> entryPointsToCreate = new ArrayList<Edge>();
        ArrayList<Edge> exitPointstoCreate = new ArrayList<Edge>();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof View)) continue;
            EList targetEdges = ((View)next).getTargetEdges();
            for (Edge edge : targetEdges) {
                if (EcoreUtil.isAncestor((EObject)subdiagram, (EObject)edge.getSource())) continue;
                entryPointsToCreate.add(edge);
            }
            EList sourceEdges = ((View)next).getSourceEdges();
            for (Edge edge : sourceEdges) {
                if (EcoreUtil.isAncestor((EObject)subdiagram, (EObject)edge.getTarget())) continue;
                exitPointstoCreate.add(edge);
            }
        }
        for (Edge edge : entryPointsToCreate) {
            this.createEntryPoint(edge, subdiagram);
        }
        for (Edge edge : exitPointstoCreate) {
            this.createExitPoint(edge, subdiagram);
        }
    }

    protected void createEntryPoint(Edge edge, Diagram subdiagram) {
        Transition transition = (Transition)edge.getElement();
        Region entryPointContainer = this.getEntryPointContainer(transition);
        Entry entryPoint = this.createSemanticEntryPoint(transition);
        transition.setTarget((Vertex)((State)subdiagram.getElement()));
        View oldTarget = edge.getTarget();
        edge.setTarget((View)this.getContextObject());
        View entryPointContainerView = this.helper.getViewForSemanticElement((EObject)entryPointContainer, subdiagram);
        View entryPointRegionCompartment = ViewUtil.getChildBySemanticHint((View)entryPointContainerView, (String)"RegionCompartment");
        Node entryNode = ViewService.createNode((View)entryPointRegionCompartment, (EObject)entryPoint, (String)"Entry", (PreferencesHint)this.preferencesHint);
        ViewService.createEdge((View)entryNode, (View)oldTarget, (EObject)((EObject)entryPoint.getOutgoingTransitions().get(0)), (String)"Transition", (PreferencesHint)this.preferencesHint);
        this.addEntryPointSpec(transition, entryPoint);
    }

    private void addEntryPointSpec(Transition transition, Entry entryPoint) {
        EList properties = transition.getProperties();
        EntryPointSpec entryPointSpec = StextFactory.eINSTANCE.createEntryPointSpec();
        for (ReactionProperty reactionProperty : properties) {
            if (!(reactionProperty instanceof EntryPointSpec)) continue;
            entryPointSpec = (EntryPointSpec)reactionProperty;
        }
        entryPointSpec.setEntrypoint(entryPoint.getName());
        properties.add((Object)entryPointSpec);
    }

    private void addExitPointSpec(Transition transition, Exit exitPoint) {
        EList properties = transition.getProperties();
        ExitPointSpec exitPointSpec = StextFactory.eINSTANCE.createExitPointSpec();
        for (ReactionProperty reactionProperty : properties) {
            if (!(reactionProperty instanceof ExitPointSpec)) continue;
            exitPointSpec = (ExitPointSpec)reactionProperty;
        }
        exitPointSpec.setExitpoint(exitPoint.getName());
        properties.add((Object)exitPointSpec);
    }

    protected String getEntryPointName(Transition transition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("entry_");
        stringBuilder.append(transition.getTarget().getName());
        int index = transition.getSource().getOutgoingTransitions().indexOf((Object)transition);
        stringBuilder.append(index);
        return this.asIdentifier(stringBuilder.toString());
    }

    protected String getExitPointName(Transition transition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("exit_");
        stringBuilder.append(transition.getSource().getName());
        int index = transition.getSource().getOutgoingTransitions().indexOf((Object)transition);
        stringBuilder.append(index);
        return this.asIdentifier(stringBuilder.toString());
    }

    protected Entry createSemanticEntryPoint(Transition transition) {
        Region entryPointTarget = this.getEntryPointContainer(transition);
        String name = this.getEntryPointName(transition);
        Entry entryPoint = null;
        for (Vertex next : entryPointTarget.getVertices()) {
            Entry current;
            if (!(next instanceof Entry) || !name.equals((current = (Entry)next).getName())) continue;
            return current;
        }
        entryPoint = SGraphFactory.eINSTANCE.createEntry();
        entryPoint.setName(name);
        entryPointTarget.getVertices().add((Object)entryPoint);
        Transition entryPointTransition = SGraphFactory.eINSTANCE.createTransition();
        entryPointTransition.setSource((Vertex)entryPoint);
        entryPointTransition.setTarget(transition.getTarget());
        return entryPoint;
    }

    private Exit createSemanticExitPoint(Transition transition) {
        Region exitPointContainer = this.getExitPointContainer(transition);
        String name = this.getExitPointName(transition);
        Exit exitPoint = null;
        for (Vertex next : exitPointContainer.getVertices()) {
            Exit current;
            if (!(next instanceof Exit) || !name.equals((current = (Exit)next).getName())) continue;
            return current;
        }
        exitPoint = SGraphFactory.eINSTANCE.createExit();
        exitPoint.setName(name);
        exitPointContainer.getVertices().add((Object)exitPoint);
        return exitPoint;
    }

    private Region getEntryPointContainer(Transition transition) {
        Region firstParentRegion = transition.getTarget().getParentRegion();
        return this.getOutermostParentRegion((EObject)firstParentRegion);
    }

    private Region getExitPointContainer(Transition transition) {
        Region firstParentRegion = transition.getSource().getParentRegion();
        return this.getOutermostParentRegion((EObject)firstParentRegion);
    }

    private Region getOutermostParentRegion(EObject element) {
        while (!(element.eContainer() instanceof Statechart)) {
            EObject container = element.eContainer();
            if (container instanceof State) {
                State parentState = (State)container;
                if (parentState.equals(this.subdiagram.getElement())) {
                    return (Region)element;
                }
                element = parentState.getParentRegion();
                continue;
            }
            element = element.eContainer();
        }
        return null;
    }

    protected void createExitPoint(Edge edge, Diagram subdiagram) {
        Transition transition = (Transition)edge.getElement();
        Region exitPointContainer = this.getExitPointContainer(transition);
        Exit exitPoint = this.createSemanticExitPoint(transition);
        View exitPointContainerView = this.helper.getViewForSemanticElement((EObject)exitPointContainer, subdiagram);
        View exitPointRegionCompartment = ViewUtil.getChildBySemanticHint((View)exitPointContainerView, (String)"RegionCompartment");
        Node exitNode = ViewService.createNode((View)exitPointRegionCompartment, (EObject)exitPoint, (String)"Exit", (PreferencesHint)this.preferencesHint);
        Vertex oldTransitionTarget = transition.getTarget();
        transition.setTarget((Vertex)exitPoint);
        View oldEdgeTarget = edge.getTarget();
        edge.setTarget((View)exitNode);
        Transition exitPointTransition = SGraphFactory.eINSTANCE.createTransition();
        exitPointTransition.setSource((Vertex)((State)subdiagram.getElement()));
        exitPointTransition.setTarget(oldTransitionTarget);
        ViewService.createEdge((View)((View)this.getContextObject()), (View)oldEdgeTarget, (EObject)exitPointTransition, (String)"Transition", (PreferencesHint)this.preferencesHint);
        this.addExitPointSpec(exitPointTransition, exitPoint);
    }

    protected void setNotationStyle() {
        BooleanValueStyle inlineStyle = DiagramPartitioningUtil.getInlineStyle((View)((View)this.getContextObject()));
        if (inlineStyle == null) {
            inlineStyle = DiagramPartitioningUtil.createInlineStyle();
            ((View)this.getContextObject()).getStyles().add((Object)inlineStyle);
        }
        inlineStyle.setBooleanValue(false);
    }

    protected Diagram createSubdiagram() {
        View contextView = (View)this.getContextObject();
        State contextElement = (State)contextView.getElement();
        Diagram subdiagram = ViewService.createDiagram((EObject)contextElement, (String)"org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor", (PreferencesHint)this.preferencesHint);
        View figureCompartment = ViewUtil.getChildBySemanticHint((View)contextView, (String)"StateFigureCompartment");
        this.getResource().getContents().add((Object)subdiagram);
        boolean isHorizontal = this.isHorizontal(figureCompartment);
        int offset = 0;
        int subregions = figureCompartment.getChildren().size();
        while (figureCompartment.getChildren().size() > 0) {
            Rectangle actualBounds;
            Node child = (Node)figureCompartment.getChildren().get(0);
            if (subregions > 1 && (actualBounds = this.getActualBounds(child)) != Rectangle.SINGLETON) {
                Bounds modelBounds = (Bounds)child.getLayoutConstraint();
                modelBounds.setWidth(actualBounds.width());
                modelBounds.setHeight(actualBounds.height());
                if (isHorizontal) {
                    modelBounds.setX(offset);
                    offset += actualBounds.width();
                } else {
                    modelBounds.setY(offset);
                    offset += actualBounds.height();
                }
            }
            subdiagram.insertChild((View)child);
        }
        EList edges = figureCompartment.getDiagram().getEdges();
        List moveEdges = edges.stream().filter(edge -> edge.getSource().getDiagram() == subdiagram && edge.getTarget().getDiagram() == subdiagram).collect(Collectors.toList());
        for (Edge edge2 : moveEdges) {
            subdiagram.insertEdge(edge2);
        }
        return subdiagram;
    }

    protected boolean isHorizontal(View child) {
        BooleanValueStyle style = GMFNotationUtil.getBooleanValueStyle((View)((View)child.eContainer()), (String)"isHorizontal");
        return style != null ? style.isBooleanValue() : true;
    }

    protected Rectangle getActualBounds(Node child) {
        IEditorPart lastActiveEditor = ActiveEditorTracker.getLastActiveEditor();
        if (lastActiveEditor instanceof StatechartDiagramEditor) {
            IDiagramGraphicalViewer viewer = ((StatechartDiagramEditor)lastActiveEditor).getDiagramGraphicalViewer();
            IGraphicalEditPart editPart = (IGraphicalEditPart)viewer.getEditPartRegistry().get(child);
            return editPart.getFigure().getBounds();
        }
        return Rectangle.SINGLETON;
    }

    protected void setPreferredSize() {
        Node node = (Node)this.getContextObject();
        Bounds bounds = (Bounds)node.getLayoutConstraint();
        bounds.setWidth(-1);
        bounds.setHeight(-1);
    }
}

