/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.debugging;

import com.yakindu.sct.simulation.debugging.ISCTBreakpoint;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class SCTBreakpoint
extends Breakpoint
implements ISCTBreakpoint {
    public static final String EOBJECT_URI = " com.yakindu.sct.simulation.core.breakpoint.eobjectrui";
    private static final String ELEMENT_ID = "elementId";
    private static final String EXPRESSION = "com.yakindu.sct.simulation.core.breakpoints.expression";
    private static final String CONDITIONAL = "com.yakindu.sct.simulation.core.breakpoints.conditional";
    private static final String DOMAIN_ID = "com.yakindu.sct.domain";

    public SCTBreakpoint() {
    }

    public SCTBreakpoint(EObject semanticObject) {
        this.createMarker(semanticObject);
    }

    private void createMarker(EObject semanticObject) {
        try {
            IMarker marker = WorkspaceSynchronizer.getFile((Resource)semanticObject.eResource()).createMarker("com.yakindu.sct.simulation.debugging.breakpoints");
            this.setMarker(marker);
            this.setEnabled(true);
            this.ensureMarker().setAttribute("org.eclipse.debug.core.id", (Object)"com.yakindu.sct.simulation.core.sct.breakpoints");
            this.setAttribute(EOBJECT_URI, EcoreUtil.getURI((EObject)semanticObject).toString());
            this.updateMessage();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void updateMessage() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("SCT Breakpoint");
            if (this.isConditional()) {
                builder.append("\ncondition: " + this.getExpression());
            }
            this.setAttribute("message", builder.toString());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getModelIdentifier() {
        return "com.yakindu.sct.simulation.core.sct.breakpoints";
    }

    @Override
    public EObject resolveSemanticElement() {
        try {
            final TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(DOMAIN_ID);
            return (EObject)editingDomain.runExclusive((Runnable)new RunnableWithResult.Impl<EObject>(){

                public void run() {
                    try {
                        URI uri = SCTBreakpoint.this.getSemanticURI();
                        if (URIConverter.INSTANCE.exists(uri, Collections.emptyMap())) {
                            EObject semanticObject = editingDomain.getResourceSet().getEObject(uri, true);
                            if (semanticObject == null) {
                                SCTBreakpoint.this.delete();
                                return;
                            }
                            this.setResult(semanticObject);
                        } else {
                            SCTBreakpoint.this.delete();
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public URI getSemanticURI() {
        String objectUri = this.getMarker().getAttribute(EOBJECT_URI, "");
        return URI.createURI((String)objectUri);
    }

    public void setSemanticObject(EObject semanticObject) {
        try {
            this.getMarker().setAttribute(EOBJECT_URI, (Object)EcoreUtil.getURI((EObject)semanticObject));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNotationViewURI(String uri) {
        try {
            this.setAttribute(ELEMENT_ID, uri);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setExpression(String expression) {
        try {
            this.setAttribute(EXPRESSION, expression);
            this.updateMessage();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setConditional(boolean conditional) {
        try {
            this.setAttribute(CONDITIONAL, conditional);
            this.updateMessage();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getExpression() {
        return this.getMarker().getAttribute(EXPRESSION, "");
    }

    @Override
    public boolean isConditional() {
        return this.getMarker().getAttribute(CONDITIONAL, false);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EObject.class) {
            return this.resolveSemanticElement();
        }
        return super.getAdapter(adapter);
    }
}

