/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.preferences;

import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.LicenseManagementActivator;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.internal.preferences.ILicensePreferences;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class LicensePreferences
implements ILicensePreferences {
    public static IEclipsePreferences getInstancePreferenceNode() {
        return InstanceScope.INSTANCE.getNode("com.yakindu.licmgmt.eclipse");
    }

    private static IEclipsePreferences getDefaultPreferenceNode() {
        return DefaultScope.INSTANCE.getNode("com.yakindu.licmgmt.eclipse");
    }

    public static boolean isLicenseNotification(String licenseFeatureId) {
        return LicensePreferences.getPrefBoolean("licenseNotification_" + licenseFeatureId, PREF_KEY_LICENSE_NOTIFICATION_DEFAULT);
    }

    public static boolean isLicenseEnabled(String licenseFeatureId) {
        return LicensePreferences.getPrefBoolean("licenseEnabled_" + licenseFeatureId, true);
    }

    private static boolean getPrefBoolean(String prefKey, boolean defaultValue) {
        IPreferencesService prefService = Platform.getPreferencesService();
        return prefService != null ? prefService.getBoolean("com.yakindu.licmgmt.eclipse", prefKey, defaultValue, null) : defaultValue;
    }

    private static String getPrefString(String prefKey) {
        IPreferencesService prefService = Platform.getPreferencesService();
        return prefService != null ? prefService.getString("com.yakindu.licmgmt.eclipse", prefKey, null, null) : null;
    }

    public static boolean isLicenseEnabledDefault() {
        return true;
    }

    public static boolean isLicenseNotificationDefault() {
        return PREF_KEY_LICENSE_NOTIFICATION_DEFAULT;
    }

    public static void setLicenseNotification(String licenseFeatureId, boolean notification) {
        LicensePreferences.setBooleanOption("licenseNotification_" + licenseFeatureId, notification);
    }

    public static void setLicenseEnabled(String licenseFeatureId, boolean isEnabled) {
        LicensePreferences.setBooleanOption("licenseEnabled_" + licenseFeatureId, isEnabled);
    }

    private static void setBooleanOption(String prefKey, boolean newValue) {
        IEclipsePreferences preferences = LicensePreferences.getInstancePreferenceNode();
        String currentValue = preferences.get(prefKey, null);
        if (currentValue == null || !currentValue.equals(Boolean.toString(newValue))) {
            preferences.putBoolean(prefKey, newValue);
            LicensePreferences.flushPreferences(preferences, prefKey);
        }
    }

    public static ServerSettings getLicenseServerDefault() {
        Matcher matcher;
        String value = LicensePreferences.getDefaultPreferenceNode().get("floatingLicenseServer", null);
        Matcher matcher2 = matcher = value == null ? null : FLOATING_LICENSE_SERVER_PATTERN.matcher(value);
        if (matcher != null && matcher.matches()) {
            return LicensePreferences.createServerSettingsFromMatcher(matcher);
        }
        return LicensePreferences.createServerSettingsFromMatcher(FLOATING_LICENSE_SERVER_PATTERN.matcher(PREF_KEY_FLOATING_LICENSE_SERVER_DEFAULT));
    }

    public static ServerSettings getLicenseServer() {
        String value = LicensePreferences.getLicenseServerString();
        Matcher matcher = FLOATING_LICENSE_SERVER_PATTERN.matcher(value);
        if (matcher.matches()) {
            return LicensePreferences.createServerSettingsFromMatcher(matcher);
        }
        LoggingHelper.error((String)("Failed to load server settings from preferences: '" + value + "'"), (Object[])new Object[0]);
        return ServerSettings.NOT_AVAILABLE;
    }

    private static ServerSettings createServerSettingsFromMatcher(Matcher matcher) {
        boolean enabled = String.valueOf(1).equals(matcher.group(1));
        String address = matcher.group(2);
        String port = matcher.group(3);
        return ServerSettings.createFrom((String)(String.valueOf(address) + "%" + port), (boolean)enabled, (boolean)false);
    }

    private static String getLicenseServerString() {
        String value = LicensePreferences.getPrefString("floatingLicenseServer");
        return value != null ? value : PREF_KEY_FLOATING_LICENSE_SERVER_DEFAULT;
    }

    public static void setLicenseServer(ServerSettings serverSettings) {
        LicensePreferences.setLicenseServer(serverSettings, LicensePreferences.getInstancePreferenceNode());
    }

    public static void setLicenseServerDefault(ServerSettings defaultServerSettings) {
        LicensePreferences.setLicenseServer(defaultServerSettings, LicensePreferences.getDefaultPreferenceNode());
    }

    private static void setLicenseServer(ServerSettings serverSettings, IEclipsePreferences preferences) {
        String existingServer;
        String newServer = String.format("%d:%s@%s", serverSettings.isEnabled() ? 1 : 0, serverSettings.getHost() == null ? "" : serverSettings.getHost(), serverSettings.getPort() == null ? "6200" : serverSettings.getPort());
        if (!newServer.equals(existingServer = preferences.get("floatingLicenseServer", null))) {
            preferences.put("floatingLicenseServer", newServer);
            LicensePreferences.flushPreferences(preferences, "floatingLicenseServer");
        }
    }

    private static void flushPreferences(IEclipsePreferences preferences, String key) {
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            LicenseManagementActivator.logErrorMessage("Failed to save setting '" + key + "': " + e.getMessage());
        }
    }

    public static boolean isLicenseNotificationDialogSuppressed() {
        if (!LicensePreferences.isYakinduProduct()) {
            return false;
        }
        return LicensePreferences.getPrefBoolean("suppressLicenseDialog", false);
    }

    private static boolean isYakinduProduct() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return false;
        }
        if (product.getName() != null && product.getName().toLowerCase().contains("yakindu")) {
            return true;
        }
        return product.getId() != null && product.getId().toLowerCase().contains("yakindu");
    }
}

