/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.types.libraries;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.yakindu.base.types.libraries.ITypeLibrary;
import com.yakindu.base.types.libraries.ITypeLibraryProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class TypeLibraryRegistry
implements ITypeLibraryProvider {
    public static final String LIBRARY_PROVIDERS = "LibraryProviders";
    @Inject(optional=true)
    @Named(value="LibraryProviders")
    private Set<ITypeLibraryProvider> providers = Sets.newHashSet();

    public static void bind(Binder binder, Class<? extends ITypeLibraryProvider> providerClass) {
        Multibinder typeLibraryBinder = Multibinder.newSetBinder((Binder)binder, ITypeLibraryProvider.class, (Annotation)Names.named((String)LIBRARY_PROVIDERS));
        typeLibraryBinder.addBinding().to(providerClass);
    }

    @Override
    public Iterable<ITypeLibrary> provide() {
        HashSet<ITypeLibrary> _xblockexpression = null;
        HashSet<ITypeLibrary> libraries = new HashSet<ITypeLibrary>();
        Consumer<ITypeLibraryProvider> _function = it -> {
            Iterable<ITypeLibrary> _provide = it.provide();
            Iterables.addAll((Collection)libraries, _provide);
        };
        this.providers.forEach(_function);
        _xblockexpression = libraries;
        return _xblockexpression;
    }

    public ITypeLibrary provide(URI libUri) {
        Functions.Function1 _function = it -> {
            URI _libraryURI = it.getLibraryURI();
            return Objects.equals(_libraryURI, libUri);
        };
        return (ITypeLibrary)IterableExtensions.head((Iterable)IterableExtensions.filter(this.provide(), (Functions.Function1)_function));
    }
}

