/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.files;

import com.google.inject.Inject;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider;
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.Naming;
import com.yakindu.sct.model.sexec.ExecutionFlow;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class RuntimeService {
    @Inject
    @Extension
    private Naming _naming;
    @Inject
    @Extension
    private GenmodelEntries _genmodelEntries;
    @Inject
    @Extension
    private ICoreLibraryHelper _iCoreLibraryHelper;
    @Inject
    @Extension
    private OutputConfigProvider _outputConfigProvider;
    @Inject
    @Extension
    private StringHelper _stringHelper;

    public void generateRuntimeService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
        boolean _skipLibraryFiles = this._iCoreLibraryHelper.getSkipLibraryFiles(entry);
        if (_skipLibraryFiles) {
            return;
        }
        String _path = this._stringHelper.toPath(this._genmodelEntries.getLibraryPackage(entry));
        String _plus = _path + "/";
        String _java = this._naming.java(this._naming.runtimeServiceClass());
        String fileName = _plus + _java;
        fsa.generateFile(fileName, this._outputConfigProvider.getLibraryOutputConfig(entry), this.content(entry));
    }

    private CharSequence content(GeneratorEntry it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        String _licenseText = this._genmodelEntries.getLicenseText(it);
        _builder.append(_licenseText);
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this._genmodelEntries.getLibraryPackage(it));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("package ");
            String _libraryPackage = this._genmodelEntries.getLibraryPackage(it);
            _builder.append(_libraryPackage);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.Timer;");
        _builder.newLine();
        _builder.append("import java.util.TimerTask;");
        _builder.newLine();
        _builder.append("import java.util.concurrent.locks.ReentrantReadWriteLock;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Runtime service for state machines to execute a run to completion step");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* periodically.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public class RuntimeService {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static RuntimeService runtimeService;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Timer timer = null;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private Map<Long, StatemachineTimerTask> timerTasks = new HashMap<Long, StatemachineTimerTask>();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private class StatemachineTimerTask extends TimerTask {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private List<IStatemachine> statemachineList = new LinkedList<IStatemachine>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("private boolean isPaused = false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lock.readLock().lock();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (!isPaused) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for (IStatemachine statemachine : statemachineList) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("if (statemachine instanceof ICycleBased) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("((ICycleBased) statemachine).runCycle();");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lock.readLock().unlock();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* Adds the given state machine to the TimerTask.");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* @param statemachine");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* @return {@code true} if state machine is added properly.");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public boolean addStatemachine(IStatemachine statemachine) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lock.writeLock().lock();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("boolean ret = statemachineList.add(statemachine);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lock.writeLock().unlock();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* Removes the given state machine from the TimerTask.");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* @param statemachine");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("* @return {@code true} if state machine is removed properly.");
        _builder.newLine();
        _builder.append("\t\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public boolean removeStatemachine(IStatemachine statemachine) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lock.writeLock().lock();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("boolean ret = statemachineList.remove(statemachine);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lock.writeLock().unlock();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void pause() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("isPaused = true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public void resume() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("isPaused = false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private RuntimeService() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Not intended to be instantiated.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Returns the {@code RuntimeService} instance as singleton.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return The singleton {@code RuntimeService} instance");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static RuntimeService getInstance() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (runtimeService == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("runtimeService = new RuntimeService();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return runtimeService;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Registers an {@link IStatemachine} for scheduled fixed rate execution");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param statemachine");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*            - The state machine to execute");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param cyclePeriod");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*            - the fixed rate cycle period for scheduling");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return {@code true} if state machine is added properly.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean registerStatemachine(IStatemachine statemachine,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("long cyclePeriod) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// TimerTask for cycle time already existing -> add state machine");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return timerTasks.get(cyclePeriod).addStatemachine(statemachine);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// Create new TimerTask for cycle period and add state machine");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("StatemachineTimerTask timerTask = new StatemachineTimerTask();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTasks.put(cyclePeriod, timerTask);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("boolean ret = timerTask.addStatemachine(statemachine);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// Create a new Timer instance if runtime service was cancelled");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// before");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (timer == null) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("timer = new Timer();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.scheduleAtFixedRate(timerTask, 0, cyclePeriod);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Removes the given state machine from runtime service.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param statemachine");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*            - the state machine to be removed");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param cyclePeriod");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*            - the scheduling cycle period of the state machine");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return {@code true} if state machine is removed properly.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean unregisterStatemachine(IStatemachine statemachine,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("long cyclePeriod) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("boolean ret = timerTasks.get(cyclePeriod).removeStatemachine(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("statemachine);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return ret;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Cancels the execution of state machines for the given cycle period. This");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* stops the execution of state machines which are registered for the given");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* cycle period and cancels the executing {@link TimerTask}.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return {@code true} if poperly cancelled");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean cancelAll(long cyclePeriod) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (timer != null && timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("TimerTask task = timerTasks.get(cyclePeriod);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("task.cancel();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.purge();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTasks.remove(cyclePeriod);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Pauses the execution of all state machines which are registered for the");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* given cyclePeriod.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param cyclePeriod");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return {@code true} if properly paused");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean pauseAll(long cyclePeriod) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTasks.get(cyclePeriod).pause();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Resumes the execution of all state machines which are registered for the");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* given cyclePeriod.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @param cyclePeriod");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* @return {@code true} if properly resumed");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean resumeAll(long cyclePeriod) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (timerTasks.containsKey(cyclePeriod)) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTasks.get(cyclePeriod).resume();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* Cancels the execution of all registered state machines. This cancels the");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* executing {@link Timer} freeing all allocated resources and terminates");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("* all existing execution threads.");
        _builder.newLine();
        _builder.append("\t ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void cancelTimer() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (timer != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.cancel();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer.purge();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timerTasks.clear();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("timer = null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

