/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.license.standard.lmx.ui;

import com.yakindu.base.base.BasePackage;
import com.yakindu.licmgmt.IEclipseLicenseManager;
import com.yakindu.licmgmt.IEclipseLicenseService;
import com.yakindu.licmgmt.ILicenseChangedListener;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.license.lmx.ui.EditorReloadingOnLicenseChangedListener;
import com.yakindu.sct.license.lmx.ui.LicenseFeatureStandardEdition;
import com.yakindu.sct.runtime.ContentTypeHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class StandardLicenseLmxUiActivator
extends AbstractUIPlugin {
    final ILicenseChangedListener licenseListener = new EditorReloadingOnLicenseChangedListener(){

        @Override
        protected boolean isRelevantInput(IEditorInput input) {
            IFile file = (IFile)input.getAdapter(IFile.class);
            return file != null && ContentTypeHelper.isStatechart((IFile)file) && this.isRelevantDomain(file);
        }

        private boolean isRelevantDomain(IFile file) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            String domainID = DomainRegistry.determineDomainID((URI)uri);
            return BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral().equals(domainID);
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerLicenseListener();
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterLicenseListener();
        super.stop(context);
    }

    private void registerLicenseListener() {
        try {
            LicenseFeatureStandardEdition licenseFeature = new LicenseFeatureStandardEdition();
            IEclipseLicenseManager licenseManager = IEclipseLicenseService.INSTANCE.getLicenseManager(licenseFeature.getLicenseFeatureId(), licenseFeature.getMinimalRequiredLicenseVersion());
            licenseManager.addListener(this.licenseListener);
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
    }

    private void unregisterLicenseListener() {
        try {
            LicenseFeatureStandardEdition licenseFeature = new LicenseFeatureStandardEdition();
            IEclipseLicenseManager licenseManager = IEclipseLicenseService.INSTANCE.getLicenseManager(licenseFeature.getLicenseFeatureId(), licenseFeature.getMinimalRequiredLicenseVersion());
            licenseManager.removeListener(this.licenseListener);
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
    }
}

