/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Jonathan Thoene - itemis AG
*
*/
package com.yakindu.sctunit.simulation.core.junit.serializer

import com.yakindu.sctunit.simulation.core.junit.TestCase
import com.yakindu.sctunit.simulation.core.junit.TestSuite
import com.google.inject.Singleton

@Singleton
class JUnitXMLSerializer implements IJUnitXMLSerializer {

	override serialize(TestSuite suite) {
		if(suite.testSuites.nullOrEmpty){	
			'''
				<testsuite name="«suite.name»" time="«suite.time»">
				  «FOR TestCase tcase : suite.testCases»
				  	<testcase name="«tcase.name»" classname="«tcase.className»" time="«tcase.time»">
				  	  «FOR failure : tcase.failures»
				  	  	<failure>«failure.message.toXML»</failure>
				  	  «ENDFOR»
				  	</testcase>
				  «ENDFOR»
				</testsuite>
			'''
		}else{
			'''
				<testsuite name="«suite.name»" time="«suite.time»">
				  «FOR TestSuite tsuite : suite.testSuites»
				  	<testsuite name="«tsuite.name»" time="«tsuite.time»">
				  	  «FOR TestCase tcase : tsuite.testCases»
				  	  	<testcase name="«tcase.name»" classname="«tcase.className»" time="«tcase.time»">
				  	  	  «FOR failure : tcase.failures»
				  	  	    <failure>«failure.message.toXML»</failure>
				  	  	  «ENDFOR»
				  	  	</testcase>
				  	  «ENDFOR»
				  	</testsuite>
				  «ENDFOR»
				</testsuite>
			'''
		}
	}
	
	
	def protected toXML(String it) {
		 replaceAll("<", "&lt;")
		.replaceAll(">", "&gt;")
	}

}