/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit.simulation.core.interpreter;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.expressions.expressions.ArgumentExpression;
import com.yakindu.base.expressions.expressions.AssignmentExpression;
import com.yakindu.base.expressions.expressions.BitwiseAndExpression;
import com.yakindu.base.expressions.expressions.BitwiseOrExpression;
import com.yakindu.base.expressions.expressions.BitwiseXorExpression;
import com.yakindu.base.expressions.expressions.ConditionalExpression;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.EventRaisingExpression;
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.base.expressions.expressions.LogicalAndExpression;
import com.yakindu.base.expressions.expressions.LogicalNotExpression;
import com.yakindu.base.expressions.expressions.LogicalOrExpression;
import com.yakindu.base.expressions.expressions.LogicalRelationExpression;
import com.yakindu.base.expressions.expressions.NumericalAddSubtractExpression;
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression;
import com.yakindu.base.expressions.expressions.NumericalUnaryExpression;
import com.yakindu.base.expressions.expressions.ParenthesizedExpression;
import com.yakindu.base.expressions.expressions.PostFixUnaryExpression;
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression;
import com.yakindu.base.expressions.expressions.ShiftExpression;
import com.yakindu.base.expressions.expressions.TypeCastExpression;
import com.yakindu.base.expressions.interpreter.IOperationExecutor;
import com.yakindu.base.expressions.interpreter.scheduling.ITimeTaskScheduler;
import com.yakindu.base.types.Expression;
import com.yakindu.base.types.Operation;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression;
import com.yakindu.sct.simulation.core.sexec.interpreter.StextExpressionInterpreter;
import com.yakindu.sctunit.sCTUnit.AssertionStatement;
import com.yakindu.sctunit.sCTUnit.CodeBlock;
import com.yakindu.sctunit.sCTUnit.ExpressionStatement;
import com.yakindu.sctunit.sCTUnit.IfStatement;
import com.yakindu.sctunit.sCTUnit.LoopStatement;
import com.yakindu.sctunit.sCTUnit.MockReturnStatement;
import com.yakindu.sctunit.sCTUnit.ProceedExpression;
import com.yakindu.sctunit.sCTUnit.ProceedUnit;
import com.yakindu.sctunit.sCTUnit.ReturnStatement;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.TestStatement;
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement;
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement;
import com.yakindu.sctunit.simulation.core.junit.Failure;
import com.yakindu.sctunit.simulation.core.junit.TestCase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SuppressWarnings("all")
public class BaseSCTUnitTestCaseInterpreter extends StextExpressionInterpreter implements ISCTUnitTestCaseInterpreter {
  protected static class Return extends RuntimeException {
    private Object value;

    public Return(final Object value) {
      this.setValue(value);
    }

    public Object getValue() {
      return this.value;
    }

    public Object setValue(final Object value) {
      return this.value = value;
    }
  }

  @Inject
  protected ISCTUnitExecutionContextInitializer sctUnitContextInitializer;

  @Inject
  protected IFailureTracer failureTracer;

  @Inject
  protected ITimeTaskScheduler schedulingService;

  @Inject(optional = true)
  protected IProgressMonitor monitor = new NullProgressMonitor();

  protected TestCase testCase;

  protected long cyclePeriod = 200L;

  @Override
  public void init(final SCTUnitClass unitClass) {
    this.sctUnitContextInitializer.initialize(this.context, unitClass);
  }

  @Override
  public TestCase executeOperation(final SCTUnitOperation operation) {
    this.sctUnitContextInitializer.initialize(this.context, operation, Collections.<Expression>emptyList());
    TestCase _testCase = new TestCase();
    final Procedure1<TestCase> _function = (TestCase it) -> {
      it.setName(operation.getName());
      it.setClassName(EcoreUtil.getURI(operation).toString());
    };
    TestCase _doubleArrow = ObjectExtensions.<TestCase>operator_doubleArrow(_testCase, _function);
    this.testCase = _doubleArrow;
    try {
      EList<TestStatement> _code = operation.getBody().getCode();
      for (final TestStatement stm : _code) {
        {
          boolean _isCanceled = this.monitor.isCanceled();
          if (_isCanceled) {
            throw new OperationCanceledException();
          }
          boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.testCase.getFailures());
          if (_isNullOrEmpty) {
            this.executeStatement(stm);
          }
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof BaseSCTUnitTestCaseInterpreter.Return) {
      } else if (_t instanceof OperationCanceledException) {
        final Failure failure = new Failure();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Test execution was canceled.");
        failure.setMessage(_builder.toString());
        this.testCase.getFailures().add(failure);
      } else if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        final Failure failure_1 = new Failure();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Test failed due to \'");
        String _name = e.getClass().getName();
        _builder_1.append(_name);
        _builder_1.append("\': \"");
        String _message = e.getMessage();
        _builder_1.append(_message);
        _builder_1.append("\"");
        failure_1.setMessage(_builder_1.toString());
        this.testCase.getFailures().add(failure_1);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    this.sctUnitContextInitializer.dispose(this.context, operation);
    this.resetOperationMockups();
    return this.testCase;
  }

  protected void resetOperationMockups() {
    Iterable<SCTUnitOperationMockup> _filter = null;
    if (this.operationExecutors!=null) {
      _filter=Iterables.<SCTUnitOperationMockup>filter(this.operationExecutors, SCTUnitOperationMockup.class);
    }
    final Consumer<SCTUnitOperationMockup> _function = (SCTUnitOperationMockup it) -> {
      it.reset();
    };
    _filter.forEach(_function);
  }

  public Object executeStatement(final SCTUnitOperation operation, final List<Expression> args, final TestCase testCase, final SCTUnitOperation owner) {
    this.sctUnitContextInitializer.initialize(this.context, operation, args, owner);
    try {
      return this.executeStatement(operation.getBody());
    } catch (final Throwable _t) {
      if (_t instanceof BaseSCTUnitTestCaseInterpreter.Return) {
        final BaseSCTUnitTestCaseInterpreter.Return r = (BaseSCTUnitTestCaseInterpreter.Return)_t;
        return r.value;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }

  protected Object _executeStatement(final Expression expression) {
    return this.evaluate(expression, this.context);
  }

  protected Object _executeStatement(final ExpressionStatement stm) {
    Object _xblockexpression = null;
    {
      Object _executeStatement = this.executeStatement(stm.getExpression());
      Object _asValue = null;
      if (_executeStatement!=null) {
        _asValue=this.valueSemantics.asValue(_executeStatement);
      }
      final Object result = _asValue;
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  protected Object _executeStatement(final ReturnStatement stm) {
    Object _xifexpression = null;
    Expression _returnValue = stm.getReturnValue();
    boolean _tripleNotEquals = (_returnValue != null);
    if (_tripleNotEquals) {
      _xifexpression = this.valueSemantics.asValue(this.evaluate(stm.getReturnValue(), this.context));
    } else {
      _xifexpression = null;
    }
    throw new BaseSCTUnitTestCaseInterpreter.Return(_xifexpression);
  }

  protected Object _executeStatement(final VariableDefinitionStatement stm) {
    Object _xblockexpression = null;
    {
      final SCTUnitOperation op = EcoreUtil2.<SCTUnitOperation>getContainerOfType(stm, SCTUnitOperation.class);
      this.sctUnitContextInitializer.initialize(this.context, stm.getDefinition(), op);
      _xblockexpression = null;
    }
    return _xblockexpression;
  }

  protected Object _executeStatement(final CodeBlock it) {
    Object _xblockexpression = null;
    {
      boolean _isCanceled = this.monitor.isCanceled();
      if (_isCanceled) {
        throw new OperationCanceledException();
      }
      Object lastResult = null;
      EList<TestStatement> _code = it.getCode();
      for (final TestStatement statement : _code) {
        {
          boolean _isCanceled_1 = this.monitor.isCanceled();
          if (_isCanceled_1) {
            throw new OperationCanceledException();
          }
          lastResult = this.executeStatement(statement);
        }
      }
      _xblockexpression = lastResult;
    }
    return _xblockexpression;
  }

  protected Object _execute(final ProceedExpression stm) {
    Object _value = this.value(stm.getValue());
    final Long proceedValue = ((Long) _value);
    ProceedUnit _unit = stm.getUnit();
    boolean _equals = Objects.equals(_unit, ProceedUnit.CYCLES);
    if (_equals) {
      final int cycles = proceedValue.intValue();
      this.schedulingService.cycleLeap(cycles);
    } else {
      this.schedulingService.timeLeap(this.toMilliseconds((proceedValue).longValue(), stm.getUnit()));
    }
    return null;
  }

  public long toMilliseconds(final long value, final ProceedUnit unit) {
    long _switchResult = (long) 0;
    if (unit != null) {
      switch (unit) {
        case MILLISECOND:
          _switchResult = value;
          break;
        case MICROSECOND:
          _switchResult = (value / 1_000);
          break;
        case NANOSECOND:
          _switchResult = (value / 1_000_000);
          break;
        case SECOND:
          _switchResult = (value * 1_000);
          break;
        default:
          _switchResult = value;
          break;
      }
    } else {
      _switchResult = value;
    }
    return _switchResult;
  }

  protected Object _executeStatement(final AssertionStatement stm) {
    Object _xblockexpression = null;
    {
      Object _asValue = this.valueSemantics.asValue(this.evaluate(stm.getExpression(), this.context));
      Boolean valid = ((Boolean) _asValue);
      if ((!(valid).booleanValue())) {
        this.testCase.getFailures().add(this.failureTracer.getFailureStack(stm, this.context));
      }
      _xblockexpression = null;
    }
    return _xblockexpression;
  }

  @Override
  public void tearDown() {
    this.schedulingService.terminate();
    this.context = null;
  }

  @Override
  public ExecutionContext getExecutionContext() {
    return this.context;
  }

  @Override
  protected Object _execute(final ElementReferenceExpression expression) {
    SCTUnitOperation _expressionSCTUnitOperation = this.getExpressionSCTUnitOperation(expression);
    boolean _tripleNotEquals = (_expressionSCTUnitOperation != null);
    if (_tripleNotEquals) {
      final SCTUnitOperation owner = EcoreUtil2.<SCTUnitOperation>getContainerOfType(expression, SCTUnitOperation.class);
      return this.executeStatement(this.getExpressionSCTUnitOperation(expression), expression.getExpressions(), this.testCase, owner);
    }
    return this.executeElementReferenceExpression(expression);
  }

  protected Object _executeStatement(final VerifyCalledStatement it) {
    Object _xblockexpression = null;
    {
      final Function1<Expression, Object> _function = (Expression it_1) -> {
        return this.executeStatement(it_1);
      };
      final Failure failure = this.failureTracer.getFailureStack(it, ListExtensions.<Expression, Object>map(this.getParams(it.getReference()), _function));
      if ((failure != null)) {
        this.testCase.getFailures().add(failure);
      }
      _xblockexpression = null;
    }
    return _xblockexpression;
  }

  protected Object _executeStatement(final MockReturnStatement stm) {
    List<Object> _xifexpression = null;
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.getOperationArgs(stm.getReference()));
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      final Function1<Expression, Object> _function = (Expression exp) -> {
        return this.executeStatement(exp);
      };
      _xifexpression = ListExtensions.<Expression, Object>map(this.getOperationArgs(stm.getReference()), _function);
    } else {
      _xifexpression = Collections.EMPTY_LIST;
    }
    final List<Object> args = _xifexpression;
    Iterable<SCTUnitOperationMockup> _filter = null;
    if (this.operationExecutors!=null) {
      _filter=Iterables.<SCTUnitOperationMockup>filter(this.operationExecutors, SCTUnitOperationMockup.class);
    }
    final Consumer<SCTUnitOperationMockup> _function_1 = (SCTUnitOperationMockup it) -> {
      it.mockReturnValue(this.getOperation(stm.getReference()), args, stm.getValue());
    };
    _filter.forEach(_function_1);
    return null;
  }

  @Override
  protected Object _execute(final FeatureCall call) {
    SCTUnitOperation _expressionSCTUnitOperation = this.getExpressionSCTUnitOperation(call);
    boolean _tripleNotEquals = (_expressionSCTUnitOperation != null);
    if (_tripleNotEquals) {
      final SCTUnitOperation owner = EcoreUtil2.<SCTUnitOperation>getContainerOfType(call, SCTUnitOperation.class);
      return this.executeStatement(this.getExpressionSCTUnitOperation(call), call.getExpressions(), this.testCase, owner);
    } else {
      return this.executeFeatureCall(call);
    }
  }

  protected SCTUnitOperation _getExpressionSCTUnitOperation(final ElementReferenceExpression it) {
    EObject reference = it.getReference();
    if ((reference instanceof SCTUnitOperation)) {
      return ((SCTUnitOperation) reference);
    }
    return null;
  }

  protected SCTUnitOperation _getExpressionSCTUnitOperation(final FeatureCall it) {
    EObject _feature = it.getFeature();
    if ((_feature instanceof SCTUnitOperation)) {
      EObject _feature_1 = it.getFeature();
      return ((SCTUnitOperation) _feature_1);
    }
    return null;
  }

  protected List<Expression> _getOperationArgs(final ArgumentExpression it) {
    return it.getExpressions();
  }

  protected List<Expression> _getOperationArgs(final Expression it) {
    return null;
  }

  protected Operation _getOperation(final Expression it) {
    return null;
  }

  protected Operation _getOperation(final FeatureCall it) {
    EObject _feature = it.getFeature();
    return ((Operation) _feature);
  }

  protected Operation _getOperation(final ElementReferenceExpression it) {
    EObject _reference = it.getReference();
    return ((Operation) _reference);
  }

  protected List<Expression> _getParams(final Expression it) {
    return Collections.<Expression>emptyList();
  }

  protected List<Expression> _getParams(final ArgumentExpression it) {
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(it.getExpressions());
    if (_isNullOrEmpty) {
      return Collections.<Expression>emptyList();
    } else {
      return it.getExpressions();
    }
  }

  protected Object _executeStatement(final LoopStatement stm) {
    Object _evaluate = this.evaluate(stm.getGuard(), this.context);
    Boolean condition = ((Boolean) _evaluate);
    Object result = null;
    while ((condition).booleanValue()) {
      {
        result = this.executeStatement(stm.getBody());
        Object _evaluate_1 = this.evaluate(stm.getGuard(), this.context);
        condition = ((Boolean) _evaluate_1);
      }
    }
    return result;
  }

  protected Object _executeStatement(final IfStatement stm) {
    Object _evaluate = this.evaluate(stm.getCondition(), this.context);
    final Boolean condition = ((Boolean) _evaluate);
    Object result = null;
    if ((condition).booleanValue()) {
      result = this.executeStatement(stm.getThen());
    } else {
      CodeBlock _else = stm.getElse();
      boolean _tripleNotEquals = (_else != null);
      if (_tripleNotEquals) {
        result = this.executeStatement(stm.getElse());
      }
    }
    return result;
  }

  @Override
  public Object executeOperation(final IOperationExecutor executor, final ArgumentExpression expression) {
    final Object result = super.executeOperation(executor, expression);
    if ((result instanceof Expression)) {
      return this.executeStatement(((EObject)result));
    }
    return result;
  }

  @XbaseGenerated
  public Object executeStatement(final EObject stm) {
    if (stm instanceof MockReturnStatement) {
      return _executeStatement((MockReturnStatement)stm);
    } else if (stm instanceof VerifyCalledStatement) {
      return _executeStatement((VerifyCalledStatement)stm);
    } else if (stm instanceof AssertionStatement) {
      return _executeStatement((AssertionStatement)stm);
    } else if (stm instanceof ExpressionStatement) {
      return _executeStatement((ExpressionStatement)stm);
    } else if (stm instanceof IfStatement) {
      return _executeStatement((IfStatement)stm);
    } else if (stm instanceof LoopStatement) {
      return _executeStatement((LoopStatement)stm);
    } else if (stm instanceof ReturnStatement) {
      return _executeStatement((ReturnStatement)stm);
    } else if (stm instanceof VariableDefinitionStatement) {
      return _executeStatement((VariableDefinitionStatement)stm);
    } else if (stm instanceof Expression) {
      return _executeStatement((Expression)stm);
    } else if (stm instanceof CodeBlock) {
      return _executeStatement((CodeBlock)stm);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(stm).toString());
    }
  }

  @Override
  @XbaseGenerated
  public Object execute(final Expression expression) {
    if (expression instanceof BitwiseAndExpression) {
      return _execute((BitwiseAndExpression)expression);
    } else if (expression instanceof BitwiseOrExpression) {
      return _execute((BitwiseOrExpression)expression);
    } else if (expression instanceof BitwiseXorExpression) {
      return _execute((BitwiseXorExpression)expression);
    } else if (expression instanceof ElementReferenceExpression) {
      return _execute((ElementReferenceExpression)expression);
    } else if (expression instanceof FeatureCall) {
      return _execute((FeatureCall)expression);
    } else if (expression instanceof LogicalAndExpression) {
      return _execute((LogicalAndExpression)expression);
    } else if (expression instanceof LogicalNotExpression) {
      return _execute((LogicalNotExpression)expression);
    } else if (expression instanceof LogicalOrExpression) {
      return _execute((LogicalOrExpression)expression);
    } else if (expression instanceof LogicalRelationExpression) {
      return _execute((LogicalRelationExpression)expression);
    } else if (expression instanceof NumericalAddSubtractExpression) {
      return _execute((NumericalAddSubtractExpression)expression);
    } else if (expression instanceof NumericalMultiplyDivideExpression) {
      return _execute((NumericalMultiplyDivideExpression)expression);
    } else if (expression instanceof NumericalUnaryExpression) {
      return _execute((NumericalUnaryExpression)expression);
    } else if (expression instanceof PostFixUnaryExpression) {
      return _execute((PostFixUnaryExpression)expression);
    } else if (expression instanceof ShiftExpression) {
      return _execute((ShiftExpression)expression);
    } else if (expression instanceof AssignmentExpression) {
      return _execute((AssignmentExpression)expression);
    } else if (expression instanceof ConditionalExpression) {
      return _execute((ConditionalExpression)expression);
    } else if (expression instanceof EventRaisingExpression) {
      return _execute((EventRaisingExpression)expression);
    } else if (expression instanceof EventValueReferenceExpression) {
      return _execute((EventValueReferenceExpression)expression);
    } else if (expression instanceof ParenthesizedExpression) {
      return _execute((ParenthesizedExpression)expression);
    } else if (expression instanceof PrimitiveValueExpression) {
      return _execute((PrimitiveValueExpression)expression);
    } else if (expression instanceof TypeCastExpression) {
      return _execute((TypeCastExpression)expression);
    } else if (expression instanceof ActiveStateReferenceExpression) {
      return _execute((ActiveStateReferenceExpression)expression);
    } else if (expression instanceof ProceedExpression) {
      return _execute((ProceedExpression)expression);
    } else if (expression != null) {
      return _execute(expression);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(expression).toString());
    }
  }

  @XbaseGenerated
  public SCTUnitOperation getExpressionSCTUnitOperation(final ArgumentExpression it) {
    if (it instanceof ElementReferenceExpression) {
      return _getExpressionSCTUnitOperation((ElementReferenceExpression)it);
    } else if (it instanceof FeatureCall) {
      return _getExpressionSCTUnitOperation((FeatureCall)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public List<Expression> getOperationArgs(final Expression it) {
    if (it instanceof ArgumentExpression) {
      return _getOperationArgs((ArgumentExpression)it);
    } else if (it != null) {
      return _getOperationArgs(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public Operation getOperation(final Expression it) {
    if (it instanceof ElementReferenceExpression) {
      return _getOperation((ElementReferenceExpression)it);
    } else if (it instanceof FeatureCall) {
      return _getOperation((FeatureCall)it);
    } else if (it != null) {
      return _getOperation(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  @XbaseGenerated
  public List<Expression> getParams(final Expression it) {
    if (it instanceof ArgumentExpression) {
      return _getParams((ArgumentExpression)it);
    } else if (it != null) {
      return _getParams(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
