/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.concepts

import com.google.inject.Inject
import com.yakindu.sct.model.sgraph.Exit
import com.yakindu.sct.model.sgraph.FinalState
import com.yakindu.sct.model.sgraph.Synchronization
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import com.yakindu.sct.model.stext.stext.ExitPointSpec

class ExitTransition {

	@Inject protected extension SgraphExtensions

	def isExitTransition(Transition it) {
			trigger === null && !(target instanceof Synchronization) && source.eContents.allPseudoStates.filter(Exit).size > 0 &&
				source.allStates[isLeaf].filter(FinalState).size == 0
	}
	
	def isDefaultExitTransition(Transition it){
		val exits = properties.filter(ExitPointSpec)
		if (!exits.isEmpty())
			!exits.forall[!exitpoint.equalsIgnoreCase("default")]
		else
			isExitTransition
	}
	
	def isNamedExitTransition(Transition it, String name) {
		!properties.filter(ExitPointSpec).forall[p|!name.equals(p.exitpoint)]
	}
	
	def isNamedExitTransition(Transition it) {
		properties.exists[p | p instanceof ExitPointSpec]
	}
	
	
	/**
	 * Returns the name of the specified entry point or 'default' if it does not exist
	 */
	def String exitPointName(Transition t) {
		val eps = t.properties.filter(typeof(ExitPointSpec)).head
		
		if (eps === null) 'default' else eps.exitpoint	
	}
}
