/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.types

import com.google.inject.Inject
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Package
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.annotations.NamespaceAnnotations
import java.util.List
import org.eclipse.emf.ecore.EObject

/**
 * This extension class implements basic literal name resolution. These literals can be overwritten target language specifically by generators.
 * 
 * @author axel terfloth
 */
abstract class Literals {
	
	@Inject protected extension NamespaceAnnotations
	
	public static final String TRUE_LITERAL_NAME = "true";
	public static final String FALSE_LITERAL_NAME = "false";
	
	abstract def String NULL_LITERAL()
	def String TRUE_LITERAL() { TRUE_LITERAL_NAME }
	def String FALSE_LITERAL() { FALSE_LITERAL_NAME }
	abstract def String ENUM_SEPARATOR()
	abstract def String NAMESPACE_SEPARATOR()
		
	
	def dispatch String asLiteral(Object v) {
		NULL_LITERAL	
	}
	
	
	def dispatch String asLiteral(Void v) {
		NULL_LITERAL	
	}
	
	def dispatch String asLiteral(String v) {
		'''"«v»"'''	
	}
	
	def dispatch String asLiteral(Boolean v) {
		if (v) TRUE_LITERAL  
		else   FALSE_LITERAL 
	}

	def dispatch String asLiteral(Number v) {
		v.toString 
	}
	
	def dispatch String asLiteral(TypeSpecifier it) {
		type.asLiteral
	} 
	
	def dispatch String asLiteral(Type it) 
		'''«namespacePath»«name»''' 
	
	def dispatch String asLiteral(Package it) 
		'''«namespacePath»«name»'''	
	
	def dispatch String asLiteral(Declaration it)
		'''«namespacePath»«name»'''
		
	def dispatch String asLiteral(Enumerator e) {
		'''«e.owningEnumeration.asLiteral»«ENUM_SEPARATOR»«e.name»'''
	}
	
	
	def dispatch String asLiteral(List<Object> list) {
		'''«FOR t : list SEPARATOR ','»«t.asListLiteral»«ENDFOR»'''
	}

	def dispatch asListLiteral(Object it) '''«it.asLiteral»'''
	def dispatch asListLiteral(List<Object> it) '''{«it.asLiteral»}'''
		
	def String namespacePath(EObject it) 
		'''«IF eContainer !== null && ! eContainer.isNoNamespace && eContainer.hasName»«eContainer.asLiteral»«NAMESPACE_SEPARATOR»«ENDIF»'''
		
	def dispatch protected hasName(EObject obj){
		true
	}
	
	def dispatch protected hasName(Package p){
		! p.name.isNullOrEmpty
	}
	
	
}
