/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.IHeaderFragment
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.List

class StatemachineHeader implements IContentTemplate<ExecutionFlow> {
	@Inject protected extension FileNaming
	@Inject protected extension INamingService
	
	protected List<IHeaderFragment> contentProviders = newArrayList
	
	def List<IHeaderFragment> getContentProviders() {
		contentProviders
	}
	
	override content(ExecutionFlow it, GeneratorEntry entry , IGenArtifactConfigurations artifactConfigs) {
		initializeNamingService
	'''
			«fileComment(entry, artifactConfigs)»
			
			#ifndef «module.define»_H_
			#define «module.define»_H_
			
			#ifdef __cplusplus
			extern "C" { 
			#endif
			
			«forwardDeclarations(entry, artifactConfigs)»
			
			#ifdef __cplusplus
			}
			#endif
			
			«includes(entry, artifactConfigs)»
			
			#ifdef __cplusplus
			extern "C" { 
			#endif 
			
			/*! \file
			Header of the state machine '«name»'.
			*/
			
			«defines(entry, artifactConfigs)»
			
			«types(entry, artifactConfigs)»
			
			«functions(entry, artifactConfigs)»
			
			#ifdef __cplusplus
			}
			#endif 
			
			#endif /* «module.define»_H_ */
		'''
	}
	
	def fileComment(ExecutionFlow it, GeneratorEntry entry , IGenArtifactConfigurations artifactConfigs) {
		'''
			«FOR p : contentProviders»
				«p.fileComment(it, entry, artifactConfigs)»
			«ENDFOR»
		'''
	}
	
	def forwardDeclarations(ExecutionFlow it, GeneratorEntry entry , IGenArtifactConfigurations artifactConfigs) {
		'''
			«FOR p : contentProviders»
				«p.forwardDeclarations(it, entry, artifactConfigs)»
			«ENDFOR»
		'''
	}
	
	def includes(ExecutionFlow it, GeneratorEntry entry , IGenArtifactConfigurations artifactConfigs) {
		'''
			«FOR p : contentProviders»
				«p.includes(it, entry, artifactConfigs)»
			«ENDFOR»
		'''
	}
	
	def defines(ExecutionFlow it, GeneratorEntry entry , IGenArtifactConfigurations artifactConfigs) {
		'''
			«FOR p : contentProviders»
				«p.defines(it, entry, artifactConfigs)»
			«ENDFOR»
		'''
	}
	
	def types(ExecutionFlow it, GeneratorEntry entry , IGenArtifactConfigurations artifactConfigs) {
		'''
			«FOR p : contentProviders»
				«p.types(it, entry, artifactConfigs)»
			«ENDFOR»
		'''
	}
	
	def functions(ExecutionFlow it, GeneratorEntry entry , IGenArtifactConfigurations artifactConfigs) {
		'''
			«FOR p : contentProviders»
				«p.functions(it, entry, artifactConfigs)»
			«ENDFOR»
		'''
	}
}
