/**
 * Copyright (c) 2023-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.itemis.create.sctunit.generator.csharp

import com.google.inject.Inject
import com.google.inject.Provider
import com.itemis.create.base.generator.core.artifacts.IContent
import com.itemis.create.base.generator.csharp.artifacts.CSharpFile
import com.itemis.create.base.generator.csharp.codemodel.CsharpCompilationUnit
import com.itemis.create.sctunit.transformation.SCTUnit2SUnitTransformation
import com.itemis.create.statechart.generator.csharp.transformation.SctTypes2CsharpTypesTransformation
import com.itemis.create.sunit.generator.csharp.nunit.codemodel.NUnitAnnotations
import com.itemis.create.sunit.generator.csharp.nunit.transformation.SUnit2NunitTransformation
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations.GenArtifactConfiguration
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator
import com.yakindu.sctunit.generator.base.SCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.TestPackage
import org.eclipse.xtext.generator.IFileSystemAccess

import static com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess.*

/**
 * 
 * @author Axel Terfloth
 * 
 */
class CsharpSCTUnitGenerator implements ISCTUnitGenerator {

	@Inject protected extension SCTUnitGenmodelEntries
	@Inject IGenArtifactConfigurations locations
	
	@Inject protected ICoreLibraryHelper helper
	@Inject protected Provider<CSharpFile> fileProvider
	@Inject protected Provider<SCTUnit2SUnitTransformation> sctUnit2SUnitProvider
	@Inject protected Provider<SUnit2NunitTransformation> sUnit2NUnitProvider
	@Inject protected Provider<SctTypes2CsharpTypesTransformation> sctTypes2CsharpTypesProvider
	@Inject protected extension CsharpCompilationUnit
	@Inject protected extension NUnitAnnotations
	
	
	override generate(GeneratorEntry entry, IFileSystemAccess fsa) {

		initGenerationArtifacts(entry, fsa)
		generateArtifacts(entry, fsa, locations)
	}
	
	
	def initGenerationArtifacts(GeneratorEntry entry, IFileSystemAccess fsa) {
		
		val sunitPackage = sctUnit2SUnitProvider.get.transform(entry.sctUnitPackage)
		val nunitPackage = sUnit2NUnitProvider.get.transform(sunitPackage)
		val nunitTest = nunitPackage.eAllContents.filter(ComplexType).filter[isTestFixture].head
		nunitTest.features.filter(Operation).forEach[ op |
			sctTypes2CsharpTypesProvider.get.substitueStateEnumMethodMember(op, nunitTest)
		]
				
		nunitPackage.eAllContents.filter(Package).filter[ isCompilationUnit ].forEach[ pkg |
			fileProvider.get => [
				compilationUnit = pkg
				locations.configure(fileName, TARGET_FOLDER_OUTPUT, it)
			]
		]		
	}
	
	def generateArtifacts(GeneratorEntry entry, IFileSystemAccess fsa,
		IGenArtifactConfigurations locations) {
		for (GenArtifactConfiguration a : locations.configurations
		) {
			if (!a.skip) {
				fsa.generateFile(a.getName, a.getOutputName, a.getArtifact.fileContent)
			}
		}
	}
	
	def dispatch String fileContent(IContent it) {
		it.content()
	}
	
	def dispatch String fileContent(Object it) {
		""
	}
	
	def sctUnitPackage(GeneratorEntry entry) {
		return entry.elementRef.eContainer as TestPackage
	}
	
}
