/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.statechart.generator.csharp.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.base.types.adapter.OriginTracing
import com.itemis.create.statechart.generator.csharp.codepattern.CsharpStatemachineExpressionCode
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.itemis.create.base.generator.csharp.features.CsharpGenmodelEntries

import static com.itemis.create.statechart.generator.csharp.codemodel.CsharpNamedInterfaceClasses.PARENT

/**
 * Defines the constructor for a statemachine if it is required (when parent children relation is needed).
 * @author laszlo kovacs
 *
 */
class CsharpStatemachineConstructor {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension OriginTracing
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension Literals
	@Inject protected extension CsharpTypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension CsharpStatemachineExpressionCode
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension CsharpGenmodelEntries
	@Inject protected GeneratorEntry entry
	
	protected extension ExpressionsFactory expFactory = ExpressionsFactory.eINSTANCE
	
	def defineConstructor(ComplexType stm){
		if(!stm.eAllContents.filter(TypedDeclaration).filter[isRequired && !userDeclared].nullOrEmpty || entry.tracingGeneric)
			stm.features += _op(stm.name) => [
				_public
				generateDefinitionWith[ '''
						[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
						«visibility.visibilityName» «name»(){
							«FOR m : stm.eAllContents.filter(TypedDeclaration).filter[(isRequired && !userDeclared) || hasParent ].toList»
								«m.name» = new «m.type.asLiteral»(this);
							«ENDFOR»
							«FOR m : stm.eAllContents.filter(Property).filter[isRequired && userDeclared && origin instanceof Property].toList»
								«m.name» = «(m.origin as Property).initialValue.code»;
							«ENDFOR»
						}
					''' ]			
			]
	}
	
	def protected dispatch hasParent(ComplexType it){
		features.filter(Property).exists[name == PARENT]
	}
	
	def protected dispatch hasParent(TypedDeclaration it){
		false
	}
}
