/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.codepattern

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.c.codepattern.ScopeTypeDeclarationCode
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.base.types.Direction

/**
 * Member declaration for scopes 
 * 
 * @author laszlo kovacs- Initial contribution.
 */
class CppScopeTypeDeclarationCode extends ScopeTypeDeclarationCode {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppSpecifiers
	@Inject protected extension INamingService
	@Inject protected extension SExecExtensions
	
	override dispatch scopeTypeDeclMember(Event it){
		if(requiresObservable) '''
			«IF needsObservable»
				«scRxNS»::Observable<«typeSpecifier.targetLanguageName»> «observable»;
			«ENDIF»
			«IF (useOutEventGetters && direction == Direction.OUT) || direction == Direction.IN || direction == Direction.LOCAL»
				«sc_bool.fqName» «eventRaisedFlag»;
				«IF type !== null && type.name != 'void'»«typeSpecifier.targetLanguageName» «eventValueVariable»;«ENDIF»
			«ENDIF»
		'''
	} 
	
	override dispatch scopeTypeDeclMember(Property it) '''
		«IF type.name != 'void'»«IF const»static const «ENDIF»«typeSpecifier.targetLanguageName» «name.asEscapedIdentifier»;«ENDIF»
	'''
}