/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

/**
 * This extension defines event instance classes. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class EventInstanceClasses {

	public static final String EVENT_INSTANCE_CLASS_NAME = "EventInstance"
	public static final String EVENT_INSTANCE_WITH_VALUE_CLASS_NAME = "EventInstanceWithValue"

	@Inject protected extension EventQueue
	
	@Inject protected extension EventEnum
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension StatemachineClass
	@Inject protected extension NamedInterfaceClasses
	@Inject protected extension CppSpecifiers	
	
	def void defineEventInstanceClasses(ExecutionFlow flow) {
		
		_complexType(EVENT_INSTANCE_CLASS_NAME) => [
			_public
			flow.stateMachineClass.features += it;
			generateDeclarationWith['''
				class «EVENT_INSTANCE_CLASS_NAME»
				{
					public:
						«_explicit» «EVENT_INSTANCE_CLASS_NAME»(«flow.eventEnum.name» id)«_noexcept» : eventId(id){}
						virtual ~«EVENT_INSTANCE_CLASS_NAME»() = default;
						const «flow.eventEnum.name» eventId;
				};
			''']
		]
		
		if ( flow.queuedEvents.withValue.exist ) {
			_complexType(EVENT_INSTANCE_WITH_VALUE_CLASS_NAME) => [
				_public
				flow.stateMachineClass.features += it;
				generateDeclarationWith['''
					template <typename T>
					class «EVENT_INSTANCE_WITH_VALUE_CLASS_NAME» : public «EVENT_INSTANCE_CLASS_NAME»
					{
						public:
							«_explicit» «EVENT_INSTANCE_WITH_VALUE_CLASS_NAME»(«flow.eventEnum.name» id, T val)«flow.propertyThrowsException» : 
								«EVENT_INSTANCE_CLASS_NAME»(id),
								value(val)
							{}
							virtual ~«EVENT_INSTANCE_WITH_VALUE_CLASS_NAME»() = default;
							const T value;
					};
				''']	
			]
		}
		
	}
		
	def eventInstanceClass(ExecutionFlow it) {
		stateMachineClass.features.filter(ComplexType).filter[ name == EVENT_INSTANCE_CLASS_NAME].head
	}
	
	def eventInstanceWithValueClass(ExecutionFlow it) {
		stateMachineClass.features.filter(ComplexType).filter[ name == EVENT_INSTANCE_WITH_VALUE_CLASS_NAME].head
	}
	
}
