/*
*
* Copyright (c) 2025 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
grammar InternalSCTUnit;

options {
	superClass=AbstractInternalContentAssistParser;
	backtrack=true;
}

@lexer::header {
package com.yakindu.sctunit.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package com.yakindu.sctunit.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import com.yakindu.sctunit.services.SCTUnitGrammarAccess;

}
@parser::members {
	private SCTUnitGrammarAccess grammarAccess;

	public void setGrammarAccess(SCTUnitGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleTestPackage
entryRuleTestPackage
:
{ before(grammarAccess.getTestPackageRule()); }
	 ruleTestPackage
{ after(grammarAccess.getTestPackageRule()); } 
	 EOF 
;

// Rule TestPackage
ruleTestPackage 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTestPackageAccess().getGroup()); }
		(rule__TestPackage__Group__0)
		{ after(grammarAccess.getTestPackageAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSCTUnitElement
entryRuleSCTUnitElement
:
{ before(grammarAccess.getSCTUnitElementRule()); }
	 ruleSCTUnitElement
{ after(grammarAccess.getSCTUnitElementRule()); } 
	 EOF 
;

// Rule SCTUnitElement
ruleSCTUnitElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSCTUnitElementAccess().getAlternatives()); }
		(rule__SCTUnitElement__Alternatives)
		{ after(grammarAccess.getSCTUnitElementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSCTUnitClass
entryRuleSCTUnitClass
:
{ before(grammarAccess.getSCTUnitClassRule()); }
	 ruleSCTUnitClass
{ after(grammarAccess.getSCTUnitClassRule()); } 
	 EOF 
;

// Rule SCTUnitClass
ruleSCTUnitClass 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSCTUnitClassAccess().getGroup()); }
		(rule__SCTUnitClass__Group__0)
		{ after(grammarAccess.getSCTUnitClassAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSCTUnitSuite
entryRuleSCTUnitSuite
:
{ before(grammarAccess.getSCTUnitSuiteRule()); }
	 ruleSCTUnitSuite
{ after(grammarAccess.getSCTUnitSuiteRule()); } 
	 EOF 
;

// Rule SCTUnitSuite
ruleSCTUnitSuite 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSCTUnitSuiteAccess().getGroup()); }
		(rule__SCTUnitSuite__Group__0)
		{ after(grammarAccess.getSCTUnitSuiteAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSCTUnitClassReference
entryRuleSCTUnitClassReference
:
{ before(grammarAccess.getSCTUnitClassReferenceRule()); }
	 ruleSCTUnitClassReference
{ after(grammarAccess.getSCTUnitClassReferenceRule()); } 
	 EOF 
;

// Rule SCTUnitClassReference
ruleSCTUnitClassReference 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSCTUnitClassReferenceAccess().getTypeSpecifierAssignment()); }
		(rule__SCTUnitClassReference__TypeSpecifierAssignment)
		{ after(grammarAccess.getSCTUnitClassReferenceAccess().getTypeSpecifierAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSimpleTypeSpecifier
entryRuleSimpleTypeSpecifier
:
{ before(grammarAccess.getSimpleTypeSpecifierRule()); }
	 ruleSimpleTypeSpecifier
{ after(grammarAccess.getSimpleTypeSpecifierRule()); } 
	 EOF 
;

// Rule SimpleTypeSpecifier
ruleSimpleTypeSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSimpleTypeSpecifierAccess().getTypeAssignment()); }
		(rule__SimpleTypeSpecifier__TypeAssignment)
		{ after(grammarAccess.getSimpleTypeSpecifierAccess().getTypeAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSCTUnitOperation
entryRuleSCTUnitOperation
:
{ before(grammarAccess.getSCTUnitOperationRule()); }
	 ruleSCTUnitOperation
{ after(grammarAccess.getSCTUnitOperationRule()); } 
	 EOF 
;

// Rule SCTUnitOperation
ruleSCTUnitOperation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSCTUnitOperationAccess().getGroup()); }
		(rule__SCTUnitOperation__Group__0)
		{ after(grammarAccess.getSCTUnitOperationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCodeBlock
entryRuleCodeBlock
:
{ before(grammarAccess.getCodeBlockRule()); }
	 ruleCodeBlock
{ after(grammarAccess.getCodeBlockRule()); } 
	 EOF 
;

// Rule CodeBlock
ruleCodeBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCodeBlockAccess().getGroup()); }
		(rule__CodeBlock__Group__0)
		{ after(grammarAccess.getCodeBlockAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTestStatement
entryRuleTestStatement
:
{ before(grammarAccess.getTestStatementRule()); }
	 ruleTestStatement
{ after(grammarAccess.getTestStatementRule()); } 
	 EOF 
;

// Rule TestStatement
ruleTestStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTestStatementAccess().getAlternatives()); }
		(rule__TestStatement__Alternatives)
		{ after(grammarAccess.getTestStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMockingStatement
entryRuleMockingStatement
:
{ before(grammarAccess.getMockingStatementRule()); }
	 ruleMockingStatement
{ after(grammarAccess.getMockingStatementRule()); } 
	 EOF 
;

// Rule MockingStatement
ruleMockingStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMockingStatementAccess().getAlternatives()); }
		(rule__MockingStatement__Alternatives)
		{ after(grammarAccess.getMockingStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVerifyCalledStatement
entryRuleVerifyCalledStatement
:
{ before(grammarAccess.getVerifyCalledStatementRule()); }
	 ruleVerifyCalledStatement
{ after(grammarAccess.getVerifyCalledStatementRule()); } 
	 EOF 
;

// Rule VerifyCalledStatement
ruleVerifyCalledStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVerifyCalledStatementAccess().getGroup()); }
		(rule__VerifyCalledStatement__Group__0)
		{ after(grammarAccess.getVerifyCalledStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMockReturnStatement
entryRuleMockReturnStatement
:
{ before(grammarAccess.getMockReturnStatementRule()); }
	 ruleMockReturnStatement
{ after(grammarAccess.getMockReturnStatementRule()); } 
	 EOF 
;

// Rule MockReturnStatement
ruleMockReturnStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMockReturnStatementAccess().getGroup()); }
		(rule__MockReturnStatement__Group__0)
		{ after(grammarAccess.getMockReturnStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssertionStatement
entryRuleAssertionStatement
:
{ before(grammarAccess.getAssertionStatementRule()); }
	 ruleAssertionStatement
{ after(grammarAccess.getAssertionStatementRule()); } 
	 EOF 
;

// Rule AssertionStatement
ruleAssertionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssertionStatementAccess().getGroup()); }
		(rule__AssertionStatement__Group__0)
		{ after(grammarAccess.getAssertionStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExitExpression
entryRuleExitExpression
:
{ before(grammarAccess.getExitExpressionRule()); }
	 ruleExitExpression
{ after(grammarAccess.getExitExpressionRule()); } 
	 EOF 
;

// Rule ExitExpression
ruleExitExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExitExpressionAccess().getGroup()); }
		(rule__ExitExpression__Group__0)
		{ after(grammarAccess.getExitExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnterExpression
entryRuleEnterExpression
:
{ before(grammarAccess.getEnterExpressionRule()); }
	 ruleEnterExpression
{ after(grammarAccess.getEnterExpressionRule()); } 
	 EOF 
;

// Rule EnterExpression
ruleEnterExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnterExpressionAccess().getGroup()); }
		(rule__EnterExpression__Group__0)
		{ after(grammarAccess.getEnterExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTriggerWithoutEventExpression
entryRuleTriggerWithoutEventExpression
:
{ before(grammarAccess.getTriggerWithoutEventExpressionRule()); }
	 ruleTriggerWithoutEventExpression
{ after(grammarAccess.getTriggerWithoutEventExpressionRule()); } 
	 EOF 
;

// Rule TriggerWithoutEventExpression
ruleTriggerWithoutEventExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTriggerWithoutEventExpressionAccess().getGroup()); }
		(rule__TriggerWithoutEventExpression__Group__0)
		{ after(grammarAccess.getTriggerWithoutEventExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleProceedExpression
entryRuleProceedExpression
:
{ before(grammarAccess.getProceedExpressionRule()); }
	 ruleProceedExpression
{ after(grammarAccess.getProceedExpressionRule()); } 
	 EOF 
;

// Rule ProceedExpression
ruleProceedExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getProceedExpressionAccess().getGroup()); }
		(rule__ProceedExpression__Group__0)
		{ after(grammarAccess.getProceedExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimaryExpression
entryRulePrimaryExpression
:
{ before(grammarAccess.getPrimaryExpressionRule()); }
	 rulePrimaryExpression
{ after(grammarAccess.getPrimaryExpressionRule()); } 
	 EOF 
;

// Rule PrimaryExpression
rulePrimaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getAlternatives()); }
		(rule__PrimaryExpression__Alternatives)
		{ after(grammarAccess.getPrimaryExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatechartActiveExpression
entryRuleStatechartActiveExpression
:
{ before(grammarAccess.getStatechartActiveExpressionRule()); }
	 ruleStatechartActiveExpression
{ after(grammarAccess.getStatechartActiveExpressionRule()); } 
	 EOF 
;

// Rule StatechartActiveExpression
ruleStatechartActiveExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatechartActiveExpressionAccess().getGroup()); }
		(rule__StatechartActiveExpression__Group__0)
		{ after(grammarAccess.getStatechartActiveExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatechartFinalExpression
entryRuleStatechartFinalExpression
:
{ before(grammarAccess.getStatechartFinalExpressionRule()); }
	 ruleStatechartFinalExpression
{ after(grammarAccess.getStatechartFinalExpressionRule()); } 
	 EOF 
;

// Rule StatechartFinalExpression
ruleStatechartFinalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatechartFinalExpressionAccess().getGroup()); }
		(rule__StatechartFinalExpression__Group__0)
		{ after(grammarAccess.getStatechartFinalExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpressionStatement
entryRuleExpressionStatement
:
{ before(grammarAccess.getExpressionStatementRule()); }
	 ruleExpressionStatement
{ after(grammarAccess.getExpressionStatementRule()); } 
	 EOF 
;

// Rule ExpressionStatement
ruleExpressionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionStatementAccess().getGroup()); }
		(rule__ExpressionStatement__Group__0)
		{ after(grammarAccess.getExpressionStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLoopStatement
entryRuleLoopStatement
:
{ before(grammarAccess.getLoopStatementRule()); }
	 ruleLoopStatement
{ after(grammarAccess.getLoopStatementRule()); } 
	 EOF 
;

// Rule LoopStatement
ruleLoopStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLoopStatementAccess().getGroup()); }
		(rule__LoopStatement__Group__0)
		{ after(grammarAccess.getLoopStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariableDefinitionStatement
entryRuleVariableDefinitionStatement
:
{ before(grammarAccess.getVariableDefinitionStatementRule()); }
	 ruleVariableDefinitionStatement
{ after(grammarAccess.getVariableDefinitionStatementRule()); } 
	 EOF 
;

// Rule VariableDefinitionStatement
ruleVariableDefinitionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDefinitionStatementAccess().getGroup()); }
		(rule__VariableDefinitionStatement__Group__0)
		{ after(grammarAccess.getVariableDefinitionStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariableDefinition
entryRuleVariableDefinition
:
{ before(grammarAccess.getVariableDefinitionRule()); }
	 ruleVariableDefinition
{ after(grammarAccess.getVariableDefinitionRule()); } 
	 EOF 
;

// Rule VariableDefinition
ruleVariableDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getGroup()); }
		(rule__VariableDefinition__Group__0)
		{ after(grammarAccess.getVariableDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIfStatement
entryRuleIfStatement
:
{ before(grammarAccess.getIfStatementRule()); }
	 ruleIfStatement
{ after(grammarAccess.getIfStatementRule()); } 
	 EOF 
;

// Rule IfStatement
ruleIfStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIfStatementAccess().getGroup()); }
		(rule__IfStatement__Group__0)
		{ after(grammarAccess.getIfStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReturnStatement
entryRuleReturnStatement
:
{ before(grammarAccess.getReturnStatementRule()); }
	 ruleReturnStatement
{ after(grammarAccess.getReturnStatementRule()); } 
	 EOF 
;

// Rule ReturnStatement
ruleReturnStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReturnStatementAccess().getAlternatives()); }
		(rule__ReturnStatement__Alternatives)
		{ after(grammarAccess.getReturnStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleReferenceKeywords
entryRuleReferenceKeywords
:
{ before(grammarAccess.getReferenceKeywordsRule()); }
	 ruleReferenceKeywords
{ after(grammarAccess.getReferenceKeywordsRule()); } 
	 EOF 
;

// Rule ReferenceKeywords
ruleReferenceKeywords 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getAlternatives()); }
		(rule__ReferenceKeywords__Alternatives)
		{ after(grammarAccess.getReferenceKeywordsAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOtherKeywords
entryRuleOtherKeywords
:
{ before(grammarAccess.getOtherKeywordsRule()); }
	 ruleOtherKeywords
{ after(grammarAccess.getOtherKeywordsRule()); } 
	 EOF 
;

// Rule OtherKeywords
ruleOtherKeywords 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getAlternatives()); }
		(rule__OtherKeywords__Alternatives)
		{ after(grammarAccess.getOtherKeywordsAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnnotation
entryRuleAnnotation
:
{ before(grammarAccess.getAnnotationRule()); }
	 ruleAnnotation
{ after(grammarAccess.getAnnotationRule()); } 
	 EOF 
;

// Rule Annotation
ruleAnnotation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnnotationAccess().getGroup()); }
		(rule__Annotation__Group__0)
		{ after(grammarAccess.getAnnotationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameter
entryRuleParameter
:
{ before(grammarAccess.getParameterRule()); }
	 ruleParameter
{ after(grammarAccess.getParameterRule()); } 
	 EOF 
;

// Rule Parameter
ruleParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterAccess().getGroup()); }
		(rule__Parameter__Group__0)
		{ after(grammarAccess.getParameterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSimpleFeatureCall
entryRuleSimpleFeatureCall
:
{ before(grammarAccess.getSimpleFeatureCallRule()); }
	 ruleSimpleFeatureCall
{ after(grammarAccess.getSimpleFeatureCallRule()); } 
	 EOF 
;

// Rule SimpleFeatureCall
ruleSimpleFeatureCall 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSimpleFeatureCallAccess().getGroup()); }
		(rule__SimpleFeatureCall__Group__0)
		{ after(grammarAccess.getSimpleFeatureCallAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSimpleElementReferenceExpression
entryRuleSimpleElementReferenceExpression
:
{ before(grammarAccess.getSimpleElementReferenceExpressionRule()); }
	 ruleSimpleElementReferenceExpression
{ after(grammarAccess.getSimpleElementReferenceExpressionRule()); } 
	 EOF 
;

// Rule SimpleElementReferenceExpression
ruleSimpleElementReferenceExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup()); }
		(rule__SimpleElementReferenceExpression__Group__0)
		{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleActiveStateReferenceExpression
entryRuleActiveStateReferenceExpression
:
{ before(grammarAccess.getActiveStateReferenceExpressionRule()); }
	 ruleActiveStateReferenceExpression
{ after(grammarAccess.getActiveStateReferenceExpressionRule()); } 
	 EOF 
;

// Rule ActiveStateReferenceExpression
ruleActiveStateReferenceExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getGroup()); }
		(rule__ActiveStateReferenceExpression__Group__0)
		{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFQN
entryRuleFQN
:
{ before(grammarAccess.getFQNRule()); }
	 ruleFQN
{ after(grammarAccess.getFQNRule()); } 
	 EOF 
;

// Rule FQN
ruleFQN 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFQNAccess().getGroup()); }
		(rule__FQN__Group__0)
		{ after(grammarAccess.getFQNAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpression
entryRuleExpression
:
{ before(grammarAccess.getExpressionRule()); }
	 ruleExpression
{ after(grammarAccess.getExpressionRule()); } 
	 EOF 
;

// Rule Expression
ruleExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall()); }
		ruleAssignmentExpression
		{ after(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssignmentExpression
entryRuleAssignmentExpression
:
{ before(grammarAccess.getAssignmentExpressionRule()); }
	 ruleAssignmentExpression
{ after(grammarAccess.getAssignmentExpressionRule()); } 
	 EOF 
;

// Rule AssignmentExpression
ruleAssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getGroup()); }
		(rule__AssignmentExpression__Group__0)
		{ after(grammarAccess.getAssignmentExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConditionalExpression
entryRuleConditionalExpression
:
{ before(grammarAccess.getConditionalExpressionRule()); }
	 ruleConditionalExpression
{ after(grammarAccess.getConditionalExpressionRule()); } 
	 EOF 
;

// Rule ConditionalExpression
ruleConditionalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getGroup()); }
		(rule__ConditionalExpression__Group__0)
		{ after(grammarAccess.getConditionalExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalOrExpression
entryRuleLogicalOrExpression
:
{ before(grammarAccess.getLogicalOrExpressionRule()); }
	 ruleLogicalOrExpression
{ after(grammarAccess.getLogicalOrExpressionRule()); } 
	 EOF 
;

// Rule LogicalOrExpression
ruleLogicalOrExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getGroup()); }
		(rule__LogicalOrExpression__Group__0)
		{ after(grammarAccess.getLogicalOrExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalAndExpression
entryRuleLogicalAndExpression
:
{ before(grammarAccess.getLogicalAndExpressionRule()); }
	 ruleLogicalAndExpression
{ after(grammarAccess.getLogicalAndExpressionRule()); } 
	 EOF 
;

// Rule LogicalAndExpression
ruleLogicalAndExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getGroup()); }
		(rule__LogicalAndExpression__Group__0)
		{ after(grammarAccess.getLogicalAndExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalNotExpression
entryRuleLogicalNotExpression
:
{ before(grammarAccess.getLogicalNotExpressionRule()); }
	 ruleLogicalNotExpression
{ after(grammarAccess.getLogicalNotExpressionRule()); } 
	 EOF 
;

// Rule LogicalNotExpression
ruleLogicalNotExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getAlternatives()); }
		(rule__LogicalNotExpression__Alternatives)
		{ after(grammarAccess.getLogicalNotExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseOrExpression
entryRuleBitwiseOrExpression
:
{ before(grammarAccess.getBitwiseOrExpressionRule()); }
	 ruleBitwiseOrExpression
{ after(grammarAccess.getBitwiseOrExpressionRule()); } 
	 EOF 
;

// Rule BitwiseOrExpression
ruleBitwiseOrExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseOrExpressionAccess().getGroup()); }
		(rule__BitwiseOrExpression__Group__0)
		{ after(grammarAccess.getBitwiseOrExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseXorExpression
entryRuleBitwiseXorExpression
:
{ before(grammarAccess.getBitwiseXorExpressionRule()); }
	 ruleBitwiseXorExpression
{ after(grammarAccess.getBitwiseXorExpressionRule()); } 
	 EOF 
;

// Rule BitwiseXorExpression
ruleBitwiseXorExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXorExpressionAccess().getGroup()); }
		(rule__BitwiseXorExpression__Group__0)
		{ after(grammarAccess.getBitwiseXorExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseAndExpression
entryRuleBitwiseAndExpression
:
{ before(grammarAccess.getBitwiseAndExpressionRule()); }
	 ruleBitwiseAndExpression
{ after(grammarAccess.getBitwiseAndExpressionRule()); } 
	 EOF 
;

// Rule BitwiseAndExpression
ruleBitwiseAndExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseAndExpressionAccess().getGroup()); }
		(rule__BitwiseAndExpression__Group__0)
		{ after(grammarAccess.getBitwiseAndExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalRelationExpression
entryRuleLogicalRelationExpression
:
{ before(grammarAccess.getLogicalRelationExpressionRule()); }
	 ruleLogicalRelationExpression
{ after(grammarAccess.getLogicalRelationExpressionRule()); } 
	 EOF 
;

// Rule LogicalRelationExpression
ruleLogicalRelationExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalRelationExpressionAccess().getGroup()); }
		(rule__LogicalRelationExpression__Group__0)
		{ after(grammarAccess.getLogicalRelationExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleShiftExpression
entryRuleShiftExpression
:
{ before(grammarAccess.getShiftExpressionRule()); }
	 ruleShiftExpression
{ after(grammarAccess.getShiftExpressionRule()); } 
	 EOF 
;

// Rule ShiftExpression
ruleShiftExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getGroup()); }
		(rule__ShiftExpression__Group__0)
		{ after(grammarAccess.getShiftExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericalAddSubtractExpression
entryRuleNumericalAddSubtractExpression
:
{ before(grammarAccess.getNumericalAddSubtractExpressionRule()); }
	 ruleNumericalAddSubtractExpression
{ after(grammarAccess.getNumericalAddSubtractExpressionRule()); } 
	 EOF 
;

// Rule NumericalAddSubtractExpression
ruleNumericalAddSubtractExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup()); }
		(rule__NumericalAddSubtractExpression__Group__0)
		{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericalMultiplyDivideExpression
entryRuleNumericalMultiplyDivideExpression
:
{ before(grammarAccess.getNumericalMultiplyDivideExpressionRule()); }
	 ruleNumericalMultiplyDivideExpression
{ after(grammarAccess.getNumericalMultiplyDivideExpressionRule()); } 
	 EOF 
;

// Rule NumericalMultiplyDivideExpression
ruleNumericalMultiplyDivideExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup()); }
		(rule__NumericalMultiplyDivideExpression__Group__0)
		{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNumericalUnaryExpression
entryRuleNumericalUnaryExpression
:
{ before(grammarAccess.getNumericalUnaryExpressionRule()); }
	 ruleNumericalUnaryExpression
{ after(grammarAccess.getNumericalUnaryExpressionRule()); } 
	 EOF 
;

// Rule NumericalUnaryExpression
ruleNumericalUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getAlternatives()); }
		(rule__NumericalUnaryExpression__Alternatives)
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePostFixUnaryExpression
entryRulePostFixUnaryExpression
:
{ before(grammarAccess.getPostFixUnaryExpressionRule()); }
	 rulePostFixUnaryExpression
{ after(grammarAccess.getPostFixUnaryExpressionRule()); } 
	 EOF 
;

// Rule PostFixUnaryExpression
rulePostFixUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPostFixUnaryExpressionAccess().getGroup()); }
		(rule__PostFixUnaryExpression__Group__0)
		{ after(grammarAccess.getPostFixUnaryExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeCastExpression
entryRuleTypeCastExpression
:
{ before(grammarAccess.getTypeCastExpressionRule()); }
	 ruleTypeCastExpression
{ after(grammarAccess.getTypeCastExpressionRule()); } 
	 EOF 
;

// Rule TypeCastExpression
ruleTypeCastExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeCastExpressionAccess().getGroup()); }
		(rule__TypeCastExpression__Group__0)
		{ after(grammarAccess.getTypeCastExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFeatureCall
entryRuleFeatureCall
:
{ before(grammarAccess.getFeatureCallRule()); }
	 ruleFeatureCall
{ after(grammarAccess.getFeatureCallRule()); } 
	 EOF 
;

// Rule FeatureCall
ruleFeatureCall 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup()); }
		(rule__FeatureCall__Group__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleElementReferenceExpression
entryRuleElementReferenceExpression
:
{ before(grammarAccess.getElementReferenceExpressionRule()); }
	 ruleElementReferenceExpression
{ after(grammarAccess.getElementReferenceExpressionRule()); } 
	 EOF 
;

// Rule ElementReferenceExpression
ruleElementReferenceExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup()); }
		(rule__ElementReferenceExpression__Group__0)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveValueExpression
entryRulePrimitiveValueExpression
:
{ before(grammarAccess.getPrimitiveValueExpressionRule()); }
	 rulePrimitiveValueExpression
{ after(grammarAccess.getPrimitiveValueExpressionRule()); } 
	 EOF 
;

// Rule PrimitiveValueExpression
rulePrimitiveValueExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveValueExpressionAccess().getGroup()); }
		(rule__PrimitiveValueExpression__Group__0)
		{ after(grammarAccess.getPrimitiveValueExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEventRaisingExpression
entryRuleEventRaisingExpression
:
{ before(grammarAccess.getEventRaisingExpressionRule()); }
	 ruleEventRaisingExpression
{ after(grammarAccess.getEventRaisingExpressionRule()); } 
	 EOF 
;

// Rule EventRaisingExpression
ruleEventRaisingExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEventRaisingExpressionAccess().getGroup()); }
		(rule__EventRaisingExpression__Group__0)
		{ after(grammarAccess.getEventRaisingExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEventValueReferenceExpression
entryRuleEventValueReferenceExpression
:
{ before(grammarAccess.getEventValueReferenceExpressionRule()); }
	 ruleEventValueReferenceExpression
{ after(grammarAccess.getEventValueReferenceExpressionRule()); } 
	 EOF 
;

// Rule EventValueReferenceExpression
ruleEventValueReferenceExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEventValueReferenceExpressionAccess().getGroup()); }
		(rule__EventValueReferenceExpression__Group__0)
		{ after(grammarAccess.getEventValueReferenceExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInitializationExpression
entryRuleInitializationExpression
:
{ before(grammarAccess.getInitializationExpressionRule()); }
	 ruleInitializationExpression
{ after(grammarAccess.getInitializationExpressionRule()); } 
	 EOF 
;

// Rule InitializationExpression
ruleInitializationExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInitializationExpressionAccess().getGroup()); }
		(rule__InitializationExpression__Group__0)
		{ after(grammarAccess.getInitializationExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArgument
entryRuleArgument
:
{ before(grammarAccess.getArgumentRule()); }
	 ruleArgument
{ after(grammarAccess.getArgumentRule()); } 
	 EOF 
;

// Rule Argument
ruleArgument 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArgumentAccess().getGroup()); }
		(rule__Argument__Group__0)
		{ after(grammarAccess.getArgumentAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParenthesizedExpression
entryRuleParenthesizedExpression
:
{ before(grammarAccess.getParenthesizedExpressionRule()); }
	 ruleParenthesizedExpression
{ after(grammarAccess.getParenthesizedExpressionRule()); } 
	 EOF 
;

// Rule ParenthesizedExpression
ruleParenthesizedExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParenthesizedExpressionAccess().getGroup()); }
		(rule__ParenthesizedExpression__Group__0)
		{ after(grammarAccess.getParenthesizedExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeSpecifier
entryRuleTypeSpecifier
:
{ before(grammarAccess.getTypeSpecifierRule()); }
	 ruleTypeSpecifier
{ after(grammarAccess.getTypeSpecifierRule()); } 
	 EOF 
;

// Rule TypeSpecifier
ruleTypeSpecifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getGroup()); }
		(rule__TypeSpecifier__Group__0)
		{ after(grammarAccess.getTypeSpecifierAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleQID
entryRuleQID
:
{ before(grammarAccess.getQIDRule()); }
	 ruleQID
{ after(grammarAccess.getQIDRule()); } 
	 EOF 
;

// Rule QID
ruleQID 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getQIDAccess().getGroup()); }
		(rule__QID__Group__0)
		{ after(grammarAccess.getQIDAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIDWithKeywords
entryRuleIDWithKeywords
:
{ before(grammarAccess.getIDWithKeywordsRule()); }
	 ruleIDWithKeywords
{ after(grammarAccess.getIDWithKeywordsRule()); } 
	 EOF 
;

// Rule IDWithKeywords
ruleIDWithKeywords 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIDWithKeywordsAccess().getAlternatives()); }
		(rule__IDWithKeywords__Alternatives)
		{ after(grammarAccess.getIDWithKeywordsAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRefIDWithKeywords
entryRuleRefIDWithKeywords
:
{ before(grammarAccess.getRefIDWithKeywordsRule()); }
	 ruleRefIDWithKeywords
{ after(grammarAccess.getRefIDWithKeywordsRule()); } 
	 EOF 
;

// Rule RefIDWithKeywords
ruleRefIDWithKeywords 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRefIDWithKeywordsAccess().getAlternatives()); }
		(rule__RefIDWithKeywords__Alternatives)
		{ after(grammarAccess.getRefIDWithKeywordsAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteral
entryRuleLiteral
:
{ before(grammarAccess.getLiteralRule()); }
	 ruleLiteral
{ after(grammarAccess.getLiteralRule()); } 
	 EOF 
;

// Rule Literal
ruleLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralAccess().getAlternatives()); }
		(rule__Literal__Alternatives)
		{ after(grammarAccess.getLiteralAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBoolLiteral
entryRuleBoolLiteral
:
{ before(grammarAccess.getBoolLiteralRule()); }
	 ruleBoolLiteral
{ after(grammarAccess.getBoolLiteralRule()); } 
	 EOF 
;

// Rule BoolLiteral
ruleBoolLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBoolLiteralAccess().getGroup()); }
		(rule__BoolLiteral__Group__0)
		{ after(grammarAccess.getBoolLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntLiteral
entryRuleIntLiteral
:
{ before(grammarAccess.getIntLiteralRule()); }
	 ruleIntLiteral
{ after(grammarAccess.getIntLiteralRule()); } 
	 EOF 
;

// Rule IntLiteral
ruleIntLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntLiteralAccess().getGroup()); }
		(rule__IntLiteral__Group__0)
		{ after(grammarAccess.getIntLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDoubleLiteral
entryRuleDoubleLiteral
:
{ before(grammarAccess.getDoubleLiteralRule()); }
	 ruleDoubleLiteral
{ after(grammarAccess.getDoubleLiteralRule()); } 
	 EOF 
;

// Rule DoubleLiteral
ruleDoubleLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDoubleLiteralAccess().getGroup()); }
		(rule__DoubleLiteral__Group__0)
		{ after(grammarAccess.getDoubleLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFloatLiteral
entryRuleFloatLiteral
:
{ before(grammarAccess.getFloatLiteralRule()); }
	 ruleFloatLiteral
{ after(grammarAccess.getFloatLiteralRule()); } 
	 EOF 
;

// Rule FloatLiteral
ruleFloatLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFloatLiteralAccess().getGroup()); }
		(rule__FloatLiteral__Group__0)
		{ after(grammarAccess.getFloatLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleHexLiteral
entryRuleHexLiteral
:
{ before(grammarAccess.getHexLiteralRule()); }
	 ruleHexLiteral
{ after(grammarAccess.getHexLiteralRule()); } 
	 EOF 
;

// Rule HexLiteral
ruleHexLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getHexLiteralAccess().getGroup()); }
		(rule__HexLiteral__Group__0)
		{ after(grammarAccess.getHexLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBinaryLiteral
entryRuleBinaryLiteral
:
{ before(grammarAccess.getBinaryLiteralRule()); }
	 ruleBinaryLiteral
{ after(grammarAccess.getBinaryLiteralRule()); } 
	 EOF 
;

// Rule BinaryLiteral
ruleBinaryLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBinaryLiteralAccess().getGroup()); }
		(rule__BinaryLiteral__Group__0)
		{ after(grammarAccess.getBinaryLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStringLiteral
entryRuleStringLiteral
:
{ before(grammarAccess.getStringLiteralRule()); }
	 ruleStringLiteral
{ after(grammarAccess.getStringLiteralRule()); } 
	 EOF 
;

// Rule StringLiteral
ruleStringLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStringLiteralAccess().getGroup()); }
		(rule__StringLiteral__Group__0)
		{ after(grammarAccess.getStringLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNullLiteral
entryRuleNullLiteral
:
{ before(grammarAccess.getNullLiteralRule()); }
	 ruleNullLiteral
{ after(grammarAccess.getNullLiteralRule()); } 
	 EOF 
;

// Rule NullLiteral
ruleNullLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNullLiteralAccess().getGroup()); }
		(rule__NullLiteral__Group__0)
		{ after(grammarAccess.getNullLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalAndOperator
entryRuleLogicalAndOperator
:
{ before(grammarAccess.getLogicalAndOperatorRule()); }
	 ruleLogicalAndOperator
{ after(grammarAccess.getLogicalAndOperatorRule()); } 
	 EOF 
;

// Rule LogicalAndOperator
ruleLogicalAndOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalAndOperatorAccess().getAmpersandAmpersandKeyword()); }
		'&&'
		{ after(grammarAccess.getLogicalAndOperatorAccess().getAmpersandAmpersandKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalOrOperator
entryRuleLogicalOrOperator
:
{ before(grammarAccess.getLogicalOrOperatorRule()); }
	 ruleLogicalOrOperator
{ after(grammarAccess.getLogicalOrOperatorRule()); } 
	 EOF 
;

// Rule LogicalOrOperator
ruleLogicalOrOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalOrOperatorAccess().getVerticalLineVerticalLineKeyword()); }
		'||'
		{ after(grammarAccess.getLogicalOrOperatorAccess().getVerticalLineVerticalLineKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalNotOperator
entryRuleLogicalNotOperator
:
{ before(grammarAccess.getLogicalNotOperatorRule()); }
	 ruleLogicalNotOperator
{ after(grammarAccess.getLogicalNotOperatorRule()); } 
	 EOF 
;

// Rule LogicalNotOperator
ruleLogicalNotOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalNotOperatorAccess().getExclamationMarkKeyword()); }
		'!'
		{ after(grammarAccess.getLogicalNotOperatorAccess().getExclamationMarkKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseXOrOperator
entryRuleBitwiseXOrOperator
:
{ before(grammarAccess.getBitwiseXOrOperatorRule()); }
	 ruleBitwiseXOrOperator
{ after(grammarAccess.getBitwiseXOrOperatorRule()); } 
	 EOF 
;

// Rule BitwiseXOrOperator
ruleBitwiseXOrOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXOrOperatorAccess().getCircumflexAccentKeyword()); }
		'^'
		{ after(grammarAccess.getBitwiseXOrOperatorAccess().getCircumflexAccentKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseOrOperator
entryRuleBitwiseOrOperator
:
{ before(grammarAccess.getBitwiseOrOperatorRule()); }
	 ruleBitwiseOrOperator
{ after(grammarAccess.getBitwiseOrOperatorRule()); } 
	 EOF 
;

// Rule BitwiseOrOperator
ruleBitwiseOrOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseOrOperatorAccess().getVerticalLineKeyword()); }
		'|'
		{ after(grammarAccess.getBitwiseOrOperatorAccess().getVerticalLineKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseAndOperator
entryRuleBitwiseAndOperator
:
{ before(grammarAccess.getBitwiseAndOperatorRule()); }
	 ruleBitwiseAndOperator
{ after(grammarAccess.getBitwiseAndOperatorRule()); } 
	 EOF 
;

// Rule BitwiseAndOperator
ruleBitwiseAndOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseAndOperatorAccess().getAmpersandKeyword()); }
		'&'
		{ after(grammarAccess.getBitwiseAndOperatorAccess().getAmpersandKeyword()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ProceedUnit
ruleProceedUnit
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProceedUnitAccess().getAlternatives()); }
		(rule__ProceedUnit__Alternatives)
		{ after(grammarAccess.getProceedUnitAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PostFixOperator
rulePostFixOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostFixOperatorAccess().getAlternatives()); }
		(rule__PostFixOperator__Alternatives)
		{ after(grammarAccess.getPostFixOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule AssignmentOperator
ruleAssignmentOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
		(rule__AssignmentOperator__Alternatives)
		{ after(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ShiftOperator
ruleShiftOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftOperatorAccess().getAlternatives()); }
		(rule__ShiftOperator__Alternatives)
		{ after(grammarAccess.getShiftOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule AdditiveOperator
ruleAdditiveOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); }
		(rule__AdditiveOperator__Alternatives)
		{ after(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule MultiplicativeOperator
ruleMultiplicativeOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); }
		(rule__MultiplicativeOperator__Alternatives)
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule UnaryOperator
ruleUnaryOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getAlternatives()); }
		(rule__UnaryOperator__Alternatives)
		{ after(grammarAccess.getUnaryOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule RelationalOperator
ruleRelationalOperator
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getAlternatives()); }
		(rule__RelationalOperator__Alternatives)
		{ after(grammarAccess.getRelationalOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitElement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitElementAccess().getSCTUnitClassParserRuleCall_0()); }
		ruleSCTUnitClass
		{ after(grammarAccess.getSCTUnitElementAccess().getSCTUnitClassParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getSCTUnitElementAccess().getSCTUnitSuiteParserRuleCall_1()); }
		ruleSCTUnitSuite
		{ after(grammarAccess.getSCTUnitElementAccess().getSCTUnitSuiteParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TestStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTestStatementAccess().getExpressionStatementParserRuleCall_0()); }
		ruleExpressionStatement
		{ after(grammarAccess.getTestStatementAccess().getExpressionStatementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTestStatementAccess().getMockingStatementParserRuleCall_1()); }
		ruleMockingStatement
		{ after(grammarAccess.getTestStatementAccess().getMockingStatementParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTestStatementAccess().getAssertionStatementParserRuleCall_2()); }
		ruleAssertionStatement
		{ after(grammarAccess.getTestStatementAccess().getAssertionStatementParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTestStatementAccess().getLoopStatementParserRuleCall_3()); }
		ruleLoopStatement
		{ after(grammarAccess.getTestStatementAccess().getLoopStatementParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getTestStatementAccess().getVariableDefinitionStatementParserRuleCall_4()); }
		ruleVariableDefinitionStatement
		{ after(grammarAccess.getTestStatementAccess().getVariableDefinitionStatementParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getTestStatementAccess().getReturnStatementParserRuleCall_5()); }
		ruleReturnStatement
		{ after(grammarAccess.getTestStatementAccess().getReturnStatementParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getTestStatementAccess().getIfStatementParserRuleCall_6()); }
		ruleIfStatement
		{ after(grammarAccess.getTestStatementAccess().getIfStatementParserRuleCall_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockingStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMockingStatementAccess().getVerifyCalledStatementParserRuleCall_0()); }
		ruleVerifyCalledStatement
		{ after(grammarAccess.getMockingStatementAccess().getVerifyCalledStatementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getMockingStatementAccess().getMockReturnStatementParserRuleCall_1()); }
		ruleMockReturnStatement
		{ after(grammarAccess.getMockingStatementAccess().getMockReturnStatementParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getPrimitiveValueExpressionParserRuleCall_0()); }
		rulePrimitiveValueExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getPrimitiveValueExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getProceedExpressionParserRuleCall_1()); }
		(ruleProceedExpression)
		{ after(grammarAccess.getPrimaryExpressionAccess().getProceedExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getExitExpressionParserRuleCall_2()); }
		(ruleExitExpression)
		{ after(grammarAccess.getPrimaryExpressionAccess().getExitExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getEnterExpressionParserRuleCall_3()); }
		(ruleEnterExpression)
		{ after(grammarAccess.getPrimaryExpressionAccess().getEnterExpressionParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getElementReferenceExpressionParserRuleCall_4()); }
		ruleElementReferenceExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getElementReferenceExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getActiveStateReferenceExpressionParserRuleCall_5()); }
		ruleActiveStateReferenceExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getActiveStateReferenceExpressionParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getEventValueReferenceExpressionParserRuleCall_6()); }
		ruleEventValueReferenceExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getEventValueReferenceExpressionParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getParenthesizedExpressionParserRuleCall_7()); }
		ruleParenthesizedExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getParenthesizedExpressionParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getStatechartActiveExpressionParserRuleCall_8()); }
		ruleStatechartActiveExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getStatechartActiveExpressionParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getStatechartFinalExpressionParserRuleCall_9()); }
		ruleStatechartFinalExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getStatechartFinalExpressionParserRuleCall_9()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getTriggerWithoutEventExpressionParserRuleCall_10()); }
		ruleTriggerWithoutEventExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getTriggerWithoutEventExpressionParserRuleCall_10()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getInitializationExpressionParserRuleCall_11()); }
		ruleInitializationExpression
		{ after(grammarAccess.getPrimaryExpressionAccess().getInitializationExpressionParserRuleCall_11()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__ExpressionAlternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExpressionStatementAccess().getExpressionExpressionParserRuleCall_1_0_0()); }
		ruleExpression
		{ after(grammarAccess.getExpressionStatementAccess().getExpressionExpressionParserRuleCall_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getExpressionStatementAccess().getExpressionEventRaisingExpressionParserRuleCall_1_0_1()); }
		ruleEventRaisingExpression
		{ after(grammarAccess.getExpressionStatementAccess().getExpressionEventRaisingExpressionParserRuleCall_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getConstAssignment_0_0()); }
		(rule__VariableDefinition__ConstAssignment_0_0)
		{ after(grammarAccess.getVariableDefinitionAccess().getConstAssignment_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getVarKeyword_0_1()); }
		'var'
		{ after(grammarAccess.getVariableDefinitionAccess().getVarKeyword_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getGroup_3_0()); }
		(rule__VariableDefinition__Group_3_0__0)
		{ after(grammarAccess.getVariableDefinitionAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getGroup_3_1()); }
		(rule__VariableDefinition__Group_3_1__0)
		{ after(grammarAccess.getVariableDefinitionAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnStatementAccess().getGroup_0()); }
		(rule__ReturnStatement__Group_0__0)
		{ after(grammarAccess.getReturnStatementAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getReturnStatementAccess().getGroup_1()); }
		(rule__ReturnStatement__Group_1__0)
		{ after(grammarAccess.getReturnStatementAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReferenceKeywords__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getPackageKeyword_0()); }
		'package'
		{ after(grammarAccess.getReferenceKeywordsAccess().getPackageKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getTestclassKeyword_1()); }
		'testclass'
		{ after(grammarAccess.getReferenceKeywordsAccess().getTestclassKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getForKeyword_2()); }
		'for'
		{ after(grammarAccess.getReferenceKeywordsAccess().getForKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getStatechartKeyword_3()); }
		'statechart'
		{ after(grammarAccess.getReferenceKeywordsAccess().getStatechartKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getTestsuiteKeyword_4()); }
		'testsuite'
		{ after(grammarAccess.getReferenceKeywordsAccess().getTestsuiteKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getOperationKeyword_5()); }
		'operation'
		{ after(grammarAccess.getReferenceKeywordsAccess().getOperationKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getExitKeyword_6()); }
		'exit'
		{ after(grammarAccess.getReferenceKeywordsAccess().getExitKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getEnterKeyword_7()); }
		'enter'
		{ after(grammarAccess.getReferenceKeywordsAccess().getEnterKeyword_7()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getProceedKeyword_8()); }
		'proceed'
		{ after(grammarAccess.getReferenceKeywordsAccess().getProceedKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getSKeyword_9()); }
		's'
		{ after(grammarAccess.getReferenceKeywordsAccess().getSKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getMsKeyword_10()); }
		'ms'
		{ after(grammarAccess.getReferenceKeywordsAccess().getMsKeyword_10()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getUsKeyword_11()); }
		'us'
		{ after(grammarAccess.getReferenceKeywordsAccess().getUsKeyword_11()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getNsKeyword_12()); }
		'ns'
		{ after(grammarAccess.getReferenceKeywordsAccess().getNsKeyword_12()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getCycleKeyword_13()); }
		'cycle'
		{ after(grammarAccess.getReferenceKeywordsAccess().getCycleKeyword_13()); }
	)
	|
	(
		{ before(grammarAccess.getReferenceKeywordsAccess().getReadonlyKeyword_14()); }
		'readonly'
		{ after(grammarAccess.getReferenceKeywordsAccess().getReadonlyKeyword_14()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherKeywords__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getRaiseKeyword_0()); }
		'raise'
		{ after(grammarAccess.getOtherKeywordsAccess().getRaiseKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getValueofKeyword_1()); }
		'valueof'
		{ after(grammarAccess.getOtherKeywordsAccess().getValueofKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getActiveKeyword_2()); }
		'active'
		{ after(grammarAccess.getOtherKeywordsAccess().getActiveKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getAssertKeyword_3()); }
		'assert'
		{ after(grammarAccess.getOtherKeywordsAccess().getAssertKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getCalledKeyword_4()); }
		'called'
		{ after(grammarAccess.getOtherKeywordsAccess().getCalledKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getTimesKeyword_5()); }
		'times'
		{ after(grammarAccess.getOtherKeywordsAccess().getTimesKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getMockKeyword_6()); }
		'mock'
		{ after(grammarAccess.getOtherKeywordsAccess().getMockKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getReturnsKeyword_7()); }
		'returns'
		{ after(grammarAccess.getOtherKeywordsAccess().getReturnsKeyword_7()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getMessageKeyword_8()); }
		'message'
		{ after(grammarAccess.getOtherKeywordsAccess().getMessageKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getTriggerWithoutEventKeyword_9()); }
		'triggerWithoutEvent'
		{ after(grammarAccess.getOtherKeywordsAccess().getTriggerWithoutEventKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getIs_activeKeyword_10()); }
		'is_active'
		{ after(grammarAccess.getOtherKeywordsAccess().getIs_activeKeyword_10()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getIs_finalKeyword_11()); }
		'is_final'
		{ after(grammarAccess.getOtherKeywordsAccess().getIs_finalKeyword_11()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getWhileKeyword_12()); }
		'while'
		{ after(grammarAccess.getOtherKeywordsAccess().getWhileKeyword_12()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getConstKeyword_13()); }
		'const'
		{ after(grammarAccess.getOtherKeywordsAccess().getConstKeyword_13()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getVarKeyword_14()); }
		'var'
		{ after(grammarAccess.getOtherKeywordsAccess().getVarKeyword_14()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getIfKeyword_15()); }
		'if'
		{ after(grammarAccess.getOtherKeywordsAccess().getIfKeyword_15()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getElseKeyword_16()); }
		'else'
		{ after(grammarAccess.getOtherKeywordsAccess().getElseKeyword_16()); }
	)
	|
	(
		{ before(grammarAccess.getOtherKeywordsAccess().getReturnKeyword_17()); }
		'return'
		{ after(grammarAccess.getOtherKeywordsAccess().getReturnKeyword_17()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Alternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_0_0()); }
		(rule__SimpleFeatureCall__Group_1_0_0__0)
		{ after(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_0_1()); }
		(rule__SimpleFeatureCall__Group_1_0_1__0)
		{ after(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getBitwiseOrExpressionParserRuleCall_0()); }
		ruleBitwiseOrExpression
		{ after(grammarAccess.getLogicalNotExpressionAccess().getBitwiseOrExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getGroup_1()); }
		(rule__LogicalNotExpression__Group_1__0)
		{ after(grammarAccess.getLogicalNotExpressionAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getPostFixUnaryExpressionParserRuleCall_0()); }
		rulePostFixUnaryExpression
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getPostFixUnaryExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1()); }
		(rule__NumericalUnaryExpression__Group_1__0)
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Alternatives_1_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_0()); }
		(rule__FeatureCall__Group_1_0_0_0__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_1()); }
		(rule__FeatureCall__Group_1_0_0_1__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Alternatives_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0()); }
		(rule__FeatureCall__Group_1_0_2_0__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1()); }
		(rule__FeatureCall__Group_1_0_2_1__0)
		{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0()); }
		(rule__ElementReferenceExpression__Group_2_0__0)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1()); }
		(rule__ElementReferenceExpression__Group_2_1__0)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IDWithKeywords__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIDWithKeywordsAccess().getIDTerminalRuleCall_0()); }
		RULE_ID
		{ after(grammarAccess.getIDWithKeywordsAccess().getIDTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1()); }
		ruleReferenceKeywords
		{ after(grammarAccess.getIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getIDWithKeywordsAccess().getOtherKeywordsParserRuleCall_2()); }
		ruleOtherKeywords
		{ after(grammarAccess.getIDWithKeywordsAccess().getOtherKeywordsParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RefIDWithKeywords__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRefIDWithKeywordsAccess().getIDTerminalRuleCall_0()); }
		RULE_ID
		{ after(grammarAccess.getRefIDWithKeywordsAccess().getIDTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getRefIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1()); }
		ruleReferenceKeywords
		{ after(grammarAccess.getRefIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Literal__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralAccess().getBoolLiteralParserRuleCall_0()); }
		ruleBoolLiteral
		{ after(grammarAccess.getLiteralAccess().getBoolLiteralParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getIntLiteralParserRuleCall_1()); }
		ruleIntLiteral
		{ after(grammarAccess.getLiteralAccess().getIntLiteralParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getHexLiteralParserRuleCall_2()); }
		ruleHexLiteral
		{ after(grammarAccess.getLiteralAccess().getHexLiteralParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getBinaryLiteralParserRuleCall_3()); }
		ruleBinaryLiteral
		{ after(grammarAccess.getLiteralAccess().getBinaryLiteralParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_4()); }
		ruleDoubleLiteral
		{ after(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getFloatLiteralParserRuleCall_5()); }
		ruleFloatLiteral
		{ after(grammarAccess.getLiteralAccess().getFloatLiteralParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_6()); }
		ruleStringLiteral
		{ after(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_7()); }
		ruleNullLiteral
		{ after(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_7()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedUnit__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProceedUnitAccess().getSecondEnumLiteralDeclaration_0()); }
		('s')
		{ after(grammarAccess.getProceedUnitAccess().getSecondEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getProceedUnitAccess().getMillisecondEnumLiteralDeclaration_1()); }
		('ms')
		{ after(grammarAccess.getProceedUnitAccess().getMillisecondEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getProceedUnitAccess().getMicrosecondEnumLiteralDeclaration_2()); }
		('us')
		{ after(grammarAccess.getProceedUnitAccess().getMicrosecondEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getProceedUnitAccess().getNanosecondEnumLiteralDeclaration_3()); }
		('ns')
		{ after(grammarAccess.getProceedUnitAccess().getNanosecondEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getProceedUnitAccess().getCyclesEnumLiteralDeclaration_4()); }
		('cycle')
		{ after(grammarAccess.getProceedUnitAccess().getCyclesEnumLiteralDeclaration_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0()); }
		('++')
		{ after(grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1()); }
		('--')
		{ after(grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0()); }
		('=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1()); }
		('*=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2()); }
		('/=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3()); }
		('%=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4()); }
		('+=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5()); }
		('-=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6()); }
		('<<=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7()); }
		('>>=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8()); }
		('&=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9()); }
		('^=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10()); }
		('|=')
		{ after(grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0()); }
		('<<')
		{ after(grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1()); }
		('>>')
		{ after(grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0()); }
		('+')
		{ after(grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1()); }
		('-')
		{ after(grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0()); }
		('*')
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1()); }
		('/')
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2()); }
		('%')
		{ after(grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0()); }
		('+')
		{ after(grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1()); }
		('-')
		{ after(grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2()); }
		('~')
		{ after(grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RelationalOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0()); }
		('<')
		{ after(grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1()); }
		('<=')
		{ after(grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2()); }
		('>')
		{ after(grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3()); }
		('>=')
		{ after(grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4()); }
		('==')
		{ after(grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5()); }
		('!=')
		{ after(grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TestPackage__Group__0__Impl
	rule__TestPackage__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTestPackageAccess().getTestPackageAction_0()); }
	()
	{ after(grammarAccess.getTestPackageAccess().getTestPackageAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TestPackage__Group__1__Impl
	rule__TestPackage__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTestPackageAccess().getGroup_1()); }
	(rule__TestPackage__Group_1__0)?
	{ after(grammarAccess.getTestPackageAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TestPackage__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTestPackageAccess().getMemberAssignment_2()); }
	(rule__TestPackage__MemberAssignment_2)
	{ after(grammarAccess.getTestPackageAccess().getMemberAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TestPackage__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TestPackage__Group_1__0__Impl
	rule__TestPackage__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTestPackageAccess().getPackageKeyword_1_0()); }
	'package'
	{ after(grammarAccess.getTestPackageAccess().getPackageKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TestPackage__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTestPackageAccess().getNameAssignment_1_1()); }
	(rule__TestPackage__NameAssignment_1_1)
	{ after(grammarAccess.getTestPackageAccess().getNameAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SCTUnitClass__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__0__Impl
	rule__SCTUnitClass__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getSCTUnitClassAction_0()); }
	()
	{ after(grammarAccess.getSCTUnitClassAccess().getSCTUnitClassAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__1__Impl
	rule__SCTUnitClass__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getTestclassKeyword_1()); }
	'testclass'
	{ after(grammarAccess.getSCTUnitClassAccess().getTestclassKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__2__Impl
	rule__SCTUnitClass__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getNameAssignment_2()); }
	(rule__SCTUnitClass__NameAssignment_2)
	{ after(grammarAccess.getSCTUnitClassAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__3__Impl
	rule__SCTUnitClass__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getForKeyword_3()); }
	'for'
	{ after(grammarAccess.getSCTUnitClassAccess().getForKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__4__Impl
	rule__SCTUnitClass__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getStatechartKeyword_4()); }
	'statechart'
	{ after(grammarAccess.getSCTUnitClassAccess().getStatechartKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__5__Impl
	rule__SCTUnitClass__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getStatechartAssignment_5()); }
	(rule__SCTUnitClass__StatechartAssignment_5)
	{ after(grammarAccess.getSCTUnitClassAccess().getStatechartAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__6__Impl
	rule__SCTUnitClass__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getLeftCurlyBracketKeyword_6()); }
	'{'
	{ after(grammarAccess.getSCTUnitClassAccess().getLeftCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__7__Impl
	rule__SCTUnitClass__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getVariableDefinitionsAssignment_7()); }
	(rule__SCTUnitClass__VariableDefinitionsAssignment_7)*
	{ after(grammarAccess.getSCTUnitClassAccess().getVariableDefinitionsAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__8__Impl
	rule__SCTUnitClass__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getSCTUnitClassAccess().getFeaturesAssignment_8()); }
		(rule__SCTUnitClass__FeaturesAssignment_8)
		{ after(grammarAccess.getSCTUnitClassAccess().getFeaturesAssignment_8()); }
	)
	(
		{ before(grammarAccess.getSCTUnitClassAccess().getFeaturesAssignment_8()); }
		(rule__SCTUnitClass__FeaturesAssignment_8)*
		{ after(grammarAccess.getSCTUnitClassAccess().getFeaturesAssignment_8()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitClass__Group__9__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitClassAccess().getRightCurlyBracketKeyword_9()); }
	'}'
	{ after(grammarAccess.getSCTUnitClassAccess().getRightCurlyBracketKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SCTUnitSuite__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group__0__Impl
	rule__SCTUnitSuite__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getSCTUnitSuiteAction_0()); }
	()
	{ after(grammarAccess.getSCTUnitSuiteAccess().getSCTUnitSuiteAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group__1__Impl
	rule__SCTUnitSuite__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getTestsuiteKeyword_1()); }
	'testsuite'
	{ after(grammarAccess.getSCTUnitSuiteAccess().getTestsuiteKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group__2__Impl
	rule__SCTUnitSuite__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getNameAssignment_2()); }
	(rule__SCTUnitSuite__NameAssignment_2)
	{ after(grammarAccess.getSCTUnitSuiteAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group__3__Impl
	rule__SCTUnitSuite__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getSCTUnitSuiteAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group__4__Impl
	rule__SCTUnitSuite__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getFeaturesAssignment_4()); }
	(rule__SCTUnitSuite__FeaturesAssignment_4)
	{ after(grammarAccess.getSCTUnitSuiteAccess().getFeaturesAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group__5__Impl
	rule__SCTUnitSuite__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getGroup_5()); }
	(rule__SCTUnitSuite__Group_5__0)*
	{ after(grammarAccess.getSCTUnitSuiteAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getSCTUnitSuiteAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SCTUnitSuite__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group_5__0__Impl
	rule__SCTUnitSuite__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getCommaKeyword_5_0()); }
	','
	{ after(grammarAccess.getSCTUnitSuiteAccess().getCommaKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitSuite__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitSuiteAccess().getFeaturesAssignment_5_1()); }
	(rule__SCTUnitSuite__FeaturesAssignment_5_1)
	{ after(grammarAccess.getSCTUnitSuiteAccess().getFeaturesAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SCTUnitOperation__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__0__Impl
	rule__SCTUnitOperation__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getSCTUnitOperationAction_0()); }
	()
	{ after(grammarAccess.getSCTUnitOperationAccess().getSCTUnitOperationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__1__Impl
	rule__SCTUnitOperation__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getAnnotationAssignment_1()); }
	(rule__SCTUnitOperation__AnnotationAssignment_1)*
	{ after(grammarAccess.getSCTUnitOperationAccess().getAnnotationAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__2__Impl
	rule__SCTUnitOperation__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getOperationKeyword_2()); }
	'operation'
	{ after(grammarAccess.getSCTUnitOperationAccess().getOperationKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__3__Impl
	rule__SCTUnitOperation__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getNameAssignment_3()); }
	(rule__SCTUnitOperation__NameAssignment_3)
	{ after(grammarAccess.getSCTUnitOperationAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__4__Impl
	rule__SCTUnitOperation__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getLeftParenthesisKeyword_4()); }
	'('
	{ after(grammarAccess.getSCTUnitOperationAccess().getLeftParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__5__Impl
	rule__SCTUnitOperation__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getGroup_5()); }
	(rule__SCTUnitOperation__Group_5__0)?
	{ after(grammarAccess.getSCTUnitOperationAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__6__Impl
	rule__SCTUnitOperation__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getRightParenthesisKeyword_6()); }
	')'
	{ after(grammarAccess.getSCTUnitOperationAccess().getRightParenthesisKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__7__Impl
	rule__SCTUnitOperation__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getGroup_7()); }
	(rule__SCTUnitOperation__Group_7__0)?
	{ after(grammarAccess.getSCTUnitOperationAccess().getGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getBodyAssignment_8()); }
	(rule__SCTUnitOperation__BodyAssignment_8)
	{ after(grammarAccess.getSCTUnitOperationAccess().getBodyAssignment_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SCTUnitOperation__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group_5__0__Impl
	rule__SCTUnitOperation__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getParametersAssignment_5_0()); }
	(rule__SCTUnitOperation__ParametersAssignment_5_0)
	{ after(grammarAccess.getSCTUnitOperationAccess().getParametersAssignment_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getGroup_5_1()); }
	(rule__SCTUnitOperation__Group_5_1__0)*
	{ after(grammarAccess.getSCTUnitOperationAccess().getGroup_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SCTUnitOperation__Group_5_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group_5_1__0__Impl
	rule__SCTUnitOperation__Group_5_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_5_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getCommaKeyword_5_1_0()); }
	','
	{ after(grammarAccess.getSCTUnitOperationAccess().getCommaKeyword_5_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_5_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group_5_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_5_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getParametersAssignment_5_1_1()); }
	(rule__SCTUnitOperation__ParametersAssignment_5_1_1)
	{ after(grammarAccess.getSCTUnitOperationAccess().getParametersAssignment_5_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SCTUnitOperation__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group_7__0__Impl
	rule__SCTUnitOperation__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getColonKeyword_7_0()); }
	':'
	{ after(grammarAccess.getSCTUnitOperationAccess().getColonKeyword_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SCTUnitOperation__Group_7__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSCTUnitOperationAccess().getTypeSpecifierAssignment_7_1()); }
	(rule__SCTUnitOperation__TypeSpecifierAssignment_7_1)
	{ after(grammarAccess.getSCTUnitOperationAccess().getTypeSpecifierAssignment_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CodeBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CodeBlock__Group__0__Impl
	rule__CodeBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCodeBlockAccess().getCodeBlockAction_0()); }
	()
	{ after(grammarAccess.getCodeBlockAccess().getCodeBlockAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CodeBlock__Group__1__Impl
	rule__CodeBlock__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCodeBlockAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getCodeBlockAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CodeBlock__Group__2__Impl
	rule__CodeBlock__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCodeBlockAccess().getCodeAssignment_2()); }
	(rule__CodeBlock__CodeAssignment_2)*
	{ after(grammarAccess.getCodeBlockAccess().getCodeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CodeBlock__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCodeBlockAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getCodeBlockAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VerifyCalledStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group__0__Impl
	rule__VerifyCalledStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getVerifyCalledStatementAction_0()); }
	()
	{ after(grammarAccess.getVerifyCalledStatementAccess().getVerifyCalledStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group__1__Impl
	rule__VerifyCalledStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getAssertKeyword_1()); }
	'assert'
	{ after(grammarAccess.getVerifyCalledStatementAccess().getAssertKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group__2__Impl
	rule__VerifyCalledStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getNegatedAssignment_2()); }
	(rule__VerifyCalledStatement__NegatedAssignment_2)?
	{ after(grammarAccess.getVerifyCalledStatementAccess().getNegatedAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group__3__Impl
	rule__VerifyCalledStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getCalledKeyword_3()); }
	'called'
	{ after(grammarAccess.getVerifyCalledStatementAccess().getCalledKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group__4__Impl
	rule__VerifyCalledStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getReferenceAssignment_4()); }
	(rule__VerifyCalledStatement__ReferenceAssignment_4)
	{ after(grammarAccess.getVerifyCalledStatementAccess().getReferenceAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getGroup_5()); }
	(rule__VerifyCalledStatement__Group_5__0)?
	{ after(grammarAccess.getVerifyCalledStatementAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VerifyCalledStatement__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group_5__0__Impl
	rule__VerifyCalledStatement__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getTimesAssignment_5_0()); }
	(rule__VerifyCalledStatement__TimesAssignment_5_0)
	{ after(grammarAccess.getVerifyCalledStatementAccess().getTimesAssignment_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VerifyCalledStatement__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVerifyCalledStatementAccess().getTimesKeyword_5_1()); }
	'times'
	{ after(grammarAccess.getVerifyCalledStatementAccess().getTimesKeyword_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MockReturnStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group__0__Impl
	rule__MockReturnStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getMockReturnStatementAction_0()); }
	()
	{ after(grammarAccess.getMockReturnStatementAccess().getMockReturnStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group__1__Impl
	rule__MockReturnStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getMockKeyword_1()); }
	'mock'
	{ after(grammarAccess.getMockReturnStatementAccess().getMockKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group__2__Impl
	rule__MockReturnStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getReferenceAssignment_2()); }
	(rule__MockReturnStatement__ReferenceAssignment_2)
	{ after(grammarAccess.getMockReturnStatementAccess().getReferenceAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getGroup_3()); }
	(rule__MockReturnStatement__Group_3__0)?
	{ after(grammarAccess.getMockReturnStatementAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MockReturnStatement__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group_3__0__Impl
	rule__MockReturnStatement__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getReturnsKeyword_3_0()); }
	'returns'
	{ after(grammarAccess.getMockReturnStatementAccess().getReturnsKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group_3__1__Impl
	rule__MockReturnStatement__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getLeftParenthesisKeyword_3_1()); }
	'('
	{ after(grammarAccess.getMockReturnStatementAccess().getLeftParenthesisKeyword_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group_3__2__Impl
	rule__MockReturnStatement__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getValueAssignment_3_2()); }
	(rule__MockReturnStatement__ValueAssignment_3_2)
	{ after(grammarAccess.getMockReturnStatementAccess().getValueAssignment_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MockReturnStatement__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMockReturnStatementAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getMockReturnStatementAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssertionStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssertionStatement__Group__0__Impl
	rule__AssertionStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssertionStatementAccess().getAssertionStatementAction_0()); }
	()
	{ after(grammarAccess.getAssertionStatementAccess().getAssertionStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssertionStatement__Group__1__Impl
	rule__AssertionStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssertionStatementAccess().getAssertKeyword_1()); }
	'assert'
	{ after(grammarAccess.getAssertionStatementAccess().getAssertKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssertionStatement__Group__2__Impl
	rule__AssertionStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssertionStatementAccess().getExpressionAssignment_2()); }
	(rule__AssertionStatement__ExpressionAssignment_2)
	{ after(grammarAccess.getAssertionStatementAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssertionStatement__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssertionStatementAccess().getGroup_3()); }
	(rule__AssertionStatement__Group_3__0)?
	{ after(grammarAccess.getAssertionStatementAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssertionStatement__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssertionStatement__Group_3__0__Impl
	rule__AssertionStatement__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssertionStatementAccess().getMessageKeyword_3_0()); }
	'message'
	{ after(grammarAccess.getAssertionStatementAccess().getMessageKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssertionStatement__Group_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssertionStatementAccess().getErrorMsgAssignment_3_1()); }
	(rule__AssertionStatement__ErrorMsgAssignment_3_1)
	{ after(grammarAccess.getAssertionStatementAccess().getErrorMsgAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExitExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExitExpression__Group__0__Impl
	rule__ExitExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExitExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExitExpressionAccess().getExitExpressionAction_0()); }
	()
	{ after(grammarAccess.getExitExpressionAccess().getExitExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExitExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExitExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExitExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExitExpressionAccess().getExitKeyword_1()); }
	'exit'
	{ after(grammarAccess.getExitExpressionAccess().getExitKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnterExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnterExpression__Group__0__Impl
	rule__EnterExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnterExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnterExpressionAccess().getEnterExpressionAction_0()); }
	()
	{ after(grammarAccess.getEnterExpressionAccess().getEnterExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnterExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnterExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnterExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnterExpressionAccess().getEnterKeyword_1()); }
	'enter'
	{ after(grammarAccess.getEnterExpressionAccess().getEnterKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TriggerWithoutEventExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TriggerWithoutEventExpression__Group__0__Impl
	rule__TriggerWithoutEventExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TriggerWithoutEventExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTriggerWithoutEventExpressionAccess().getTriggerWithoutEventExpressionAction_0()); }
	()
	{ after(grammarAccess.getTriggerWithoutEventExpressionAccess().getTriggerWithoutEventExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TriggerWithoutEventExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TriggerWithoutEventExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TriggerWithoutEventExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTriggerWithoutEventExpressionAccess().getTriggerWithoutEventKeyword_1()); }
	'triggerWithoutEvent'
	{ after(grammarAccess.getTriggerWithoutEventExpressionAccess().getTriggerWithoutEventKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ProceedExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProceedExpression__Group__0__Impl
	rule__ProceedExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProceedExpressionAccess().getProceedExpressionAction_0()); }
	()
	{ after(grammarAccess.getProceedExpressionAccess().getProceedExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProceedExpression__Group__1__Impl
	rule__ProceedExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProceedExpressionAccess().getProceedKeyword_1()); }
	'proceed'
	{ after(grammarAccess.getProceedExpressionAccess().getProceedKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProceedExpression__Group__2__Impl
	rule__ProceedExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProceedExpressionAccess().getValueAssignment_2()); }
	(rule__ProceedExpression__ValueAssignment_2)
	{ after(grammarAccess.getProceedExpressionAccess().getValueAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProceedExpression__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProceedExpressionAccess().getUnitAssignment_3()); }
	(rule__ProceedExpression__UnitAssignment_3)
	{ after(grammarAccess.getProceedExpressionAccess().getUnitAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StatechartActiveExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatechartActiveExpression__Group__0__Impl
	rule__StatechartActiveExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StatechartActiveExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatechartActiveExpressionAccess().getStatechartActiveExpressionAction_0()); }
	()
	{ after(grammarAccess.getStatechartActiveExpressionAccess().getStatechartActiveExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatechartActiveExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatechartActiveExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StatechartActiveExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatechartActiveExpressionAccess().getIs_activeKeyword_1()); }
	'is_active'
	{ after(grammarAccess.getStatechartActiveExpressionAccess().getIs_activeKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StatechartFinalExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatechartFinalExpression__Group__0__Impl
	rule__StatechartFinalExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StatechartFinalExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatechartFinalExpressionAccess().getStatechartFinalExpressionAction_0()); }
	()
	{ after(grammarAccess.getStatechartFinalExpressionAccess().getStatechartFinalExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatechartFinalExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatechartFinalExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StatechartFinalExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatechartFinalExpressionAccess().getIs_finalKeyword_1()); }
	'is_final'
	{ after(grammarAccess.getStatechartFinalExpressionAccess().getIs_finalKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ExpressionStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExpressionStatement__Group__0__Impl
	rule__ExpressionStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionStatementAccess().getExpressionStatementAction_0()); }
	()
	{ after(grammarAccess.getExpressionStatementAccess().getExpressionStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ExpressionStatement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getExpressionStatementAccess().getExpressionAssignment_1()); }
	(rule__ExpressionStatement__ExpressionAssignment_1)
	{ after(grammarAccess.getExpressionStatementAccess().getExpressionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LoopStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LoopStatement__Group__0__Impl
	rule__LoopStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLoopStatementAccess().getLoopStatementAction_0()); }
	()
	{ after(grammarAccess.getLoopStatementAccess().getLoopStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LoopStatement__Group__1__Impl
	rule__LoopStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLoopStatementAccess().getWhileKeyword_1()); }
	'while'
	{ after(grammarAccess.getLoopStatementAccess().getWhileKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LoopStatement__Group__2__Impl
	rule__LoopStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLoopStatementAccess().getLeftParenthesisKeyword_2()); }
	'('
	{ after(grammarAccess.getLoopStatementAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LoopStatement__Group__3__Impl
	rule__LoopStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLoopStatementAccess().getGuardAssignment_3()); }
	(rule__LoopStatement__GuardAssignment_3)
	{ after(grammarAccess.getLoopStatementAccess().getGuardAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LoopStatement__Group__4__Impl
	rule__LoopStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLoopStatementAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getLoopStatementAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LoopStatement__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLoopStatementAccess().getBodyAssignment_5()); }
	(rule__LoopStatement__BodyAssignment_5)
	{ after(grammarAccess.getLoopStatementAccess().getBodyAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDefinitionStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinitionStatement__Group__0__Impl
	rule__VariableDefinitionStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinitionStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionStatementAccess().getVariableDefinitionStatementAction_0()); }
	()
	{ after(grammarAccess.getVariableDefinitionStatementAccess().getVariableDefinitionStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinitionStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinitionStatement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinitionStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionStatementAccess().getDefinitionAssignment_1()); }
	(rule__VariableDefinitionStatement__DefinitionAssignment_1)
	{ after(grammarAccess.getVariableDefinitionStatementAccess().getDefinitionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group__0__Impl
	rule__VariableDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getAlternatives_0()); }
	(rule__VariableDefinition__Alternatives_0)
	{ after(grammarAccess.getVariableDefinitionAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group__1__Impl
	rule__VariableDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getReadonlyAssignment_1()); }
	(rule__VariableDefinition__ReadonlyAssignment_1)?
	{ after(grammarAccess.getVariableDefinitionAccess().getReadonlyAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group__2__Impl
	rule__VariableDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getNameAssignment_2()); }
	(rule__VariableDefinition__NameAssignment_2)
	{ after(grammarAccess.getVariableDefinitionAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getAlternatives_3()); }
	(rule__VariableDefinition__Alternatives_3)
	{ after(grammarAccess.getVariableDefinitionAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDefinition__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group_3_0__0__Impl
	rule__VariableDefinition__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getColonKeyword_3_0_0()); }
	':'
	{ after(grammarAccess.getVariableDefinitionAccess().getColonKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group_3_0__1__Impl
	rule__VariableDefinition__Group_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getTypeSpecifierAssignment_3_0_1()); }
	(rule__VariableDefinition__TypeSpecifierAssignment_3_0_1)
	{ after(grammarAccess.getVariableDefinitionAccess().getTypeSpecifierAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getGroup_3_0_2()); }
	(rule__VariableDefinition__Group_3_0_2__0)?
	{ after(grammarAccess.getVariableDefinitionAccess().getGroup_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDefinition__Group_3_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group_3_0_2__0__Impl
	rule__VariableDefinition__Group_3_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getEqualsSignKeyword_3_0_2_0()); }
	'='
	{ after(grammarAccess.getVariableDefinitionAccess().getEqualsSignKeyword_3_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group_3_0_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getInitialValueAssignment_3_0_2_1()); }
	(rule__VariableDefinition__InitialValueAssignment_3_0_2_1)
	{ after(grammarAccess.getVariableDefinitionAccess().getInitialValueAssignment_3_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableDefinition__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group_3_1__0__Impl
	rule__VariableDefinition__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getEqualsSignKeyword_3_1_0()); }
	'='
	{ after(grammarAccess.getVariableDefinitionAccess().getEqualsSignKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableDefinition__Group_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableDefinitionAccess().getInitialValueAssignment_3_1_1()); }
	(rule__VariableDefinition__InitialValueAssignment_3_1_1)
	{ after(grammarAccess.getVariableDefinitionAccess().getInitialValueAssignment_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IfStatement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__0__Impl
	rule__IfStatement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getIfStatementAction_0()); }
	()
	{ after(grammarAccess.getIfStatementAccess().getIfStatementAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__1__Impl
	rule__IfStatement__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getIfKeyword_1()); }
	'if'
	{ after(grammarAccess.getIfStatementAccess().getIfKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__2__Impl
	rule__IfStatement__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_2()); }
	'('
	{ after(grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__3__Impl
	rule__IfStatement__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getConditionAssignment_3()); }
	(rule__IfStatement__ConditionAssignment_3)
	{ after(grammarAccess.getIfStatementAccess().getConditionAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__4__Impl
	rule__IfStatement__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__5__Impl
	rule__IfStatement__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getThenAssignment_5()); }
	(rule__IfStatement__ThenAssignment_5)
	{ after(grammarAccess.getIfStatementAccess().getThenAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getGroup_6()); }
	(rule__IfStatement__Group_6__0)?
	{ after(grammarAccess.getIfStatementAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IfStatement__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group_6__0__Impl
	rule__IfStatement__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getElseKeyword_6_0()); }
	'else'
	{ after(grammarAccess.getIfStatementAccess().getElseKeyword_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IfStatement__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIfStatementAccess().getElseAssignment_6_1()); }
	(rule__IfStatement__ElseAssignment_6_1)
	{ after(grammarAccess.getIfStatementAccess().getElseAssignment_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnStatement__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group_0__0__Impl
	rule__ReturnStatement__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnStatementAction_0_0()); }
	()
	{ after(grammarAccess.getReturnStatementAccess().getReturnStatementAction_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group_0__1__Impl
	rule__ReturnStatement__Group_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnKeyword_0_1()); }
	'return'
	{ after(grammarAccess.getReturnStatementAccess().getReturnKeyword_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnValueAssignment_0_2()); }
	(rule__ReturnStatement__ReturnValueAssignment_0_2)
	{ after(grammarAccess.getReturnStatementAccess().getReturnValueAssignment_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ReturnStatement__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group_1__0__Impl
	rule__ReturnStatement__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnStatementAction_1_0()); }
	()
	{ after(grammarAccess.getReturnStatementAccess().getReturnStatementAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group_1__1__Impl
	rule__ReturnStatement__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getReturnKeyword_1_1()); }
	'return'
	{ after(grammarAccess.getReturnStatementAccess().getReturnKeyword_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ReturnStatement__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getReturnStatementAccess().getSemicolonKeyword_1_2()); }
	';'
	{ after(grammarAccess.getReturnStatementAccess().getSemicolonKeyword_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Annotation__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group__0__Impl
	rule__Annotation__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getCommercialAtKeyword_0()); }
	'@'
	{ after(grammarAccess.getAnnotationAccess().getCommercialAtKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group__1__Impl
	rule__Annotation__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getTypeAssignment_1()); }
	(rule__Annotation__TypeAssignment_1)
	{ after(grammarAccess.getAnnotationAccess().getTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getGroup_2()); }
	(rule__Annotation__Group_2__0)?
	{ after(grammarAccess.getAnnotationAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Annotation__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group_2__0__Impl
	rule__Annotation__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getLeftParenthesisKeyword_2_0()); }
	'('
	{ after(grammarAccess.getAnnotationAccess().getLeftParenthesisKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group_2__1__Impl
	rule__Annotation__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getGroup_2_1()); }
	(rule__Annotation__Group_2_1__0)?
	{ after(grammarAccess.getAnnotationAccess().getGroup_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getRightParenthesisKeyword_2_2()); }
	')'
	{ after(grammarAccess.getAnnotationAccess().getRightParenthesisKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Annotation__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group_2_1__0__Impl
	rule__Annotation__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getArgumentsAssignment_2_1_0()); }
	(rule__Annotation__ArgumentsAssignment_2_1_0)
	{ after(grammarAccess.getAnnotationAccess().getArgumentsAssignment_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getGroup_2_1_1()); }
	(rule__Annotation__Group_2_1_1__0)*
	{ after(grammarAccess.getAnnotationAccess().getGroup_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Annotation__Group_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group_2_1_1__0__Impl
	rule__Annotation__Group_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getCommaKeyword_2_1_1_0()); }
	','
	{ after(grammarAccess.getAnnotationAccess().getCommaKeyword_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Annotation__Group_2_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__Group_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAnnotationAccess().getArgumentsAssignment_2_1_1_1()); }
	(rule__Annotation__ArgumentsAssignment_2_1_1_1)
	{ after(grammarAccess.getAnnotationAccess().getArgumentsAssignment_2_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Parameter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Parameter__Group__0__Impl
	rule__Parameter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterAccess().getNameAssignment_0()); }
	(rule__Parameter__NameAssignment_0)
	{ after(grammarAccess.getParameterAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Parameter__Group__1__Impl
	rule__Parameter__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterAccess().getVarArgsAssignment_1()); }
	(rule__Parameter__VarArgsAssignment_1)?
	{ after(grammarAccess.getParameterAccess().getVarArgsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Parameter__Group__2__Impl
	rule__Parameter__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterAccess().getColonKeyword_2()); }
	':'
	{ after(grammarAccess.getParameterAccess().getColonKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Parameter__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterAccess().getTypeSpecifierAssignment_3()); }
	(rule__Parameter__TypeSpecifierAssignment_3)
	{ after(grammarAccess.getParameterAccess().getTypeSpecifierAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleFeatureCall__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group__0__Impl
	rule__SimpleFeatureCall__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getSimpleElementReferenceExpressionParserRuleCall_0()); }
	ruleSimpleElementReferenceExpression
	{ after(grammarAccess.getSimpleFeatureCallAccess().getSimpleElementReferenceExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getGroup_1()); }
	(rule__SimpleFeatureCall__Group_1__0)*
	{ after(grammarAccess.getSimpleFeatureCallAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleFeatureCall__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1__0__Impl
	rule__SimpleFeatureCall__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getAlternatives_1_0()); }
	(rule__SimpleFeatureCall__Alternatives_1_0)
	{ after(grammarAccess.getSimpleFeatureCallAccess().getAlternatives_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1__1__Impl
	rule__SimpleFeatureCall__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getFeatureAssignment_1_1()); }
	(rule__SimpleFeatureCall__FeatureAssignment_1_1)
	{ after(grammarAccess.getSimpleFeatureCallAccess().getFeatureAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_2()); }
	(rule__SimpleFeatureCall__Group_1_2__0)?
	{ after(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleFeatureCall__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_0_0__0__Impl
	rule__SimpleFeatureCall__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getSimpleFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getFullStopKeyword_1_0_0_1()); }
	'.'
	{ after(grammarAccess.getSimpleFeatureCallAccess().getFullStopKeyword_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleFeatureCall__Group_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_0_1__0__Impl
	rule__SimpleFeatureCall__Group_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getMetaCallOwnerAction_1_0_1_0()); }
	()
	{ after(grammarAccess.getSimpleFeatureCallAccess().getMetaCallOwnerAction_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_1_1()); }
	'.@'
	{ after(grammarAccess.getSimpleFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleFeatureCall__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_2__0__Impl
	rule__SimpleFeatureCall__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getOperationCallAssignment_1_2_0()); }
	(rule__SimpleFeatureCall__OperationCallAssignment_1_2_0)
	{ after(grammarAccess.getSimpleFeatureCallAccess().getOperationCallAssignment_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_2__1__Impl
	rule__SimpleFeatureCall__Group_1_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_2_1()); }
	(rule__SimpleFeatureCall__Group_1_2_1__0)?
	{ after(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getRightParenthesisKeyword_1_2_2()); }
	')'
	{ after(grammarAccess.getSimpleFeatureCallAccess().getRightParenthesisKeyword_1_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleFeatureCall__Group_1_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_2_1__0__Impl
	rule__SimpleFeatureCall__Group_1_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getArgumentsAssignment_1_2_1_0()); }
	(rule__SimpleFeatureCall__ArgumentsAssignment_1_2_1_0)
	{ after(grammarAccess.getSimpleFeatureCallAccess().getArgumentsAssignment_1_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_2_1_1()); }
	(rule__SimpleFeatureCall__Group_1_2_1_1__0)*
	{ after(grammarAccess.getSimpleFeatureCallAccess().getGroup_1_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleFeatureCall__Group_1_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_2_1_1__0__Impl
	rule__SimpleFeatureCall__Group_1_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getCommaKeyword_1_2_1_1_0()); }
	','
	{ after(grammarAccess.getSimpleFeatureCallAccess().getCommaKeyword_1_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleFeatureCall__Group_1_2_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__Group_1_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleFeatureCallAccess().getArgumentsAssignment_1_2_1_1_1()); }
	(rule__SimpleFeatureCall__ArgumentsAssignment_1_2_1_1_1)
	{ after(grammarAccess.getSimpleFeatureCallAccess().getArgumentsAssignment_1_2_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleElementReferenceExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group__0__Impl
	rule__SimpleElementReferenceExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceAssignment_0()); }
	(rule__SimpleElementReferenceExpression__ReferenceAssignment_0)
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup_1()); }
	(rule__SimpleElementReferenceExpression__Group_1__0)?
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleElementReferenceExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group_1__0__Impl
	rule__SimpleElementReferenceExpression__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallAssignment_1_0()); }
	(rule__SimpleElementReferenceExpression__OperationCallAssignment_1_0)
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group_1__1__Impl
	rule__SimpleElementReferenceExpression__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup_1_1()); }
	(rule__SimpleElementReferenceExpression__Group_1_1__0)?
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getRightParenthesisKeyword_1_2()); }
	')'
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getRightParenthesisKeyword_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleElementReferenceExpression__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group_1_1__0__Impl
	rule__SimpleElementReferenceExpression__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsAssignment_1_1_0()); }
	(rule__SimpleElementReferenceExpression__ArgumentsAssignment_1_1_0)
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsAssignment_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup_1_1_1()); }
	(rule__SimpleElementReferenceExpression__Group_1_1_1__0)*
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getGroup_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleElementReferenceExpression__Group_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group_1_1_1__0__Impl
	rule__SimpleElementReferenceExpression__Group_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getCommaKeyword_1_1_1_0()); }
	','
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getCommaKeyword_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleElementReferenceExpression__Group_1_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__Group_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsAssignment_1_1_1_1()); }
	(rule__SimpleElementReferenceExpression__ArgumentsAssignment_1_1_1_1)
	{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsAssignment_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ActiveStateReferenceExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ActiveStateReferenceExpression__Group__0__Impl
	rule__ActiveStateReferenceExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getActiveStateReferenceExpressionAction_0()); }
	()
	{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getActiveStateReferenceExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ActiveStateReferenceExpression__Group__1__Impl
	rule__ActiveStateReferenceExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getActiveKeyword_1()); }
	'active'
	{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getActiveKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ActiveStateReferenceExpression__Group__2__Impl
	rule__ActiveStateReferenceExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getLeftParenthesisKeyword_2()); }
	'('
	{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ActiveStateReferenceExpression__Group__3__Impl
	rule__ActiveStateReferenceExpression__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getValueAssignment_3()); }
	(rule__ActiveStateReferenceExpression__ValueAssignment_3)
	{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getValueAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ActiveStateReferenceExpression__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FQN__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FQN__Group__0__Impl
	rule__FQN__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FQN__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_0()); }
	ruleIDWithKeywords
	{ after(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FQN__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FQN__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FQN__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFQNAccess().getGroup_1()); }
	(rule__FQN__Group_1__0)*
	{ after(grammarAccess.getFQNAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FQN__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FQN__Group_1__0__Impl
	rule__FQN__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FQN__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFQNAccess().getFullStopKeyword_1_0()); }
	'.'
	{ after(grammarAccess.getFQNAccess().getFullStopKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FQN__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FQN__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FQN__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_1_1()); }
	ruleIDWithKeywords
	{ after(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssignmentExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group__0__Impl
	rule__AssignmentExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getConditionalExpressionParserRuleCall_0()); }
	ruleConditionalExpression
	{ after(grammarAccess.getAssignmentExpressionAccess().getConditionalExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_1()); }
	(rule__AssignmentExpression__Group_1__0)*
	{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssignmentExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getGroup_1_0()); }
	(rule__AssignmentExpression__Group_1_0__0)
	{ after(grammarAccess.getAssignmentExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AssignmentExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1_0__0__Impl
	rule__AssignmentExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionVarRefAction_1_0_0()); }
	()
	{ after(grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionVarRefAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1_0__1__Impl
	rule__AssignmentExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__AssignmentExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AssignmentExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAssignmentExpressionAccess().getExpressionAssignment_1_0_2()); }
	(rule__AssignmentExpression__ExpressionAssignment_1_0_2)
	{ after(grammarAccess.getAssignmentExpressionAccess().getExpressionAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConditionalExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group__0__Impl
	rule__ConditionalExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getLogicalOrExpressionParserRuleCall_0()); }
	ruleLogicalOrExpression
	{ after(grammarAccess.getConditionalExpressionAccess().getLogicalOrExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getGroup_1()); }
	(rule__ConditionalExpression__Group_1__0)?
	{ after(grammarAccess.getConditionalExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConditionalExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getGroup_1_0()); }
	(rule__ConditionalExpression__Group_1_0__0)
	{ after(grammarAccess.getConditionalExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ConditionalExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__0__Impl
	rule__ConditionalExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getConditionalExpressionConditionAction_1_0_0()); }
	()
	{ after(grammarAccess.getConditionalExpressionAccess().getConditionalExpressionConditionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__1__Impl
	rule__ConditionalExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getQuestionMarkKeyword_1_0_1()); }
	'?'
	{ after(grammarAccess.getConditionalExpressionAccess().getQuestionMarkKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__2__Impl
	rule__ConditionalExpression__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getTrueCaseAssignment_1_0_2()); }
	(rule__ConditionalExpression__TrueCaseAssignment_1_0_2)
	{ after(grammarAccess.getConditionalExpressionAccess().getTrueCaseAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__3__Impl
	rule__ConditionalExpression__Group_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getColonKeyword_1_0_3()); }
	':'
	{ after(grammarAccess.getConditionalExpressionAccess().getColonKeyword_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ConditionalExpression__Group_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__Group_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConditionalExpressionAccess().getFalseCaseAssignment_1_0_4()); }
	(rule__ConditionalExpression__FalseCaseAssignment_1_0_4)
	{ after(grammarAccess.getConditionalExpressionAccess().getFalseCaseAssignment_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalOrExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group__0__Impl
	rule__LogicalOrExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getLogicalAndExpressionParserRuleCall_0()); }
	ruleLogicalAndExpression
	{ after(grammarAccess.getLogicalOrExpressionAccess().getLogicalAndExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getGroup_1()); }
	(rule__LogicalOrExpression__Group_1__0)*
	{ after(grammarAccess.getLogicalOrExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalOrExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getGroup_1_0()); }
	(rule__LogicalOrExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalOrExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalOrExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1_0__0__Impl
	rule__LogicalOrExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1_0__1__Impl
	rule__LogicalOrExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrOperatorParserRuleCall_1_0_1()); }
	ruleLogicalOrOperator
	{ after(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalOrExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__LogicalOrExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalAndExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group__0__Impl
	rule__LogicalAndExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getLogicalNotExpressionParserRuleCall_0()); }
	ruleLogicalNotExpression
	{ after(grammarAccess.getLogicalAndExpressionAccess().getLogicalNotExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getGroup_1()); }
	(rule__LogicalAndExpression__Group_1__0)*
	{ after(grammarAccess.getLogicalAndExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalAndExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getGroup_1_0()); }
	(rule__LogicalAndExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalAndExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalAndExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1_0__0__Impl
	rule__LogicalAndExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1_0__1__Impl
	rule__LogicalAndExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndOperatorParserRuleCall_1_0_1()); }
	ruleLogicalAndOperator
	{ after(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalAndExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__LogicalAndExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalNotExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getGroup_1_0()); }
	(rule__LogicalNotExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalNotExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalNotExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1_0__0__Impl
	rule__LogicalNotExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotExpressionAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotExpressionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1_0__1__Impl
	rule__LogicalNotExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotOperatorParserRuleCall_1_0_1()); }
	ruleLogicalNotOperator
	{ after(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalNotExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalNotExpressionAccess().getOperandAssignment_1_0_2()); }
	(rule__LogicalNotExpression__OperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalNotExpressionAccess().getOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseOrExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group__0__Impl
	rule__BitwiseOrExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseXorExpressionParserRuleCall_0()); }
	ruleBitwiseXorExpression
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseXorExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1()); }
	(rule__BitwiseOrExpression__Group_1__0)*
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseOrExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1_0()); }
	(rule__BitwiseOrExpression__Group_1_0__0)
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseOrExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1_0__0__Impl
	rule__BitwiseOrExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1_0__1__Impl
	rule__BitwiseOrExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrOperatorParserRuleCall_1_0_1()); }
	ruleBitwiseOrOperator
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseOrExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__BitwiseOrExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseXorExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group__0__Impl
	rule__BitwiseXorExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseAndExpressionParserRuleCall_0()); }
	ruleBitwiseAndExpression
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseAndExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1()); }
	(rule__BitwiseXorExpression__Group_1__0)*
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseXorExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1_0()); }
	(rule__BitwiseXorExpression__Group_1_0__0)
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseXorExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1_0__0__Impl
	rule__BitwiseXorExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXorExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXorExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1_0__1__Impl
	rule__BitwiseXorExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXOrOperatorParserRuleCall_1_0_1()); }
	ruleBitwiseXOrOperator
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXOrOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseXorExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__BitwiseXorExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseAndExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group__0__Impl
	rule__BitwiseAndExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getLogicalRelationExpressionParserRuleCall_0()); }
	ruleLogicalRelationExpression
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getLogicalRelationExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1()); }
	(rule__BitwiseAndExpression__Group_1__0)*
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseAndExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1_0()); }
	(rule__BitwiseAndExpression__Group_1_0__0)
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BitwiseAndExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1_0__0__Impl
	rule__BitwiseAndExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1_0__1__Impl
	rule__BitwiseAndExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndOperatorParserRuleCall_1_0_1()); }
	ruleBitwiseAndOperator
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndOperatorParserRuleCall_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BitwiseAndExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__BitwiseAndExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalRelationExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group__0__Impl
	rule__LogicalRelationExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getShiftExpressionParserRuleCall_0()); }
	ruleShiftExpression
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getShiftExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1()); }
	(rule__LogicalRelationExpression__Group_1__0)*
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalRelationExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1_0()); }
	(rule__LogicalRelationExpression__Group_1_0__0)
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LogicalRelationExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1_0__0__Impl
	rule__LogicalRelationExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getLogicalRelationExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getLogicalRelationExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1_0__1__Impl
	rule__LogicalRelationExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__LogicalRelationExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LogicalRelationExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__LogicalRelationExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ShiftExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group__0__Impl
	rule__ShiftExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getNumericalAddSubtractExpressionParserRuleCall_0()); }
	ruleNumericalAddSubtractExpression
	{ after(grammarAccess.getShiftExpressionAccess().getNumericalAddSubtractExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getGroup_1()); }
	(rule__ShiftExpression__Group_1__0)*
	{ after(grammarAccess.getShiftExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ShiftExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getGroup_1_0()); }
	(rule__ShiftExpression__Group_1_0__0)
	{ after(grammarAccess.getShiftExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ShiftExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1_0__0__Impl
	rule__ShiftExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getShiftExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getShiftExpressionAccess().getShiftExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1_0__1__Impl
	rule__ShiftExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__ShiftExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getShiftExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ShiftExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getShiftExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__ShiftExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getShiftExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalAddSubtractExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group__0__Impl
	rule__NumericalAddSubtractExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalMultiplyDivideExpressionParserRuleCall_0()); }
	ruleNumericalMultiplyDivideExpression
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalMultiplyDivideExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1()); }
	(rule__NumericalAddSubtractExpression__Group_1__0)*
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalAddSubtractExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1_0()); }
	(rule__NumericalAddSubtractExpression__Group_1_0__0)
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalAddSubtractExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1_0__0__Impl
	rule__NumericalAddSubtractExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalAddSubtractExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalAddSubtractExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1_0__1__Impl
	rule__NumericalAddSubtractExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__NumericalAddSubtractExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalAddSubtractExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__NumericalAddSubtractExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalMultiplyDivideExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group__0__Impl
	rule__NumericalMultiplyDivideExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalUnaryExpressionParserRuleCall_0()); }
	ruleNumericalUnaryExpression
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalUnaryExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1()); }
	(rule__NumericalMultiplyDivideExpression__Group_1__0)*
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalMultiplyDivideExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1_0()); }
	(rule__NumericalMultiplyDivideExpression__Group_1_0__0)
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalMultiplyDivideExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1_0__0__Impl
	rule__NumericalMultiplyDivideExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalMultiplyDivideExpressionLeftOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalMultiplyDivideExpressionLeftOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1_0__1__Impl
	rule__NumericalMultiplyDivideExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__NumericalMultiplyDivideExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalMultiplyDivideExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandAssignment_1_0_2()); }
	(rule__NumericalMultiplyDivideExpression__RightOperandAssignment_1_0_2)
	{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalUnaryExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1_0()); }
	(rule__NumericalUnaryExpression__Group_1_0__0)
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NumericalUnaryExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1_0__0__Impl
	rule__NumericalUnaryExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getNumericalUnaryExpressionAction_1_0_0()); }
	()
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getNumericalUnaryExpressionAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1_0__1__Impl
	rule__NumericalUnaryExpression__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__NumericalUnaryExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NumericalUnaryExpression__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperandAssignment_1_0_2()); }
	(rule__NumericalUnaryExpression__OperandAssignment_1_0_2)
	{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperandAssignment_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostFixUnaryExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group__0__Impl
	rule__PostFixUnaryExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getTypeCastExpressionParserRuleCall_0()); }
	ruleTypeCastExpression
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getTypeCastExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1()); }
	(rule__PostFixUnaryExpression__Group_1__0)*
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostFixUnaryExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1_0()); }
	(rule__PostFixUnaryExpression__Group_1_0__0)
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PostFixUnaryExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group_1_0__0__Impl
	rule__PostFixUnaryExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getPostFixUnaryExpressionOperandAction_1_0_0()); }
	()
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getPostFixUnaryExpressionOperandAction_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PostFixUnaryExpression__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
	(rule__PostFixUnaryExpression__OperatorAssignment_1_0_1)
	{ after(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group__0__Impl
	rule__TypeCastExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getFeatureCallParserRuleCall_0()); }
	ruleFeatureCall
	{ after(grammarAccess.getTypeCastExpressionAccess().getFeatureCallParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getGroup_1()); }
	(rule__TypeCastExpression__Group_1__0)*
	{ after(grammarAccess.getTypeCastExpressionAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0()); }
	(rule__TypeCastExpression__Group_1_0__0)
	{ after(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0__0__Impl
	rule__TypeCastExpression__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0_0()); }
	(rule__TypeCastExpression__Group_1_0_0__0)
	{ after(grammarAccess.getTypeCastExpressionAccess().getGroup_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierAssignment_1_0_1()); }
	(rule__TypeCastExpression__TypeSpecifierAssignment_1_0_1)
	{ after(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeCastExpression__Group_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0_0__0__Impl
	rule__TypeCastExpression__Group_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getTypeCastExpressionOperandAction_1_0_0_0()); }
	()
	{ after(grammarAccess.getTypeCastExpressionAccess().getTypeCastExpressionOperandAction_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeCastExpression__Group_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__Group_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeCastExpressionAccess().getAsKeyword_1_0_0_1()); }
	'as'
	{ after(grammarAccess.getTypeCastExpressionAccess().getAsKeyword_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group__0__Impl
	rule__FeatureCall__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getPrimaryExpressionParserRuleCall_0()); }
	rulePrimaryExpression
	{ after(grammarAccess.getFeatureCallAccess().getPrimaryExpressionParserRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1()); }
	(rule__FeatureCall__Group_1__0)*
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0()); }
	(rule__FeatureCall__Group_1_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0__0__Impl
	rule__FeatureCall__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_0()); }
	(rule__FeatureCall__Alternatives_1_0_0)
	{ after(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0__1__Impl
	rule__FeatureCall__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFeatureAssignment_1_0_1()); }
	(rule__FeatureCall__FeatureAssignment_1_0_1)
	{ after(grammarAccess.getFeatureCallAccess().getFeatureAssignment_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_2()); }
	(rule__FeatureCall__Alternatives_1_0_2)?
	{ after(grammarAccess.getFeatureCallAccess().getAlternatives_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_0__0__Impl
	rule__FeatureCall__Group_1_0_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0_0()); }
	()
	{ after(grammarAccess.getFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFullStopKeyword_1_0_0_0_1()); }
	('.')
	{ after(grammarAccess.getFeatureCallAccess().getFullStopKeyword_1_0_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_1__0__Impl
	rule__FeatureCall__Group_1_0_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getMetaCallOwnerAction_1_0_0_1_0()); }
	()
	{ after(grammarAccess.getFeatureCallAccess().getMetaCallOwnerAction_1_0_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1()); }
	'.@'
	{ after(grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0__0__Impl
	rule__FeatureCall__Group_1_0_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getOperationCallAssignment_1_0_2_0_0()); }
	(rule__FeatureCall__OperationCallAssignment_1_0_2_0_0)
	{ after(grammarAccess.getFeatureCallAccess().getOperationCallAssignment_1_0_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0__1__Impl
	rule__FeatureCall__Group_1_0_2_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1()); }
	(rule__FeatureCall__Group_1_0_2_0_1__0)?
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getRightParenthesisKeyword_1_0_2_0_2()); }
	')'
	{ after(grammarAccess.getFeatureCallAccess().getRightParenthesisKeyword_1_0_2_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1__0__Impl
	rule__FeatureCall__Group_1_0_2_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_0()); }
	(rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_0)
	{ after(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1_1()); }
	(rule__FeatureCall__Group_1_0_2_0_1_1__0)*
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1_1__0__Impl
	rule__FeatureCall__Group_1_0_2_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getCommaKeyword_1_0_2_0_1_1_0()); }
	','
	{ after(grammarAccess.getFeatureCallAccess().getCommaKeyword_1_0_2_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_1_1()); }
	(rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_1_1)
	{ after(grammarAccess.getFeatureCallAccess().getArgumentsAssignment_1_0_2_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1__0__Impl
	rule__FeatureCall__Group_1_0_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0()); }
	(rule__FeatureCall__Group_1_0_2_1_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1()); }
	(rule__FeatureCall__Group_1_0_2_1_1__0)*
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0_0()); }
	(rule__FeatureCall__Group_1_0_2_1_0_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0_0__0__Impl
	rule__FeatureCall__Group_1_0_2_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArrayAccessAssignment_1_0_2_1_0_0_0()); }
	(rule__FeatureCall__ArrayAccessAssignment_1_0_2_1_0_0_0)
	{ after(grammarAccess.getFeatureCallAccess().getArrayAccessAssignment_1_0_2_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0_0__1__Impl
	rule__FeatureCall__Group_1_0_2_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_0_0_1()); }
	(rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_0_0_1)
	{ after(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_0_0_2()); }
	']'
	{ after(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1_0()); }
	(rule__FeatureCall__Group_1_0_2_1_1_0__0)
	{ after(grammarAccess.getFeatureCallAccess().getGroup_1_0_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FeatureCall__Group_1_0_2_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1_0__0__Impl
	rule__FeatureCall__Group_1_0_2_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getLeftSquareBracketKeyword_1_0_2_1_1_0_0()); }
	'['
	{ after(grammarAccess.getFeatureCallAccess().getLeftSquareBracketKeyword_1_0_2_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1_0__1__Impl
	rule__FeatureCall__Group_1_0_2_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_1_0_1()); }
	(rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_1_0_1)
	{ after(grammarAccess.getFeatureCallAccess().getArraySelectorAssignment_1_0_2_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FeatureCall__Group_1_0_2_1_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__Group_1_0_2_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_1_0_2()); }
	']'
	{ after(grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group__0__Impl
	rule__ElementReferenceExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getElementReferenceExpressionAction_0()); }
	()
	{ after(grammarAccess.getElementReferenceExpressionAccess().getElementReferenceExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group__1__Impl
	rule__ElementReferenceExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getReferenceAssignment_1()); }
	(rule__ElementReferenceExpression__ReferenceAssignment_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getReferenceAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getAlternatives_2()); }
	(rule__ElementReferenceExpression__Alternatives_2)?
	{ after(grammarAccess.getElementReferenceExpressionAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0__0__Impl
	rule__ElementReferenceExpression__Group_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getOperationCallAssignment_2_0_0()); }
	(rule__ElementReferenceExpression__OperationCallAssignment_2_0_0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getOperationCallAssignment_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0__1__Impl
	rule__ElementReferenceExpression__Group_2_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1()); }
	(rule__ElementReferenceExpression__Group_2_0_1__0)?
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getRightParenthesisKeyword_2_0_2()); }
	')'
	{ after(grammarAccess.getElementReferenceExpressionAccess().getRightParenthesisKeyword_2_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1__0__Impl
	rule__ElementReferenceExpression__Group_2_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_0()); }
	(rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1_1()); }
	(rule__ElementReferenceExpression__Group_2_0_1_1__0)*
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1_1__0__Impl
	rule__ElementReferenceExpression__Group_2_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getCommaKeyword_2_0_1_1_0()); }
	','
	{ after(grammarAccess.getElementReferenceExpressionAccess().getCommaKeyword_2_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_1_1()); }
	(rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_1_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsAssignment_2_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1__0__Impl
	rule__ElementReferenceExpression__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0()); }
	(rule__ElementReferenceExpression__Group_2_1_0__0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1()); }
	(rule__ElementReferenceExpression__Group_2_1_1__0)*
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0_0()); }
	(rule__ElementReferenceExpression__Group_2_1_0_0__0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0_0__0__Impl
	rule__ElementReferenceExpression__Group_2_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessAssignment_2_1_0_0_0()); }
	(rule__ElementReferenceExpression__ArrayAccessAssignment_2_1_0_0_0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessAssignment_2_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0_0__1__Impl
	rule__ElementReferenceExpression__Group_2_1_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_0_0_1()); }
	(rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_0_0_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_0_0_2()); }
	']'
	{ after(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1_0()); }
	(rule__ElementReferenceExpression__Group_2_1_1_0__0)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getGroup_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ElementReferenceExpression__Group_2_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1_0__0__Impl
	rule__ElementReferenceExpression__Group_2_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getLeftSquareBracketKeyword_2_1_1_0_0()); }
	'['
	{ after(grammarAccess.getElementReferenceExpressionAccess().getLeftSquareBracketKeyword_2_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1_0__1__Impl
	rule__ElementReferenceExpression__Group_2_1_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_1_0_1()); }
	(rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_1_0_1)
	{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorAssignment_2_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ElementReferenceExpression__Group_2_1_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__Group_2_1_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_1_0_2()); }
	']'
	{ after(grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveValueExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveValueExpression__Group__0__Impl
	rule__PrimitiveValueExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveValueExpressionAccess().getPrimitiveValueExpressionAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveValueExpressionAccess().getPrimitiveValueExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveValueExpression__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveValueExpressionAccess().getValueAssignment_1()); }
	(rule__PrimitiveValueExpression__ValueAssignment_1)
	{ after(grammarAccess.getPrimitiveValueExpressionAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EventRaisingExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventRaisingExpression__Group__0__Impl
	rule__EventRaisingExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventRaisingExpressionAccess().getEventRaisingExpressionAction_0()); }
	()
	{ after(grammarAccess.getEventRaisingExpressionAccess().getEventRaisingExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventRaisingExpression__Group__1__Impl
	rule__EventRaisingExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventRaisingExpressionAccess().getRaiseKeyword_1()); }
	'raise'
	{ after(grammarAccess.getEventRaisingExpressionAccess().getRaiseKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventRaisingExpression__Group__2__Impl
	rule__EventRaisingExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventRaisingExpressionAccess().getEventAssignment_2()); }
	(rule__EventRaisingExpression__EventAssignment_2)
	{ after(grammarAccess.getEventRaisingExpressionAccess().getEventAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventRaisingExpression__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventRaisingExpressionAccess().getGroup_3()); }
	(rule__EventRaisingExpression__Group_3__0)?
	{ after(grammarAccess.getEventRaisingExpressionAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EventRaisingExpression__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventRaisingExpression__Group_3__0__Impl
	rule__EventRaisingExpression__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventRaisingExpressionAccess().getColonKeyword_3_0()); }
	(':')
	{ after(grammarAccess.getEventRaisingExpressionAccess().getColonKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventRaisingExpression__Group_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventRaisingExpressionAccess().getValueAssignment_3_1()); }
	(rule__EventRaisingExpression__ValueAssignment_3_1)
	{ after(grammarAccess.getEventRaisingExpressionAccess().getValueAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EventValueReferenceExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventValueReferenceExpression__Group__0__Impl
	rule__EventValueReferenceExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventValueReferenceExpressionAccess().getEventValueReferenceExpressionAction_0()); }
	()
	{ after(grammarAccess.getEventValueReferenceExpressionAccess().getEventValueReferenceExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventValueReferenceExpression__Group__1__Impl
	rule__EventValueReferenceExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventValueReferenceExpressionAccess().getValueofKeyword_1()); }
	'valueof'
	{ after(grammarAccess.getEventValueReferenceExpressionAccess().getValueofKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventValueReferenceExpression__Group__2__Impl
	rule__EventValueReferenceExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventValueReferenceExpressionAccess().getLeftParenthesisKeyword_2()); }
	'('
	{ after(grammarAccess.getEventValueReferenceExpressionAccess().getLeftParenthesisKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventValueReferenceExpression__Group__3__Impl
	rule__EventValueReferenceExpression__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventValueReferenceExpressionAccess().getValueAssignment_3()); }
	(rule__EventValueReferenceExpression__ValueAssignment_3)
	{ after(grammarAccess.getEventValueReferenceExpressionAccess().getValueAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EventValueReferenceExpression__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEventValueReferenceExpressionAccess().getRightParenthesisKeyword_4()); }
	')'
	{ after(grammarAccess.getEventValueReferenceExpressionAccess().getRightParenthesisKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InitializationExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__0__Impl
	rule__InitializationExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getInitializationExpressionAction_0()); }
	()
	{ after(grammarAccess.getInitializationExpressionAccess().getInitializationExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__1__Impl
	rule__InitializationExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getInitializationExpressionAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__2__Impl
	rule__InitializationExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getGroup_2()); }
	(rule__InitializationExpression__Group_2__0)?
	{ after(grammarAccess.getInitializationExpressionAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getInitializationExpressionAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InitializationExpression__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2__0__Impl
	rule__InitializationExpression__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_0()); }
	(rule__InitializationExpression__ArgumentsAssignment_2_0)
	{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getGroup_2_1()); }
	(rule__InitializationExpression__Group_2_1__0)*
	{ after(grammarAccess.getInitializationExpressionAccess().getGroup_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InitializationExpression__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2_1__0__Impl
	rule__InitializationExpression__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getCommaKeyword_2_1_0()); }
	','
	{ after(grammarAccess.getInitializationExpressionAccess().getCommaKeyword_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InitializationExpression__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_1_1()); }
	(rule__InitializationExpression__ArgumentsAssignment_2_1_1)
	{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsAssignment_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__0__Impl
	rule__Argument__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getGroup_0()); }
	(rule__Argument__Group_0__0)?
	{ after(grammarAccess.getArgumentAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__1__Impl
	rule__Argument__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getGroup_1()); }
	(rule__Argument__Group_1__0)?
	{ after(grammarAccess.getArgumentAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getValueAssignment_2()); }
	(rule__Argument__ValueAssignment_2)
	{ after(grammarAccess.getArgumentAccess().getValueAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_0__0__Impl
	rule__Argument__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getParameterAssignment_0_0()); }
	(rule__Argument__ParameterAssignment_0_0)
	{ after(grammarAccess.getArgumentAccess().getParameterAssignment_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getEqualsSignKeyword_0_1()); }
	'='
	{ after(grammarAccess.getArgumentAccess().getEqualsSignKeyword_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getGroup_1_0()); }
	(rule__Argument__Group_1_0__0)
	{ after(grammarAccess.getArgumentAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Argument__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_1_0__0__Impl
	rule__Argument__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getKeyAssignment_1_0_0()); }
	(rule__Argument__KeyAssignment_1_0_0)
	{ after(grammarAccess.getArgumentAccess().getKeyAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Argument__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getArgumentAccess().getColonKeyword_1_0_1()); }
	':'
	{ after(grammarAccess.getArgumentAccess().getColonKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParenthesizedExpression__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__0__Impl
	rule__ParenthesizedExpression__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getParenthesizedExpressionAction_0()); }
	()
	{ after(grammarAccess.getParenthesizedExpressionAccess().getParenthesizedExpressionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__1__Impl
	rule__ParenthesizedExpression__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_1()); }
	'('
	{ after(grammarAccess.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__2__Impl
	rule__ParenthesizedExpression__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getExpressionAssignment_2()); }
	(rule__ParenthesizedExpression__ExpressionAssignment_2)
	{ after(grammarAccess.getParenthesizedExpressionAccess().getExpressionAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParenthesizedExpression__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3()); }
	')'
	{ after(grammarAccess.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group__0__Impl
	rule__TypeSpecifier__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getTypeAssignment_0()); }
	(rule__TypeSpecifier__TypeAssignment_0)
	{ after(grammarAccess.getTypeSpecifierAccess().getTypeAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1()); }
	(rule__TypeSpecifier__Group_1__0)?
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1__0__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1_0()); }
	(rule__TypeSpecifier__Group_1_0__0)
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0__0__Impl
	rule__TypeSpecifier__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getLessThanSignKeyword_1_0_0()); }
	'<'
	{ after(grammarAccess.getTypeSpecifierAccess().getLessThanSignKeyword_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0__1__Impl
	rule__TypeSpecifier__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1()); }
	(rule__TypeSpecifier__Group_1_0_1__0)?
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGreaterThanSignKeyword_1_0_2()); }
	'>'
	{ after(grammarAccess.getTypeSpecifierAccess().getGreaterThanSignKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1__0__Impl
	rule__TypeSpecifier__Group_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_0()); }
	(rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_0)
	{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1_1()); }
	(rule__TypeSpecifier__Group_1_0_1_1__0)*
	{ after(grammarAccess.getTypeSpecifierAccess().getGroup_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TypeSpecifier__Group_1_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1_1__0__Impl
	rule__TypeSpecifier__Group_1_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getCommaKeyword_1_0_1_1_0()); }
	','
	{ after(grammarAccess.getTypeSpecifierAccess().getCommaKeyword_1_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TypeSpecifier__Group_1_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__Group_1_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_1_1()); }
	(rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_1_1)
	{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsAssignment_1_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__QID__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group__0__Impl
	rule__QID__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getIDTerminalRuleCall_0()); }
	RULE_ID
	{ after(grammarAccess.getQIDAccess().getIDTerminalRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getGroup_1()); }
	(rule__QID__Group_1__0)*
	{ after(grammarAccess.getQIDAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__QID__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group_1__0__Impl
	rule__QID__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getFullStopKeyword_1_0()); }
	('.')
	{ after(grammarAccess.getQIDAccess().getFullStopKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__QID__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__QID__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getQIDAccess().getIDTerminalRuleCall_1_1()); }
	RULE_ID
	{ after(grammarAccess.getQIDAccess().getIDTerminalRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BoolLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BoolLiteral__Group__0__Impl
	rule__BoolLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBoolLiteralAccess().getBoolLiteralAction_0()); }
	()
	{ after(grammarAccess.getBoolLiteralAccess().getBoolLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BoolLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBoolLiteralAccess().getValueAssignment_1()); }
	(rule__BoolLiteral__ValueAssignment_1)
	{ after(grammarAccess.getBoolLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntLiteral__Group__0__Impl
	rule__IntLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntLiteralAccess().getIntLiteralAction_0()); }
	()
	{ after(grammarAccess.getIntLiteralAccess().getIntLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntLiteralAccess().getValueAssignment_1()); }
	(rule__IntLiteral__ValueAssignment_1)
	{ after(grammarAccess.getIntLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DoubleLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoubleLiteral__Group__0__Impl
	rule__DoubleLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoubleLiteralAccess().getDoubleLiteralAction_0()); }
	()
	{ after(grammarAccess.getDoubleLiteralAccess().getDoubleLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DoubleLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDoubleLiteralAccess().getValueAssignment_1()); }
	(rule__DoubleLiteral__ValueAssignment_1)
	{ after(grammarAccess.getDoubleLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FloatLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FloatLiteral__Group__0__Impl
	rule__FloatLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFloatLiteralAccess().getFloatLiteralAction_0()); }
	()
	{ after(grammarAccess.getFloatLiteralAccess().getFloatLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FloatLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFloatLiteralAccess().getValueAssignment_1()); }
	(rule__FloatLiteral__ValueAssignment_1)
	{ after(grammarAccess.getFloatLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__HexLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__HexLiteral__Group__0__Impl
	rule__HexLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getHexLiteralAccess().getHexLiteralAction_0()); }
	()
	{ after(grammarAccess.getHexLiteralAccess().getHexLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__HexLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getHexLiteralAccess().getValueAssignment_1()); }
	(rule__HexLiteral__ValueAssignment_1)
	{ after(grammarAccess.getHexLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BinaryLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BinaryLiteral__Group__0__Impl
	rule__BinaryLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBinaryLiteralAccess().getBinaryLiteralAction_0()); }
	()
	{ after(grammarAccess.getBinaryLiteralAccess().getBinaryLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BinaryLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBinaryLiteralAccess().getValueAssignment_1()); }
	(rule__BinaryLiteral__ValueAssignment_1)
	{ after(grammarAccess.getBinaryLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StringLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StringLiteral__Group__0__Impl
	rule__StringLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStringLiteralAccess().getStringLiteralAction_0()); }
	()
	{ after(grammarAccess.getStringLiteralAccess().getStringLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StringLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStringLiteralAccess().getValueAssignment_1()); }
	(rule__StringLiteral__ValueAssignment_1)
	{ after(grammarAccess.getStringLiteralAccess().getValueAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__NullLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NullLiteral__Group__0__Impl
	rule__NullLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__NullLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNullLiteralAccess().getNullLiteralAction_0()); }
	()
	{ after(grammarAccess.getNullLiteralAccess().getNullLiteralAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__NullLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__NullLiteral__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__NullLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getNullLiteralAccess().getNullKeyword_1()); }
	'null'
	{ after(grammarAccess.getNullLiteralAccess().getNullKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TestPackage__NameAssignment_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTestPackageAccess().getNameQIDParserRuleCall_1_1_0()); }
		ruleQID
		{ after(grammarAccess.getTestPackageAccess().getNameQIDParserRuleCall_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TestPackage__MemberAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTestPackageAccess().getMemberSCTUnitElementParserRuleCall_2_0()); }
		ruleSCTUnitElement
		{ after(grammarAccess.getTestPackageAccess().getMemberSCTUnitElementParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__NameAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitClassAccess().getNameIDTerminalRuleCall_2_0()); }
		RULE_ID
		{ after(grammarAccess.getSCTUnitClassAccess().getNameIDTerminalRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__StatechartAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitClassAccess().getStatechartStatechartCrossReference_5_0()); }
		(
			{ before(grammarAccess.getSCTUnitClassAccess().getStatechartStatechartQIDParserRuleCall_5_0_1()); }
			ruleQID
			{ after(grammarAccess.getSCTUnitClassAccess().getStatechartStatechartQIDParserRuleCall_5_0_1()); }
		)
		{ after(grammarAccess.getSCTUnitClassAccess().getStatechartStatechartCrossReference_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__VariableDefinitionsAssignment_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitClassAccess().getVariableDefinitionsVariableDefinitionStatementParserRuleCall_7_0()); }
		ruleVariableDefinitionStatement
		{ after(grammarAccess.getSCTUnitClassAccess().getVariableDefinitionsVariableDefinitionStatementParserRuleCall_7_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClass__FeaturesAssignment_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitClassAccess().getFeaturesSCTUnitOperationParserRuleCall_8_0()); }
		ruleSCTUnitOperation
		{ after(grammarAccess.getSCTUnitClassAccess().getFeaturesSCTUnitOperationParserRuleCall_8_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__NameAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitSuiteAccess().getNameIDTerminalRuleCall_2_0()); }
		RULE_ID
		{ after(grammarAccess.getSCTUnitSuiteAccess().getNameIDTerminalRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__FeaturesAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitSuiteAccess().getFeaturesSCTUnitClassReferenceParserRuleCall_4_0()); }
		ruleSCTUnitClassReference
		{ after(grammarAccess.getSCTUnitSuiteAccess().getFeaturesSCTUnitClassReferenceParserRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitSuite__FeaturesAssignment_5_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitSuiteAccess().getFeaturesSCTUnitClassReferenceParserRuleCall_5_1_0()); }
		ruleSCTUnitClassReference
		{ after(grammarAccess.getSCTUnitSuiteAccess().getFeaturesSCTUnitClassReferenceParserRuleCall_5_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitClassReference__TypeSpecifierAssignment
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitClassReferenceAccess().getTypeSpecifierSimpleTypeSpecifierParserRuleCall_0()); }
		ruleSimpleTypeSpecifier
		{ after(grammarAccess.getSCTUnitClassReferenceAccess().getTypeSpecifierSimpleTypeSpecifierParserRuleCall_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleTypeSpecifier__TypeAssignment
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleTypeSpecifierAccess().getTypeTypeCrossReference_0()); }
		(
			{ before(grammarAccess.getSimpleTypeSpecifierAccess().getTypeTypeQIDParserRuleCall_0_1()); }
			ruleQID
			{ after(grammarAccess.getSimpleTypeSpecifierAccess().getTypeTypeQIDParserRuleCall_0_1()); }
		)
		{ after(grammarAccess.getSimpleTypeSpecifierAccess().getTypeTypeCrossReference_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__AnnotationAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitOperationAccess().getAnnotationAnnotationParserRuleCall_1_0()); }
		ruleAnnotation
		{ after(grammarAccess.getSCTUnitOperationAccess().getAnnotationAnnotationParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__NameAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitOperationAccess().getNameIDWithKeywordsParserRuleCall_3_0()); }
		ruleIDWithKeywords
		{ after(grammarAccess.getSCTUnitOperationAccess().getNameIDWithKeywordsParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__ParametersAssignment_5_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitOperationAccess().getParametersParameterParserRuleCall_5_0_0()); }
		ruleParameter
		{ after(grammarAccess.getSCTUnitOperationAccess().getParametersParameterParserRuleCall_5_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__ParametersAssignment_5_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitOperationAccess().getParametersParameterParserRuleCall_5_1_1_0()); }
		ruleParameter
		{ after(grammarAccess.getSCTUnitOperationAccess().getParametersParameterParserRuleCall_5_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__TypeSpecifierAssignment_7_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitOperationAccess().getTypeSpecifierTypeSpecifierParserRuleCall_7_1_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getSCTUnitOperationAccess().getTypeSpecifierTypeSpecifierParserRuleCall_7_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SCTUnitOperation__BodyAssignment_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSCTUnitOperationAccess().getBodyCodeBlockParserRuleCall_8_0()); }
		ruleCodeBlock
		{ after(grammarAccess.getSCTUnitOperationAccess().getBodyCodeBlockParserRuleCall_8_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CodeBlock__CodeAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCodeBlockAccess().getCodeTestStatementParserRuleCall_2_0()); }
		ruleTestStatement
		{ after(grammarAccess.getCodeBlockAccess().getCodeTestStatementParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__NegatedAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVerifyCalledStatementAccess().getNegatedExclamationMarkKeyword_2_0()); }
		(
			{ before(grammarAccess.getVerifyCalledStatementAccess().getNegatedExclamationMarkKeyword_2_0()); }
			'!'
			{ after(grammarAccess.getVerifyCalledStatementAccess().getNegatedExclamationMarkKeyword_2_0()); }
		)
		{ after(grammarAccess.getVerifyCalledStatementAccess().getNegatedExclamationMarkKeyword_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__ReferenceAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVerifyCalledStatementAccess().getReferenceSimpleFeatureCallParserRuleCall_4_0()); }
		ruleSimpleFeatureCall
		{ after(grammarAccess.getVerifyCalledStatementAccess().getReferenceSimpleFeatureCallParserRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VerifyCalledStatement__TimesAssignment_5_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVerifyCalledStatementAccess().getTimesIntLiteralParserRuleCall_5_0_0()); }
		ruleIntLiteral
		{ after(grammarAccess.getVerifyCalledStatementAccess().getTimesIntLiteralParserRuleCall_5_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__ReferenceAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMockReturnStatementAccess().getReferenceSimpleFeatureCallParserRuleCall_2_0()); }
		ruleSimpleFeatureCall
		{ after(grammarAccess.getMockReturnStatementAccess().getReferenceSimpleFeatureCallParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MockReturnStatement__ValueAssignment_3_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMockReturnStatementAccess().getValueExpressionParserRuleCall_3_2_0()); }
		ruleExpression
		{ after(grammarAccess.getMockReturnStatementAccess().getValueExpressionParserRuleCall_3_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__ExpressionAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssertionStatementAccess().getExpressionExpressionParserRuleCall_2_0()); }
		ruleExpression
		{ after(grammarAccess.getAssertionStatementAccess().getExpressionExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssertionStatement__ErrorMsgAssignment_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssertionStatementAccess().getErrorMsgSTRINGTerminalRuleCall_3_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getAssertionStatementAccess().getErrorMsgSTRINGTerminalRuleCall_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__ValueAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProceedExpressionAccess().getValueExpressionParserRuleCall_2_0()); }
		ruleExpression
		{ after(grammarAccess.getProceedExpressionAccess().getValueExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProceedExpression__UnitAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProceedExpressionAccess().getUnitProceedUnitEnumRuleCall_3_0()); }
		ruleProceedUnit
		{ after(grammarAccess.getProceedExpressionAccess().getUnitProceedUnitEnumRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__ExpressionAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExpressionStatementAccess().getExpressionAlternatives_1_0()); }
		(rule__ExpressionStatement__ExpressionAlternatives_1_0)
		{ after(grammarAccess.getExpressionStatementAccess().getExpressionAlternatives_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__GuardAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLoopStatementAccess().getGuardExpressionParserRuleCall_3_0()); }
		ruleExpression
		{ after(grammarAccess.getLoopStatementAccess().getGuardExpressionParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LoopStatement__BodyAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLoopStatementAccess().getBodyCodeBlockParserRuleCall_5_0()); }
		ruleCodeBlock
		{ after(grammarAccess.getLoopStatementAccess().getBodyCodeBlockParserRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinitionStatement__DefinitionAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionStatementAccess().getDefinitionVariableDefinitionParserRuleCall_1_0()); }
		ruleVariableDefinition
		{ after(grammarAccess.getVariableDefinitionStatementAccess().getDefinitionVariableDefinitionParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__ConstAssignment_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getConstConstKeyword_0_0_0()); }
		(
			{ before(grammarAccess.getVariableDefinitionAccess().getConstConstKeyword_0_0_0()); }
			'const'
			{ after(grammarAccess.getVariableDefinitionAccess().getConstConstKeyword_0_0_0()); }
		)
		{ after(grammarAccess.getVariableDefinitionAccess().getConstConstKeyword_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__ReadonlyAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getReadonlyReadonlyKeyword_1_0()); }
		(
			{ before(grammarAccess.getVariableDefinitionAccess().getReadonlyReadonlyKeyword_1_0()); }
			'readonly'
			{ after(grammarAccess.getVariableDefinitionAccess().getReadonlyReadonlyKeyword_1_0()); }
		)
		{ after(grammarAccess.getVariableDefinitionAccess().getReadonlyReadonlyKeyword_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__NameAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getNameIDWithKeywordsParserRuleCall_2_0()); }
		ruleIDWithKeywords
		{ after(grammarAccess.getVariableDefinitionAccess().getNameIDWithKeywordsParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__TypeSpecifierAssignment_3_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0_1_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getVariableDefinitionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__InitialValueAssignment_3_0_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getInitialValueExpressionParserRuleCall_3_0_2_1_0()); }
		ruleExpression
		{ after(grammarAccess.getVariableDefinitionAccess().getInitialValueExpressionParserRuleCall_3_0_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableDefinition__InitialValueAssignment_3_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableDefinitionAccess().getInitialValueExpressionParserRuleCall_3_1_1_0()); }
		ruleExpression
		{ after(grammarAccess.getVariableDefinitionAccess().getInitialValueExpressionParserRuleCall_3_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__ConditionAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIfStatementAccess().getConditionExpressionParserRuleCall_3_0()); }
		ruleExpression
		{ after(grammarAccess.getIfStatementAccess().getConditionExpressionParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__ThenAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIfStatementAccess().getThenCodeBlockParserRuleCall_5_0()); }
		ruleCodeBlock
		{ after(grammarAccess.getIfStatementAccess().getThenCodeBlockParserRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IfStatement__ElseAssignment_6_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIfStatementAccess().getElseCodeBlockParserRuleCall_6_1_0()); }
		ruleCodeBlock
		{ after(grammarAccess.getIfStatementAccess().getElseCodeBlockParserRuleCall_6_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ReturnStatement__ReturnValueAssignment_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getReturnStatementAccess().getReturnValueExpressionParserRuleCall_0_2_0()); }
		ruleExpression
		{ after(grammarAccess.getReturnStatementAccess().getReturnValueExpressionParserRuleCall_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__TypeAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotationAccess().getTypeAnnotationTypeCrossReference_1_0()); }
		(
			{ before(grammarAccess.getAnnotationAccess().getTypeAnnotationTypeQIDParserRuleCall_1_0_1()); }
			ruleQID
			{ after(grammarAccess.getAnnotationAccess().getTypeAnnotationTypeQIDParserRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getAnnotationAccess().getTypeAnnotationTypeCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__ArgumentsAssignment_2_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_0_0()); }
		ruleArgument
		{ after(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Annotation__ArgumentsAssignment_2_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__NameAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterAccess().getNameIDWithKeywordsParserRuleCall_0_0()); }
		ruleIDWithKeywords
		{ after(grammarAccess.getParameterAccess().getNameIDWithKeywordsParserRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__VarArgsAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterAccess().getVarArgsFullStopFullStopFullStopKeyword_1_0()); }
		(
			{ before(grammarAccess.getParameterAccess().getVarArgsFullStopFullStopFullStopKeyword_1_0()); }
			'...'
			{ after(grammarAccess.getParameterAccess().getVarArgsFullStopFullStopFullStopKeyword_1_0()); }
		)
		{ after(grammarAccess.getParameterAccess().getVarArgsFullStopFullStopFullStopKeyword_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Parameter__TypeSpecifierAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getParameterAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__FeatureAssignment_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleFeatureCallAccess().getFeatureDeclarationCrossReference_1_1_0()); }
		(
			{ before(grammarAccess.getSimpleFeatureCallAccess().getFeatureDeclarationIDTerminalRuleCall_1_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getSimpleFeatureCallAccess().getFeatureDeclarationIDTerminalRuleCall_1_1_0_1()); }
		)
		{ after(grammarAccess.getSimpleFeatureCallAccess().getFeatureDeclarationCrossReference_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__OperationCallAssignment_1_2_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_2_0_0()); }
		(
			{ before(grammarAccess.getSimpleFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_2_0_0()); }
			'('
			{ after(grammarAccess.getSimpleFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_2_0_0()); }
		)
		{ after(grammarAccess.getSimpleFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_2_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__ArgumentsAssignment_1_2_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_0_0()); }
		ruleArgument
		{ after(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleFeatureCall__ArgumentsAssignment_1_2_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__ReferenceAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceEObjectCrossReference_0_0()); }
		(
			{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceEObjectIDTerminalRuleCall_0_0_1()); }
			RULE_ID
			{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceEObjectIDTerminalRuleCall_0_0_1()); }
		)
		{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceEObjectCrossReference_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__OperationCallAssignment_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_1_0_0()); }
		(
			{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_1_0_0()); }
			'('
			{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_1_0_0()); }
		)
		{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__ArgumentsAssignment_1_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_0_0()); }
		ruleArgument
		{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleElementReferenceExpression__ArgumentsAssignment_1_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ActiveStateReferenceExpression__ValueAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getValueRegularStateCrossReference_3_0()); }
		(
			{ before(grammarAccess.getActiveStateReferenceExpressionAccess().getValueRegularStateFQNParserRuleCall_3_0_1()); }
			ruleFQN
			{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getValueRegularStateFQNParserRuleCall_3_0_1()); }
		)
		{ after(grammarAccess.getActiveStateReferenceExpressionAccess().getValueRegularStateCrossReference_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignmentOperatorEnumRuleCall_1_0_1_0()); }
		ruleAssignmentOperator
		{ after(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignmentOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentExpression__ExpressionAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getExpressionConditionalExpressionParserRuleCall_1_0_2_0()); }
		ruleConditionalExpression
		{ after(grammarAccess.getAssignmentExpressionAccess().getExpressionConditionalExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__TrueCaseAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getTrueCaseLogicalOrExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalOrExpression
		{ after(grammarAccess.getConditionalExpressionAccess().getTrueCaseLogicalOrExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ConditionalExpression__FalseCaseAssignment_1_0_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConditionalExpressionAccess().getFalseCaseLogicalOrExpressionParserRuleCall_1_0_4_0()); }
		ruleLogicalOrExpression
		{ after(grammarAccess.getConditionalExpressionAccess().getFalseCaseLogicalOrExpressionParserRuleCall_1_0_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getRightOperandLogicalAndExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalAndExpression
		{ after(grammarAccess.getLogicalOrExpressionAccess().getRightOperandLogicalAndExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getRightOperandLogicalNotExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalNotExpression
		{ after(grammarAccess.getLogicalAndExpressionAccess().getRightOperandLogicalNotExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalNotExpression__OperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalNotExpressionAccess().getOperandBitwiseOrExpressionParserRuleCall_1_0_2_0()); }
		ruleBitwiseOrExpression
		{ after(grammarAccess.getLogicalNotExpressionAccess().getOperandBitwiseOrExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseOrExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandBitwiseXorExpressionParserRuleCall_1_0_2_0()); }
		ruleBitwiseXorExpression
		{ after(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandBitwiseXorExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseXorExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandBitwiseAndExpressionParserRuleCall_1_0_2_0()); }
		ruleBitwiseAndExpression
		{ after(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandBitwiseAndExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BitwiseAndExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandLogicalRelationExpressionParserRuleCall_1_0_2_0()); }
		ruleLogicalRelationExpression
		{ after(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandLogicalRelationExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalRelationExpressionAccess().getOperatorRelationalOperatorEnumRuleCall_1_0_1_0()); }
		ruleRelationalOperator
		{ after(grammarAccess.getLogicalRelationExpressionAccess().getOperatorRelationalOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalRelationExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandShiftExpressionParserRuleCall_1_0_2_0()); }
		ruleShiftExpression
		{ after(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandShiftExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getOperatorShiftOperatorEnumRuleCall_1_0_1_0()); }
		ruleShiftOperator
		{ after(grammarAccess.getShiftExpressionAccess().getOperatorShiftOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ShiftExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getShiftExpressionAccess().getRightOperandNumericalAddSubtractExpressionParserRuleCall_1_0_2_0()); }
		ruleNumericalAddSubtractExpression
		{ after(grammarAccess.getShiftExpressionAccess().getRightOperandNumericalAddSubtractExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAdditiveOperatorEnumRuleCall_1_0_1_0()); }
		ruleAdditiveOperator
		{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAdditiveOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalAddSubtractExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandNumericalMultiplyDivideExpressionParserRuleCall_1_0_2_0()); }
		ruleNumericalMultiplyDivideExpression
		{ after(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandNumericalMultiplyDivideExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorMultiplicativeOperatorEnumRuleCall_1_0_1_0()); }
		ruleMultiplicativeOperator
		{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorMultiplicativeOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalMultiplyDivideExpression__RightOperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandNumericalUnaryExpressionParserRuleCall_1_0_2_0()); }
		ruleNumericalUnaryExpression
		{ after(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandNumericalUnaryExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorUnaryOperatorEnumRuleCall_1_0_1_0()); }
		ruleUnaryOperator
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorUnaryOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NumericalUnaryExpression__OperandAssignment_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNumericalUnaryExpressionAccess().getOperandPostFixUnaryExpressionParserRuleCall_1_0_2_0()); }
		rulePostFixUnaryExpression
		{ after(grammarAccess.getNumericalUnaryExpressionAccess().getOperandPostFixUnaryExpressionParserRuleCall_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PostFixUnaryExpression__OperatorAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_0_1_0()); }
		rulePostFixOperator
		{ after(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeCastExpression__TypeSpecifierAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_1_0_1_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__FeatureAssignment_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getFeatureEObjectCrossReference_1_0_1_0()); }
		(
			{ before(grammarAccess.getFeatureCallAccess().getFeatureEObjectRefIDWithKeywordsParserRuleCall_1_0_1_0_1()); }
			ruleRefIDWithKeywords
			{ after(grammarAccess.getFeatureCallAccess().getFeatureEObjectRefIDWithKeywordsParserRuleCall_1_0_1_0_1()); }
		)
		{ after(grammarAccess.getFeatureCallAccess().getFeatureEObjectCrossReference_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__OperationCallAssignment_1_0_2_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
		(
			{ before(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
			'('
			{ after(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
		)
		{ after(grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_0_0()); }
		ruleArgument
		{ after(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArgumentsAssignment_1_0_2_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArrayAccessAssignment_1_0_2_1_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
		(
			{ before(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
			'['
			{ after(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
		)
		{ after(grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_0_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_0_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FeatureCall__ArraySelectorAssignment_1_0_2_1_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_1_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ReferenceAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectCrossReference_1_0()); }
		(
			{ before(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectRefIDWithKeywordsParserRuleCall_1_0_1()); }
			ruleRefIDWithKeywords
			{ after(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectRefIDWithKeywordsParserRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__OperationCallAssignment_2_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
		(
			{ before(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
			'('
			{ after(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
		)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_0_0()); }
		ruleArgument
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArgumentsAssignment_2_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArrayAccessAssignment_2_1_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
		(
			{ before(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
			'['
			{ after(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
		)
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_0_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_0_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_0_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElementReferenceExpression__ArraySelectorAssignment_2_1_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_1_0_1_0()); }
		ruleExpression
		{ after(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_1_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveValueExpression__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveValueExpressionAccess().getValueLiteralParserRuleCall_1_0()); }
		ruleLiteral
		{ after(grammarAccess.getPrimitiveValueExpressionAccess().getValueLiteralParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__EventAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEventRaisingExpressionAccess().getEventFeatureCallParserRuleCall_2_0()); }
		ruleFeatureCall
		{ after(grammarAccess.getEventRaisingExpressionAccess().getEventFeatureCallParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventRaisingExpression__ValueAssignment_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEventRaisingExpressionAccess().getValueExpressionParserRuleCall_3_1_0()); }
		ruleExpression
		{ after(grammarAccess.getEventRaisingExpressionAccess().getValueExpressionParserRuleCall_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EventValueReferenceExpression__ValueAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEventValueReferenceExpressionAccess().getValueFeatureCallParserRuleCall_3_0()); }
		ruleFeatureCall
		{ after(grammarAccess.getEventValueReferenceExpressionAccess().getValueFeatureCallParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__ArgumentsAssignment_2_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_0()); }
		ruleArgument
		{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InitializationExpression__ArgumentsAssignment_2_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_1_1_0()); }
		ruleArgument
		{ after(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__ParameterAssignment_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArgumentAccess().getParameterTypedDeclarationCrossReference_0_0_0()); }
		(
			{ before(grammarAccess.getArgumentAccess().getParameterTypedDeclarationIDTerminalRuleCall_0_0_0_1()); }
			RULE_ID
			{ after(grammarAccess.getArgumentAccess().getParameterTypedDeclarationIDTerminalRuleCall_0_0_0_1()); }
		)
		{ after(grammarAccess.getArgumentAccess().getParameterTypedDeclarationCrossReference_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__KeyAssignment_1_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArgumentAccess().getKeyPrimitiveValueExpressionParserRuleCall_1_0_0_0()); }
		rulePrimitiveValueExpression
		{ after(grammarAccess.getArgumentAccess().getKeyPrimitiveValueExpressionParserRuleCall_1_0_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Argument__ValueAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArgumentAccess().getValueConditionalExpressionParserRuleCall_2_0()); }
		ruleConditionalExpression
		{ after(grammarAccess.getArgumentAccess().getValueConditionalExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParenthesizedExpression__ExpressionAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParenthesizedExpressionAccess().getExpressionExpressionParserRuleCall_2_0()); }
		ruleExpression
		{ after(grammarAccess.getParenthesizedExpressionAccess().getExpressionExpressionParserRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__TypeAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getTypeTypeCrossReference_0_0()); }
		(
			{ before(grammarAccess.getTypeSpecifierAccess().getTypeTypeQIDParserRuleCall_0_0_1()); }
			ruleQID
			{ after(grammarAccess.getTypeSpecifierAccess().getTypeTypeQIDParserRuleCall_0_0_1()); }
		)
		{ after(grammarAccess.getTypeSpecifierAccess().getTypeTypeCrossReference_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_0_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeSpecifier__TypeArgumentsAssignment_1_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_1_1_0()); }
		ruleTypeSpecifier
		{ after(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BoolLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBoolLiteralAccess().getValueBOOLTerminalRuleCall_1_0()); }
		RULE_BOOL
		{ after(grammarAccess.getBoolLiteralAccess().getValueBOOLTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntLiteralAccess().getValueLONGTerminalRuleCall_1_0()); }
		RULE_LONG
		{ after(grammarAccess.getIntLiteralAccess().getValueLONGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DoubleLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_1_0()); }
		RULE_DOUBLE
		{ after(grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FloatLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFloatLiteralAccess().getValueFLOATTerminalRuleCall_1_0()); }
		RULE_FLOAT
		{ after(grammarAccess.getFloatLiteralAccess().getValueFLOATTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__HexLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getHexLiteralAccess().getValueHEXTerminalRuleCall_1_0()); }
		RULE_HEX
		{ after(grammarAccess.getHexLiteralAccess().getValueHEXTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BinaryLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBinaryLiteralAccess().getValueBINARYTerminalRuleCall_1_0()); }
		RULE_BINARY
		{ after(grammarAccess.getBinaryLiteralAccess().getValueBINARYTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StringLiteral__ValueAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

RULE_LONG : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_BOOL : ('true'|'false'|'yes'|'no');

RULE_HEX : '0' ('x'|'X') ('0'..'9'|'a'..'f'|'A'..'F')+;

RULE_BINARY : '0' ('b'|'B') ('0'|'1')+;

RULE_DOUBLE : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('d'|'D')?;

RULE_FLOAT : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('f'|'F')?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

fragment RULE_INT : ('0'..'9')+;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
