/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.library.impl

import com.yakindu.sct.generator.core.library.ICoreLibraryConstants
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.DEBUG_FEATURE
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.DEBUG_FEATURE_DUMP_SEXEC
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.OUTLET_FEATURE
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.OUTLET_FEATURE_API_TARGET_FOLDER
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.OUTLET_FEATURE_LIBRARY_TARGET_FOLDER
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.OUTLET_FEATURE_SKIP_LIBRARY_FILES
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.OUTLET_FEATURE_TARGET_FOLDER
import static com.yakindu.sct.generator.core.library.ICoreLibraryConstants.OUTLET_FEATURE_TARGET_PROJECT

/**  
 * @author Johannes Dicks - Initial contribution and API
 */
class DefaultCoreLibraryHelper implements ICoreLibraryHelper {
	override FeatureParameterValue getTargetFolderValue(GeneratorEntry entry) {
		return entry.getFeatureParameterValue(OUTLET_FEATURE, OUTLET_FEATURE_TARGET_FOLDER)
	}

	override FeatureParameterValue getLibraryTargetFolderValue(GeneratorEntry entry) {
		return entry.getFeatureParameterValue(OUTLET_FEATURE, OUTLET_FEATURE_LIBRARY_TARGET_FOLDER)
	}

	override FeatureParameterValue getApiTargetFolderValue(GeneratorEntry entry) {
		return entry.getFeatureParameterValue(OUTLET_FEATURE, OUTLET_FEATURE_API_TARGET_FOLDER)
	}

	override FeatureParameterValue getTargetProjectValue(GeneratorEntry entry) {
		return entry.getFeatureParameterValue(OUTLET_FEATURE, OUTLET_FEATURE_TARGET_PROJECT)
	}

	override boolean serializeExecutionFlow(GeneratorEntry entry) {
		var FeatureParameterValue dumpSexec = entry.getFeatureParameterValue(DEBUG_FEATURE, DEBUG_FEATURE_DUMP_SEXEC)
		if (dumpSexec === null) {
			return false
		}
		return dumpSexec.getBooleanValue()
	}

	override boolean getSkipLibraryFiles(GeneratorEntry entry) {
		var FeatureParameterValue skipLibraryFiles = entry.getFeatureParameterValue(OUTLET_FEATURE,
			OUTLET_FEATURE_SKIP_LIBRARY_FILES)
		return if(skipLibraryFiles === null) false else skipLibraryFiles.getBooleanValue()
	}

	def private getOutEventAPIFeature(GeneratorEntry it) {
		getFeatureConfiguration(ICoreLibraryConstants::FEATURE_OUT_EVENT_API)
	}

	override getOutEventObservablesUsed(GeneratorEntry it) {
		val parameter = getOutEventAPIFeature?.getParameterValue(ICoreLibraryConstants::PARAMETER_OUT_EVENT_OBSERVABLES)
		if (parameter !== null) {
			return parameter.booleanValue
		}
		return outEventObservablesUsedDefault
	}
	
	def protected getOutEventObservablesUsedDefault() {
		true
	}

	override getOutEventGettersUsed(GeneratorEntry it) {
		val parameter = getOutEventAPIFeature?.getParameterValue(ICoreLibraryConstants::PARAMETER_OUT_EVENT_GETTERS)
		if (parameter !== null) {
			return parameter.booleanValue
		}
		return outEventGettersUsedDefault
	}
	
	def protected getOutEventGettersUsedDefault() {
		false
	}

	
}
