/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.expressions.interpreter.context

import com.google.inject.Inject
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Type
import com.yakindu.base.types.typesystem.ITypeValueProvider
import org.eclipse.emf.ecore.util.EcoreUtil
import com.yakindu.base.expressions.interpreter.base.ValueSemantics

/**
 * Implements standard provider for execution slot initial values.
 * 
 * @author Axel Terfloth 
 */
class DefaultExecutionSlotInitialValueProvider implements IExecutionSlotInitialValueProvider {

	@Inject protected extension ITypeValueProvider
	@Inject protected extension ValueSemantics

	override initialSlotValue(Type slotType) {
		return slotType?.defaultValue?.asValue
	}

	override initialSlotValue(Type slotType, Declaration variable) {
		try {
			val PropertyInitialValueAdapter adapter = EcoreUtil.getExistingAdapter(variable,
				PropertyInitialValueAdapter) as PropertyInitialValueAdapter
			return adapter?.initialValue?.value ?: slotType.initialSlotValue
		} catch (Exception exception) {
			
		}
		return slotType.initialSlotValue
	}


	def value(Object it) {
		it
	}
	
}