/*
*
* Copyright (c) 2025 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
grammar InternalSCTUnit;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package com.yakindu.sctunit.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package com.yakindu.sctunit.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import com.yakindu.sctunit.services.SCTUnitGrammarAccess;

}

@parser::members {

 	private SCTUnitGrammarAccess grammarAccess;

    public InternalSCTUnitParser(TokenStream input, SCTUnitGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "TestPackage";
   	}

   	@Override
   	protected SCTUnitGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleTestPackage
entryRuleTestPackage returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTestPackageRule()); }
	iv_ruleTestPackage=ruleTestPackage
	{ $current=$iv_ruleTestPackage.current; }
	EOF;

// Rule TestPackage
ruleTestPackage returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTestPackageAccess().getTestPackageAction_0(),
					$current);
			}
		)
		(
			otherlv_1='package'
			{
				newLeafNode(otherlv_1, grammarAccess.getTestPackageAccess().getPackageKeyword_1_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTestPackageAccess().getNameQIDParserRuleCall_1_1_0());
					}
					lv_name_2_0=ruleQID
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTestPackageRule());
						}
						set(
							$current,
							"name",
							lv_name_2_0,
							"com.yakindu.base.expressions.Expressions.QID");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getTestPackageAccess().getMemberSCTUnitElementParserRuleCall_2_0());
				}
				lv_member_3_0=ruleSCTUnitElement
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTestPackageRule());
					}
					add(
						$current,
						"member",
						lv_member_3_0,
						"com.yakindu.sctunit.SCTUnit.SCTUnitElement");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleSCTUnitElement
entryRuleSCTUnitElement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSCTUnitElementRule()); }
	iv_ruleSCTUnitElement=ruleSCTUnitElement
	{ $current=$iv_ruleSCTUnitElement.current; }
	EOF;

// Rule SCTUnitElement
ruleSCTUnitElement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getSCTUnitElementAccess().getSCTUnitClassParserRuleCall_0());
		}
		this_SCTUnitClass_0=ruleSCTUnitClass
		{
			$current = $this_SCTUnitClass_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getSCTUnitElementAccess().getSCTUnitSuiteParserRuleCall_1());
		}
		this_SCTUnitSuite_1=ruleSCTUnitSuite
		{
			$current = $this_SCTUnitSuite_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleSCTUnitClass
entryRuleSCTUnitClass returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSCTUnitClassRule()); }
	iv_ruleSCTUnitClass=ruleSCTUnitClass
	{ $current=$iv_ruleSCTUnitClass.current; }
	EOF;

// Rule SCTUnitClass
ruleSCTUnitClass returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSCTUnitClassAccess().getSCTUnitClassAction_0(),
					$current);
			}
		)
		otherlv_1='testclass'
		{
			newLeafNode(otherlv_1, grammarAccess.getSCTUnitClassAccess().getTestclassKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getSCTUnitClassAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSCTUnitClassRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_3='for'
		{
			newLeafNode(otherlv_3, grammarAccess.getSCTUnitClassAccess().getForKeyword_3());
		}
		otherlv_4='statechart'
		{
			newLeafNode(otherlv_4, grammarAccess.getSCTUnitClassAccess().getStatechartKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSCTUnitClassRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getSCTUnitClassAccess().getStatechartStatechartCrossReference_5_0());
				}
				ruleQID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_6='{'
		{
			newLeafNode(otherlv_6, grammarAccess.getSCTUnitClassAccess().getLeftCurlyBracketKeyword_6());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSCTUnitClassAccess().getVariableDefinitionsVariableDefinitionStatementParserRuleCall_7_0());
				}
				lv_variableDefinitions_7_0=ruleVariableDefinitionStatement
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSCTUnitClassRule());
					}
					add(
						$current,
						"variableDefinitions",
						lv_variableDefinitions_7_0,
						"com.yakindu.sctunit.SCTUnit.VariableDefinitionStatement");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getSCTUnitClassAccess().getFeaturesSCTUnitOperationParserRuleCall_8_0());
				}
				lv_features_8_0=ruleSCTUnitOperation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSCTUnitClassRule());
					}
					add(
						$current,
						"features",
						lv_features_8_0,
						"com.yakindu.sctunit.SCTUnit.SCTUnitOperation");
					afterParserOrEnumRuleCall();
				}
			)
		)+
		otherlv_9='}'
		{
			newLeafNode(otherlv_9, grammarAccess.getSCTUnitClassAccess().getRightCurlyBracketKeyword_9());
		}
	)
;

// Entry rule entryRuleSCTUnitSuite
entryRuleSCTUnitSuite returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSCTUnitSuiteRule()); }
	iv_ruleSCTUnitSuite=ruleSCTUnitSuite
	{ $current=$iv_ruleSCTUnitSuite.current; }
	EOF;

// Rule SCTUnitSuite
ruleSCTUnitSuite returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSCTUnitSuiteAccess().getSCTUnitSuiteAction_0(),
					$current);
			}
		)
		otherlv_1='testsuite'
		{
			newLeafNode(otherlv_1, grammarAccess.getSCTUnitSuiteAccess().getTestsuiteKeyword_1());
		}
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getSCTUnitSuiteAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSCTUnitSuiteRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_3='{'
		{
			newLeafNode(otherlv_3, grammarAccess.getSCTUnitSuiteAccess().getLeftCurlyBracketKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSCTUnitSuiteAccess().getFeaturesSCTUnitClassReferenceParserRuleCall_4_0());
				}
				lv_features_4_0=ruleSCTUnitClassReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSCTUnitSuiteRule());
					}
					add(
						$current,
						"features",
						lv_features_4_0,
						"com.yakindu.sctunit.SCTUnit.SCTUnitClassReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5=','
			{
				newLeafNode(otherlv_5, grammarAccess.getSCTUnitSuiteAccess().getCommaKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSCTUnitSuiteAccess().getFeaturesSCTUnitClassReferenceParserRuleCall_5_1_0());
					}
					lv_features_6_0=ruleSCTUnitClassReference
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSCTUnitSuiteRule());
						}
						add(
							$current,
							"features",
							lv_features_6_0,
							"com.yakindu.sctunit.SCTUnit.SCTUnitClassReference");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_7='}'
		{
			newLeafNode(otherlv_7, grammarAccess.getSCTUnitSuiteAccess().getRightCurlyBracketKeyword_6());
		}
	)
;

// Entry rule entryRuleSCTUnitClassReference
entryRuleSCTUnitClassReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSCTUnitClassReferenceRule()); }
	iv_ruleSCTUnitClassReference=ruleSCTUnitClassReference
	{ $current=$iv_ruleSCTUnitClassReference.current; }
	EOF;

// Rule SCTUnitClassReference
ruleSCTUnitClassReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getSCTUnitClassReferenceAccess().getTypeSpecifierSimpleTypeSpecifierParserRuleCall_0());
			}
			lv_typeSpecifier_0_0=ruleSimpleTypeSpecifier
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getSCTUnitClassReferenceRule());
				}
				set(
					$current,
					"typeSpecifier",
					lv_typeSpecifier_0_0,
					"com.yakindu.sctunit.SCTUnit.SimpleTypeSpecifier");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleSimpleTypeSpecifier
entryRuleSimpleTypeSpecifier returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSimpleTypeSpecifierRule()); }
	iv_ruleSimpleTypeSpecifier=ruleSimpleTypeSpecifier
	{ $current=$iv_ruleSimpleTypeSpecifier.current; }
	EOF;

// Rule SimpleTypeSpecifier
ruleSimpleTypeSpecifier returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				if ($current==null) {
					$current = createModelElement(grammarAccess.getSimpleTypeSpecifierRule());
				}
			}
			{
				newCompositeNode(grammarAccess.getSimpleTypeSpecifierAccess().getTypeTypeCrossReference_0());
			}
			ruleQID
			{
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleSCTUnitOperation
entryRuleSCTUnitOperation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSCTUnitOperationRule()); }
	iv_ruleSCTUnitOperation=ruleSCTUnitOperation
	{ $current=$iv_ruleSCTUnitOperation.current; }
	EOF;

// Rule SCTUnitOperation
ruleSCTUnitOperation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSCTUnitOperationAccess().getSCTUnitOperationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getSCTUnitOperationAccess().getAnnotationAnnotationParserRuleCall_1_0());
				}
				lv_annotation_1_0=ruleAnnotation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSCTUnitOperationRule());
					}
					add(
						$current,
						"annotation",
						lv_annotation_1_0,
						"com.yakindu.sct.model.stext.SText.Annotation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_2='operation'
		{
			newLeafNode(otherlv_2, grammarAccess.getSCTUnitOperationAccess().getOperationKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getSCTUnitOperationAccess().getNameIDWithKeywordsParserRuleCall_3_0());
				}
				lv_name_3_0=ruleIDWithKeywords
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSCTUnitOperationRule());
					}
					set(
						$current,
						"name",
						lv_name_3_0,
						"com.yakindu.base.expressions.Expressions.IDWithKeywords");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='('
		{
			newLeafNode(otherlv_4, grammarAccess.getSCTUnitOperationAccess().getLeftParenthesisKeyword_4());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getSCTUnitOperationAccess().getParametersParameterParserRuleCall_5_0_0());
					}
					lv_parameters_5_0=ruleParameter
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSCTUnitOperationRule());
						}
						add(
							$current,
							"parameters",
							lv_parameters_5_0,
							"com.yakindu.sct.model.stext.SText.Parameter");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getSCTUnitOperationAccess().getCommaKeyword_5_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getSCTUnitOperationAccess().getParametersParameterParserRuleCall_5_1_1_0());
						}
						lv_parameters_7_0=ruleParameter
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSCTUnitOperationRule());
							}
							add(
								$current,
								"parameters",
								lv_parameters_7_0,
								"com.yakindu.sct.model.stext.SText.Parameter");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_8=')'
		{
			newLeafNode(otherlv_8, grammarAccess.getSCTUnitOperationAccess().getRightParenthesisKeyword_6());
		}
		(
			otherlv_9=':'
			{
				newLeafNode(otherlv_9, grammarAccess.getSCTUnitOperationAccess().getColonKeyword_7_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSCTUnitOperationAccess().getTypeSpecifierTypeSpecifierParserRuleCall_7_1_0());
					}
					lv_typeSpecifier_10_0=ruleTypeSpecifier
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSCTUnitOperationRule());
						}
						set(
							$current,
							"typeSpecifier",
							lv_typeSpecifier_10_0,
							"com.yakindu.base.expressions.Expressions.TypeSpecifier");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getSCTUnitOperationAccess().getBodyCodeBlockParserRuleCall_8_0());
				}
				lv_body_11_0=ruleCodeBlock
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSCTUnitOperationRule());
					}
					set(
						$current,
						"body",
						lv_body_11_0,
						"com.yakindu.sctunit.SCTUnit.CodeBlock");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleCodeBlock
entryRuleCodeBlock returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getCodeBlockRule()); }
	iv_ruleCodeBlock=ruleCodeBlock
	{ $current=$iv_ruleCodeBlock.current; }
	EOF;

// Rule CodeBlock
ruleCodeBlock returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getCodeBlockAccess().getCodeBlockAction_0(),
					$current);
			}
		)
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getCodeBlockAccess().getLeftCurlyBracketKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getCodeBlockAccess().getCodeTestStatementParserRuleCall_2_0());
				}
				lv_code_2_0=ruleTestStatement
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getCodeBlockRule());
					}
					add(
						$current,
						"code",
						lv_code_2_0,
						"com.yakindu.sctunit.SCTUnit.TestStatement");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_3='}'
		{
			newLeafNode(otherlv_3, grammarAccess.getCodeBlockAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleTestStatement
entryRuleTestStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTestStatementRule()); }
	iv_ruleTestStatement=ruleTestStatement
	{ $current=$iv_ruleTestStatement.current; }
	EOF;

// Rule TestStatement
ruleTestStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTestStatementAccess().getExpressionStatementParserRuleCall_0());
		}
		this_ExpressionStatement_0=ruleExpressionStatement
		{
			$current = $this_ExpressionStatement_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTestStatementAccess().getMockingStatementParserRuleCall_1());
		}
		this_MockingStatement_1=ruleMockingStatement
		{
			$current = $this_MockingStatement_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTestStatementAccess().getAssertionStatementParserRuleCall_2());
		}
		this_AssertionStatement_2=ruleAssertionStatement
		{
			$current = $this_AssertionStatement_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTestStatementAccess().getLoopStatementParserRuleCall_3());
		}
		this_LoopStatement_3=ruleLoopStatement
		{
			$current = $this_LoopStatement_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTestStatementAccess().getVariableDefinitionStatementParserRuleCall_4());
		}
		this_VariableDefinitionStatement_4=ruleVariableDefinitionStatement
		{
			$current = $this_VariableDefinitionStatement_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTestStatementAccess().getReturnStatementParserRuleCall_5());
		}
		this_ReturnStatement_5=ruleReturnStatement
		{
			$current = $this_ReturnStatement_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTestStatementAccess().getIfStatementParserRuleCall_6());
		}
		this_IfStatement_6=ruleIfStatement
		{
			$current = $this_IfStatement_6.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleMockingStatement
entryRuleMockingStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMockingStatementRule()); }
	iv_ruleMockingStatement=ruleMockingStatement
	{ $current=$iv_ruleMockingStatement.current; }
	EOF;

// Rule MockingStatement
ruleMockingStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getMockingStatementAccess().getVerifyCalledStatementParserRuleCall_0());
		}
		this_VerifyCalledStatement_0=ruleVerifyCalledStatement
		{
			$current = $this_VerifyCalledStatement_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getMockingStatementAccess().getMockReturnStatementParserRuleCall_1());
		}
		this_MockReturnStatement_1=ruleMockReturnStatement
		{
			$current = $this_MockReturnStatement_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleVerifyCalledStatement
entryRuleVerifyCalledStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVerifyCalledStatementRule()); }
	iv_ruleVerifyCalledStatement=ruleVerifyCalledStatement
	{ $current=$iv_ruleVerifyCalledStatement.current; }
	EOF;

// Rule VerifyCalledStatement
ruleVerifyCalledStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getVerifyCalledStatementAccess().getVerifyCalledStatementAction_0(),
					$current);
			}
		)
		otherlv_1='assert'
		{
			newLeafNode(otherlv_1, grammarAccess.getVerifyCalledStatementAccess().getAssertKeyword_1());
		}
		(
			(
				lv_negated_2_0='!'
				{
					newLeafNode(lv_negated_2_0, grammarAccess.getVerifyCalledStatementAccess().getNegatedExclamationMarkKeyword_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVerifyCalledStatementRule());
					}
					setWithLastConsumed($current, "negated", lv_negated_2_0 != null, "!");
				}
			)
		)?
		otherlv_3='called'
		{
			newLeafNode(otherlv_3, grammarAccess.getVerifyCalledStatementAccess().getCalledKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getVerifyCalledStatementAccess().getReferenceSimpleFeatureCallParserRuleCall_4_0());
				}
				lv_reference_4_0=ruleSimpleFeatureCall
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVerifyCalledStatementRule());
					}
					set(
						$current,
						"reference",
						lv_reference_4_0,
						"com.yakindu.sct.model.stext.SText.SimpleFeatureCall");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getVerifyCalledStatementAccess().getTimesIntLiteralParserRuleCall_5_0_0());
					}
					lv_times_5_0=ruleIntLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getVerifyCalledStatementRule());
						}
						set(
							$current,
							"times",
							lv_times_5_0,
							"com.yakindu.base.expressions.Expressions.IntLiteral");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_6='times'
			{
				newLeafNode(otherlv_6, grammarAccess.getVerifyCalledStatementAccess().getTimesKeyword_5_1());
			}
		)?
	)
;

// Entry rule entryRuleMockReturnStatement
entryRuleMockReturnStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMockReturnStatementRule()); }
	iv_ruleMockReturnStatement=ruleMockReturnStatement
	{ $current=$iv_ruleMockReturnStatement.current; }
	EOF;

// Rule MockReturnStatement
ruleMockReturnStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMockReturnStatementAccess().getMockReturnStatementAction_0(),
					$current);
			}
		)
		otherlv_1='mock'
		{
			newLeafNode(otherlv_1, grammarAccess.getMockReturnStatementAccess().getMockKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getMockReturnStatementAccess().getReferenceSimpleFeatureCallParserRuleCall_2_0());
				}
				lv_reference_2_0=ruleSimpleFeatureCall
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMockReturnStatementRule());
					}
					set(
						$current,
						"reference",
						lv_reference_2_0,
						"com.yakindu.sct.model.stext.SText.SimpleFeatureCall");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3='returns'
			{
				newLeafNode(otherlv_3, grammarAccess.getMockReturnStatementAccess().getReturnsKeyword_3_0());
			}
			otherlv_4='('
			{
				newLeafNode(otherlv_4, grammarAccess.getMockReturnStatementAccess().getLeftParenthesisKeyword_3_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getMockReturnStatementAccess().getValueExpressionParserRuleCall_3_2_0());
					}
					lv_value_5_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMockReturnStatementRule());
						}
						set(
							$current,
							"value",
							lv_value_5_0,
							"com.yakindu.base.expressions.Expressions.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getMockReturnStatementAccess().getRightParenthesisKeyword_3_3());
			}
		)?
	)
;

// Entry rule entryRuleAssertionStatement
entryRuleAssertionStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAssertionStatementRule()); }
	iv_ruleAssertionStatement=ruleAssertionStatement
	{ $current=$iv_ruleAssertionStatement.current; }
	EOF;

// Rule AssertionStatement
ruleAssertionStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getAssertionStatementAccess().getAssertionStatementAction_0(),
					$current);
			}
		)
		otherlv_1='assert'
		{
			newLeafNode(otherlv_1, grammarAccess.getAssertionStatementAccess().getAssertKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getAssertionStatementAccess().getExpressionExpressionParserRuleCall_2_0());
				}
				lv_expression_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getAssertionStatementRule());
					}
					set(
						$current,
						"expression",
						lv_expression_2_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3='message'
			{
				newLeafNode(otherlv_3, grammarAccess.getAssertionStatementAccess().getMessageKeyword_3_0());
			}
			(
				(
					lv_errorMsg_4_0=RULE_STRING
					{
						newLeafNode(lv_errorMsg_4_0, grammarAccess.getAssertionStatementAccess().getErrorMsgSTRINGTerminalRuleCall_3_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getAssertionStatementRule());
						}
						setWithLastConsumed(
							$current,
							"errorMsg",
							lv_errorMsg_4_0,
							"com.yakindu.base.expressions.Expressions.STRING");
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleExitExpression
entryRuleExitExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExitExpressionRule()); }
	iv_ruleExitExpression=ruleExitExpression
	{ $current=$iv_ruleExitExpression.current; }
	EOF;

// Rule ExitExpression
ruleExitExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getExitExpressionAccess().getExitExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='exit'
		{
			newLeafNode(otherlv_1, grammarAccess.getExitExpressionAccess().getExitKeyword_1());
		}
	)
;

// Entry rule entryRuleEnterExpression
entryRuleEnterExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnterExpressionRule()); }
	iv_ruleEnterExpression=ruleEnterExpression
	{ $current=$iv_ruleEnterExpression.current; }
	EOF;

// Rule EnterExpression
ruleEnterExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEnterExpressionAccess().getEnterExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='enter'
		{
			newLeafNode(otherlv_1, grammarAccess.getEnterExpressionAccess().getEnterKeyword_1());
		}
	)
;

// Entry rule entryRuleTriggerWithoutEventExpression
entryRuleTriggerWithoutEventExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTriggerWithoutEventExpressionRule()); }
	iv_ruleTriggerWithoutEventExpression=ruleTriggerWithoutEventExpression
	{ $current=$iv_ruleTriggerWithoutEventExpression.current; }
	EOF;

// Rule TriggerWithoutEventExpression
ruleTriggerWithoutEventExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTriggerWithoutEventExpressionAccess().getTriggerWithoutEventExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='triggerWithoutEvent'
		{
			newLeafNode(otherlv_1, grammarAccess.getTriggerWithoutEventExpressionAccess().getTriggerWithoutEventKeyword_1());
		}
	)
;

// Entry rule entryRuleProceedExpression
entryRuleProceedExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProceedExpressionRule()); }
	iv_ruleProceedExpression=ruleProceedExpression
	{ $current=$iv_ruleProceedExpression.current; }
	EOF;

// Rule ProceedExpression
ruleProceedExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getProceedExpressionAccess().getProceedExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='proceed'
		{
			newLeafNode(otherlv_1, grammarAccess.getProceedExpressionAccess().getProceedKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getProceedExpressionAccess().getValueExpressionParserRuleCall_2_0());
				}
				lv_value_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getProceedExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getProceedExpressionAccess().getUnitProceedUnitEnumRuleCall_3_0());
				}
				lv_unit_3_0=ruleProceedUnit
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getProceedExpressionRule());
					}
					set(
						$current,
						"unit",
						lv_unit_3_0,
						"com.yakindu.sctunit.SCTUnit.ProceedUnit");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulePrimaryExpression
entryRulePrimaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimaryExpressionRule()); }
	iv_rulePrimaryExpression=rulePrimaryExpression
	{ $current=$iv_rulePrimaryExpression.current; }
	EOF;

// Rule PrimaryExpression
rulePrimaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getPrimitiveValueExpressionParserRuleCall_0());
		}
		this_PrimitiveValueExpression_0=rulePrimitiveValueExpression
		{
			$current = $this_PrimitiveValueExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			(ruleProceedExpression)=>
			{
				newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getProceedExpressionParserRuleCall_1());
			}
			this_ProceedExpression_1=ruleProceedExpression
			{
				$current = $this_ProceedExpression_1.current;
				afterParserOrEnumRuleCall();
			}
		)
		    |
		(
			(ruleExitExpression)=>
			{
				newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getExitExpressionParserRuleCall_2());
			}
			this_ExitExpression_2=ruleExitExpression
			{
				$current = $this_ExitExpression_2.current;
				afterParserOrEnumRuleCall();
			}
		)
		    |
		(
			(ruleEnterExpression)=>
			{
				newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getEnterExpressionParserRuleCall_3());
			}
			this_EnterExpression_3=ruleEnterExpression
			{
				$current = $this_EnterExpression_3.current;
				afterParserOrEnumRuleCall();
			}
		)
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getElementReferenceExpressionParserRuleCall_4());
		}
		this_ElementReferenceExpression_4=ruleElementReferenceExpression
		{
			$current = $this_ElementReferenceExpression_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getActiveStateReferenceExpressionParserRuleCall_5());
		}
		this_ActiveStateReferenceExpression_5=ruleActiveStateReferenceExpression
		{
			$current = $this_ActiveStateReferenceExpression_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getEventValueReferenceExpressionParserRuleCall_6());
		}
		this_EventValueReferenceExpression_6=ruleEventValueReferenceExpression
		{
			$current = $this_EventValueReferenceExpression_6.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getParenthesizedExpressionParserRuleCall_7());
		}
		this_ParenthesizedExpression_7=ruleParenthesizedExpression
		{
			$current = $this_ParenthesizedExpression_7.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getStatechartActiveExpressionParserRuleCall_8());
		}
		this_StatechartActiveExpression_8=ruleStatechartActiveExpression
		{
			$current = $this_StatechartActiveExpression_8.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getStatechartFinalExpressionParserRuleCall_9());
		}
		this_StatechartFinalExpression_9=ruleStatechartFinalExpression
		{
			$current = $this_StatechartFinalExpression_9.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getTriggerWithoutEventExpressionParserRuleCall_10());
		}
		this_TriggerWithoutEventExpression_10=ruleTriggerWithoutEventExpression
		{
			$current = $this_TriggerWithoutEventExpression_10.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getInitializationExpressionParserRuleCall_11());
		}
		this_InitializationExpression_11=ruleInitializationExpression
		{
			$current = $this_InitializationExpression_11.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleStatechartActiveExpression
entryRuleStatechartActiveExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStatechartActiveExpressionRule()); }
	iv_ruleStatechartActiveExpression=ruleStatechartActiveExpression
	{ $current=$iv_ruleStatechartActiveExpression.current; }
	EOF;

// Rule StatechartActiveExpression
ruleStatechartActiveExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStatechartActiveExpressionAccess().getStatechartActiveExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='is_active'
		{
			newLeafNode(otherlv_1, grammarAccess.getStatechartActiveExpressionAccess().getIs_activeKeyword_1());
		}
	)
;

// Entry rule entryRuleStatechartFinalExpression
entryRuleStatechartFinalExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStatechartFinalExpressionRule()); }
	iv_ruleStatechartFinalExpression=ruleStatechartFinalExpression
	{ $current=$iv_ruleStatechartFinalExpression.current; }
	EOF;

// Rule StatechartFinalExpression
ruleStatechartFinalExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStatechartFinalExpressionAccess().getStatechartFinalExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='is_final'
		{
			newLeafNode(otherlv_1, grammarAccess.getStatechartFinalExpressionAccess().getIs_finalKeyword_1());
		}
	)
;

// Entry rule entryRuleExpressionStatement
entryRuleExpressionStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionStatementRule()); }
	iv_ruleExpressionStatement=ruleExpressionStatement
	{ $current=$iv_ruleExpressionStatement.current; }
	EOF;

// Rule ExpressionStatement
ruleExpressionStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getExpressionStatementAccess().getExpressionStatementAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getExpressionStatementAccess().getExpressionExpressionParserRuleCall_1_0_0());
					}
					lv_expression_1_1=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getExpressionStatementRule());
						}
						set(
							$current,
							"expression",
							lv_expression_1_1,
							"com.yakindu.base.expressions.Expressions.Expression");
						afterParserOrEnumRuleCall();
					}
					    |
					{
						newCompositeNode(grammarAccess.getExpressionStatementAccess().getExpressionEventRaisingExpressionParserRuleCall_1_0_1());
					}
					lv_expression_1_2=ruleEventRaisingExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getExpressionStatementRule());
						}
						set(
							$current,
							"expression",
							lv_expression_1_2,
							"com.yakindu.base.expressions.Expressions.EventRaisingExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
	)
;

// Entry rule entryRuleLoopStatement
entryRuleLoopStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLoopStatementRule()); }
	iv_ruleLoopStatement=ruleLoopStatement
	{ $current=$iv_ruleLoopStatement.current; }
	EOF;

// Rule LoopStatement
ruleLoopStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getLoopStatementAccess().getLoopStatementAction_0(),
					$current);
			}
		)
		otherlv_1='while'
		{
			newLeafNode(otherlv_1, grammarAccess.getLoopStatementAccess().getWhileKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getLoopStatementAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getLoopStatementAccess().getGuardExpressionParserRuleCall_3_0());
				}
				lv_guard_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLoopStatementRule());
					}
					set(
						$current,
						"guard",
						lv_guard_3_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getLoopStatementAccess().getRightParenthesisKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getLoopStatementAccess().getBodyCodeBlockParserRuleCall_5_0());
				}
				lv_body_5_0=ruleCodeBlock
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getLoopStatementRule());
					}
					set(
						$current,
						"body",
						lv_body_5_0,
						"com.yakindu.sctunit.SCTUnit.CodeBlock");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleVariableDefinitionStatement
entryRuleVariableDefinitionStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVariableDefinitionStatementRule()); }
	iv_ruleVariableDefinitionStatement=ruleVariableDefinitionStatement
	{ $current=$iv_ruleVariableDefinitionStatement.current; }
	EOF;

// Rule VariableDefinitionStatement
ruleVariableDefinitionStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getVariableDefinitionStatementAccess().getVariableDefinitionStatementAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getVariableDefinitionStatementAccess().getDefinitionVariableDefinitionParserRuleCall_1_0());
				}
				lv_definition_1_0=ruleVariableDefinition
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVariableDefinitionStatementRule());
					}
					set(
						$current,
						"definition",
						lv_definition_1_0,
						"com.yakindu.sctunit.SCTUnit.VariableDefinition");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleVariableDefinition
entryRuleVariableDefinition returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getVariableDefinitionRule()); }
	iv_ruleVariableDefinition=ruleVariableDefinition
	{ $current=$iv_ruleVariableDefinition.current; }
	EOF;

// Rule VariableDefinition
ruleVariableDefinition returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					lv_const_0_0='const'
					{
						newLeafNode(lv_const_0_0, grammarAccess.getVariableDefinitionAccess().getConstConstKeyword_0_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getVariableDefinitionRule());
						}
						setWithLastConsumed($current, "const", lv_const_0_0 != null, "const");
					}
				)
			)
			    |
			otherlv_1='var'
			{
				newLeafNode(otherlv_1, grammarAccess.getVariableDefinitionAccess().getVarKeyword_0_1());
			}
		)
		(
			(
				lv_readonly_2_0='readonly'
				{
					newLeafNode(lv_readonly_2_0, grammarAccess.getVariableDefinitionAccess().getReadonlyReadonlyKeyword_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getVariableDefinitionRule());
					}
					setWithLastConsumed($current, "readonly", lv_readonly_2_0 != null, "readonly");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getVariableDefinitionAccess().getNameIDWithKeywordsParserRuleCall_2_0());
				}
				lv_name_3_0=ruleIDWithKeywords
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getVariableDefinitionRule());
					}
					set(
						$current,
						"name",
						lv_name_3_0,
						"com.yakindu.base.expressions.Expressions.IDWithKeywords");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				otherlv_4=':'
				{
					newLeafNode(otherlv_4, grammarAccess.getVariableDefinitionAccess().getColonKeyword_3_0_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getVariableDefinitionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0_1_0());
						}
						lv_typeSpecifier_5_0=ruleTypeSpecifier
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getVariableDefinitionRule());
							}
							set(
								$current,
								"typeSpecifier",
								lv_typeSpecifier_5_0,
								"com.yakindu.base.expressions.Expressions.TypeSpecifier");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_6='='
					{
						newLeafNode(otherlv_6, grammarAccess.getVariableDefinitionAccess().getEqualsSignKeyword_3_0_2_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getVariableDefinitionAccess().getInitialValueExpressionParserRuleCall_3_0_2_1_0());
							}
							lv_initialValue_7_0=ruleExpression
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getVariableDefinitionRule());
								}
								set(
									$current,
									"initialValue",
									lv_initialValue_7_0,
									"com.yakindu.base.expressions.Expressions.Expression");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)?
			)
			    |
			(
				otherlv_8='='
				{
					newLeafNode(otherlv_8, grammarAccess.getVariableDefinitionAccess().getEqualsSignKeyword_3_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getVariableDefinitionAccess().getInitialValueExpressionParserRuleCall_3_1_1_0());
						}
						lv_initialValue_9_0=ruleExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getVariableDefinitionRule());
							}
							set(
								$current,
								"initialValue",
								lv_initialValue_9_0,
								"com.yakindu.base.expressions.Expressions.Expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleIfStatement
entryRuleIfStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIfStatementRule()); }
	iv_ruleIfStatement=ruleIfStatement
	{ $current=$iv_ruleIfStatement.current; }
	EOF;

// Rule IfStatement
ruleIfStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getIfStatementAccess().getIfStatementAction_0(),
					$current);
			}
		)
		otherlv_1='if'
		{
			newLeafNode(otherlv_1, grammarAccess.getIfStatementAccess().getIfKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getIfStatementAccess().getConditionExpressionParserRuleCall_3_0());
				}
				lv_condition_3_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getIfStatementRule());
					}
					set(
						$current,
						"condition",
						lv_condition_3_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getIfStatementAccess().getThenCodeBlockParserRuleCall_5_0());
				}
				lv_then_5_0=ruleCodeBlock
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getIfStatementRule());
					}
					set(
						$current,
						"then",
						lv_then_5_0,
						"com.yakindu.sctunit.SCTUnit.CodeBlock");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_6='else'
			{
				newLeafNode(otherlv_6, grammarAccess.getIfStatementAccess().getElseKeyword_6_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getIfStatementAccess().getElseCodeBlockParserRuleCall_6_1_0());
					}
					lv_else_7_0=ruleCodeBlock
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getIfStatementRule());
						}
						set(
							$current,
							"else",
							lv_else_7_0,
							"com.yakindu.sctunit.SCTUnit.CodeBlock");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleReturnStatement
entryRuleReturnStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReturnStatementRule()); }
	iv_ruleReturnStatement=ruleReturnStatement
	{ $current=$iv_ruleReturnStatement.current; }
	EOF;

// Rule ReturnStatement
ruleReturnStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getReturnStatementAccess().getReturnStatementAction_0_0(),
						$current);
				}
			)
			otherlv_1='return'
			{
				newLeafNode(otherlv_1, grammarAccess.getReturnStatementAccess().getReturnKeyword_0_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getReturnStatementAccess().getReturnValueExpressionParserRuleCall_0_2_0());
					}
					lv_returnValue_2_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReturnStatementRule());
						}
						set(
							$current,
							"returnValue",
							lv_returnValue_2_0,
							"com.yakindu.base.expressions.Expressions.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					$current = forceCreateModelElement(
						grammarAccess.getReturnStatementAccess().getReturnStatementAction_1_0(),
						$current);
				}
			)
			otherlv_4='return'
			{
				newLeafNode(otherlv_4, grammarAccess.getReturnStatementAccess().getReturnKeyword_1_1());
			}
			otherlv_5=';'
			{
				newLeafNode(otherlv_5, grammarAccess.getReturnStatementAccess().getSemicolonKeyword_1_2());
			}
		)
	)
;

// Entry rule entryRuleReferenceKeywords
entryRuleReferenceKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getReferenceKeywordsRule()); }
	iv_ruleReferenceKeywords=ruleReferenceKeywords
	{ $current=$iv_ruleReferenceKeywords.current.getText(); }
	EOF;

// Rule ReferenceKeywords
ruleReferenceKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='package'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getPackageKeyword_0());
		}
		    |
		kw='testclass'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getTestclassKeyword_1());
		}
		    |
		kw='for'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getForKeyword_2());
		}
		    |
		kw='statechart'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getStatechartKeyword_3());
		}
		    |
		kw='testsuite'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getTestsuiteKeyword_4());
		}
		    |
		kw='operation'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getOperationKeyword_5());
		}
		    |
		kw='exit'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getExitKeyword_6());
		}
		    |
		kw='enter'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getEnterKeyword_7());
		}
		    |
		kw='proceed'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getProceedKeyword_8());
		}
		    |
		kw='s'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getSKeyword_9());
		}
		    |
		kw='ms'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getMsKeyword_10());
		}
		    |
		kw='us'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getUsKeyword_11());
		}
		    |
		kw='ns'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getNsKeyword_12());
		}
		    |
		kw='cycle'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getCycleKeyword_13());
		}
		    |
		kw='readonly'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getReferenceKeywordsAccess().getReadonlyKeyword_14());
		}
	)
;

// Entry rule entryRuleOtherKeywords
entryRuleOtherKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getOtherKeywordsRule()); }
	iv_ruleOtherKeywords=ruleOtherKeywords
	{ $current=$iv_ruleOtherKeywords.current.getText(); }
	EOF;

// Rule OtherKeywords
ruleOtherKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='raise'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getRaiseKeyword_0());
		}
		    |
		kw='valueof'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getValueofKeyword_1());
		}
		    |
		kw='active'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getActiveKeyword_2());
		}
		    |
		kw='assert'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getAssertKeyword_3());
		}
		    |
		kw='called'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getCalledKeyword_4());
		}
		    |
		kw='times'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getTimesKeyword_5());
		}
		    |
		kw='mock'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getMockKeyword_6());
		}
		    |
		kw='returns'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getReturnsKeyword_7());
		}
		    |
		kw='message'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getMessageKeyword_8());
		}
		    |
		kw='triggerWithoutEvent'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getTriggerWithoutEventKeyword_9());
		}
		    |
		kw='is_active'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getIs_activeKeyword_10());
		}
		    |
		kw='is_final'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getIs_finalKeyword_11());
		}
		    |
		kw='while'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getWhileKeyword_12());
		}
		    |
		kw='const'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getConstKeyword_13());
		}
		    |
		kw='var'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getVarKeyword_14());
		}
		    |
		kw='if'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getIfKeyword_15());
		}
		    |
		kw='else'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getElseKeyword_16());
		}
		    |
		kw='return'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getOtherKeywordsAccess().getReturnKeyword_17());
		}
	)
;

// Entry rule entryRuleAnnotation
entryRuleAnnotation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAnnotationRule()); }
	iv_ruleAnnotation=ruleAnnotation
	{ $current=$iv_ruleAnnotation.current; }
	EOF;

// Rule Annotation
ruleAnnotation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='@'
		{
			newLeafNode(otherlv_0, grammarAccess.getAnnotationAccess().getCommercialAtKeyword_0());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getAnnotationRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getAnnotationAccess().getTypeAnnotationTypeCrossReference_1_0());
				}
				ruleQID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getAnnotationAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_0_0());
						}
						lv_arguments_3_0=ruleArgument
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAnnotationRule());
							}
							add(
								$current,
								"arguments",
								lv_arguments_3_0,
								"com.yakindu.base.expressions.Expressions.Argument");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_4=','
					{
						newLeafNode(otherlv_4, grammarAccess.getAnnotationAccess().getCommaKeyword_2_1_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getAnnotationAccess().getArgumentsArgumentParserRuleCall_2_1_1_1_0());
							}
							lv_arguments_5_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getAnnotationRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_5_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getAnnotationAccess().getRightParenthesisKeyword_2_2());
			}
		)?
	)
;

// Entry rule entryRuleParameter
entryRuleParameter returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getParameterRule()); }
	iv_ruleParameter=ruleParameter
	{ $current=$iv_ruleParameter.current; }
	EOF;

// Rule Parameter
ruleParameter returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getParameterAccess().getNameIDWithKeywordsParserRuleCall_0_0());
				}
				lv_name_0_0=ruleIDWithKeywords
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getParameterRule());
					}
					set(
						$current,
						"name",
						lv_name_0_0,
						"com.yakindu.base.expressions.Expressions.IDWithKeywords");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_varArgs_1_0='...'
				{
					newLeafNode(lv_varArgs_1_0, grammarAccess.getParameterAccess().getVarArgsFullStopFullStopFullStopKeyword_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getParameterRule());
					}
					setWithLastConsumed($current, "varArgs", lv_varArgs_1_0 != null, "...");
				}
			)
		)?
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getParameterAccess().getColonKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getParameterAccess().getTypeSpecifierTypeSpecifierParserRuleCall_3_0());
				}
				lv_typeSpecifier_3_0=ruleTypeSpecifier
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getParameterRule());
					}
					set(
						$current,
						"typeSpecifier",
						lv_typeSpecifier_3_0,
						"com.yakindu.base.expressions.Expressions.TypeSpecifier");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleSimpleFeatureCall
entryRuleSimpleFeatureCall returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSimpleFeatureCallRule()); }
	iv_ruleSimpleFeatureCall=ruleSimpleFeatureCall
	{ $current=$iv_ruleSimpleFeatureCall.current; }
	EOF;

// Rule SimpleFeatureCall
ruleSimpleFeatureCall returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getSimpleFeatureCallAccess().getSimpleElementReferenceExpressionParserRuleCall_0());
		}
		this_SimpleElementReferenceExpression_0=ruleSimpleElementReferenceExpression
		{
			$current = $this_SimpleElementReferenceExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getSimpleFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='.'
					{
						newLeafNode(otherlv_2, grammarAccess.getSimpleFeatureCallAccess().getFullStopKeyword_1_0_0_1());
					}
				)
				    |
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getSimpleFeatureCallAccess().getMetaCallOwnerAction_1_0_1_0(),
								$current);
						}
					)
					otherlv_4='.@'
					{
						newLeafNode(otherlv_4, grammarAccess.getSimpleFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_1_1());
					}
				)
			)
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleFeatureCallRule());
						}
					}
					otherlv_5=RULE_ID
					{
						newLeafNode(otherlv_5, grammarAccess.getSimpleFeatureCallAccess().getFeatureDeclarationCrossReference_1_1_0());
					}
				)
			)
			(
				(
					((
						'('
					)
					)=>
					(
						lv_operationCall_6_0='('
						{
							newLeafNode(lv_operationCall_6_0, grammarAccess.getSimpleFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_2_0_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getSimpleFeatureCallRule());
							}
							setWithLastConsumed($current, "operationCall", lv_operationCall_6_0 != null, "(");
						}
					)
				)
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_0_0());
							}
							lv_arguments_7_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getSimpleFeatureCallRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_7_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_8=','
						{
							newLeafNode(otherlv_8, grammarAccess.getSimpleFeatureCallAccess().getCommaKeyword_1_2_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getSimpleFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_2_1_1_1_0());
								}
								lv_arguments_9_0=ruleArgument
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getSimpleFeatureCallRule());
									}
									add(
										$current,
										"arguments",
										lv_arguments_9_0,
										"com.yakindu.base.expressions.Expressions.Argument");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_10=')'
				{
					newLeafNode(otherlv_10, grammarAccess.getSimpleFeatureCallAccess().getRightParenthesisKeyword_1_2_2());
				}
			)?
		)*
	)
;

// Entry rule entryRuleSimpleElementReferenceExpression
entryRuleSimpleElementReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSimpleElementReferenceExpressionRule()); }
	iv_ruleSimpleElementReferenceExpression=ruleSimpleElementReferenceExpression
	{ $current=$iv_ruleSimpleElementReferenceExpression.current; }
	EOF;

// Rule SimpleElementReferenceExpression
ruleSimpleElementReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSimpleElementReferenceExpressionRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getSimpleElementReferenceExpressionAccess().getReferenceEObjectCrossReference_0_0());
				}
			)
		)
		(
			(
				((
					'('
				)
				)=>
				(
					lv_operationCall_1_0='('
					{
						newLeafNode(lv_operationCall_1_0, grammarAccess.getSimpleElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_1_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleElementReferenceExpressionRule());
						}
						setWithLastConsumed($current, "operationCall", lv_operationCall_1_0 != null, "(");
					}
				)
			)
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_0_0());
						}
						lv_arguments_2_0=ruleArgument
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleElementReferenceExpressionRule());
							}
							add(
								$current,
								"arguments",
								lv_arguments_2_0,
								"com.yakindu.base.expressions.Expressions.Argument");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_3=','
					{
						newLeafNode(otherlv_3, grammarAccess.getSimpleElementReferenceExpressionAccess().getCommaKeyword_1_1_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getSimpleElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_1_1_1_1_0());
							}
							lv_arguments_4_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getSimpleElementReferenceExpressionRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_4_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_5=')'
			{
				newLeafNode(otherlv_5, grammarAccess.getSimpleElementReferenceExpressionAccess().getRightParenthesisKeyword_1_2());
			}
		)?
	)
;

// Entry rule entryRuleActiveStateReferenceExpression
entryRuleActiveStateReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActiveStateReferenceExpressionRule()); }
	iv_ruleActiveStateReferenceExpression=ruleActiveStateReferenceExpression
	{ $current=$iv_ruleActiveStateReferenceExpression.current; }
	EOF;

// Rule ActiveStateReferenceExpression
ruleActiveStateReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActiveStateReferenceExpressionAccess().getActiveStateReferenceExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='active'
		{
			newLeafNode(otherlv_1, grammarAccess.getActiveStateReferenceExpressionAccess().getActiveKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getActiveStateReferenceExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getActiveStateReferenceExpressionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getActiveStateReferenceExpressionAccess().getValueRegularStateCrossReference_3_0());
				}
				ruleFQN
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getActiveStateReferenceExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleFQN
entryRuleFQN returns [String current=null]:
	{ newCompositeNode(grammarAccess.getFQNRule()); }
	iv_ruleFQN=ruleFQN
	{ $current=$iv_ruleFQN.current.getText(); }
	EOF;

// Rule FQN
ruleFQN returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_0());
		}
		this_IDWithKeywords_0=ruleIDWithKeywords
		{
			$current.merge(this_IDWithKeywords_0);
		}
		{
			afterParserOrEnumRuleCall();
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getFQNAccess().getFullStopKeyword_1_0());
			}
			{
				newCompositeNode(grammarAccess.getFQNAccess().getIDWithKeywordsParserRuleCall_1_1());
			}
			this_IDWithKeywords_2=ruleIDWithKeywords
			{
				$current.merge(this_IDWithKeywords_2);
			}
			{
				afterParserOrEnumRuleCall();
			}
		)*
	)
;

// Entry rule entryRuleExpression
entryRuleExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionRule()); }
	iv_ruleExpression=ruleExpression
	{ $current=$iv_ruleExpression.current; }
	EOF;

// Rule Expression
ruleExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall());
	}
	this_AssignmentExpression_0=ruleAssignmentExpression
	{
		$current = $this_AssignmentExpression_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleAssignmentExpression
entryRuleAssignmentExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getAssignmentExpressionRule()); }
	iv_ruleAssignmentExpression=ruleAssignmentExpression
	{ $current=$iv_ruleAssignmentExpression.current; }
	EOF;

// Rule AssignmentExpression
ruleAssignmentExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getConditionalExpressionParserRuleCall_0());
		}
		this_ConditionalExpression_0=ruleConditionalExpression
		{
			$current = $this_ConditionalExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleAssignmentOperator
					)
				)
				(
					(
						ruleConditionalExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionVarRefAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getOperatorAssignmentOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleAssignmentOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAssignmentExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.AssignmentOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getAssignmentExpressionAccess().getExpressionConditionalExpressionParserRuleCall_1_0_2_0());
						}
						lv_expression_3_0=ruleConditionalExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getAssignmentExpressionRule());
							}
							set(
								$current,
								"expression",
								lv_expression_3_0,
								"com.yakindu.base.expressions.Expressions.ConditionalExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleConditionalExpression
entryRuleConditionalExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConditionalExpressionRule()); }
	iv_ruleConditionalExpression=ruleConditionalExpression
	{ $current=$iv_ruleConditionalExpression.current; }
	EOF;

// Rule ConditionalExpression
ruleConditionalExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getConditionalExpressionAccess().getLogicalOrExpressionParserRuleCall_0());
		}
		this_LogicalOrExpression_0=ruleLogicalOrExpression
		{
			$current = $this_LogicalOrExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				'?'
				(
					(
						ruleLogicalOrExpression
					)
				)
				':'
				(
					(
						ruleLogicalOrExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getConditionalExpressionAccess().getConditionalExpressionConditionAction_1_0_0(),
							$current);
					}
				)
				otherlv_2='?'
				{
					newLeafNode(otherlv_2, grammarAccess.getConditionalExpressionAccess().getQuestionMarkKeyword_1_0_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConditionalExpressionAccess().getTrueCaseLogicalOrExpressionParserRuleCall_1_0_2_0());
						}
						lv_trueCase_3_0=ruleLogicalOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConditionalExpressionRule());
							}
							set(
								$current,
								"trueCase",
								lv_trueCase_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_4=':'
				{
					newLeafNode(otherlv_4, grammarAccess.getConditionalExpressionAccess().getColonKeyword_1_0_3());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConditionalExpressionAccess().getFalseCaseLogicalOrExpressionParserRuleCall_1_0_4_0());
						}
						lv_falseCase_5_0=ruleLogicalOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConditionalExpressionRule());
							}
							set(
								$current,
								"falseCase",
								lv_falseCase_5_0,
								"com.yakindu.base.expressions.Expressions.LogicalOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleLogicalOrExpression
entryRuleLogicalOrExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalOrExpressionRule()); }
	iv_ruleLogicalOrExpression=ruleLogicalOrExpression
	{ $current=$iv_ruleLogicalOrExpression.current; }
	EOF;

// Rule LogicalOrExpression
ruleLogicalOrExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getLogicalAndExpressionParserRuleCall_0());
		}
		this_LogicalAndExpression_0=ruleLogicalAndExpression
		{
			$current = $this_LogicalAndExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleLogicalOrOperator
				(
					(
						ruleLogicalAndExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalOrExpressionAccess().getLogicalOrExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getLogicalOrOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalOrExpressionAccess().getRightOperandLogicalAndExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalAndExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalOrExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalAndExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalAndExpression
entryRuleLogicalAndExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalAndExpressionRule()); }
	iv_ruleLogicalAndExpression=ruleLogicalAndExpression
	{ $current=$iv_ruleLogicalAndExpression.current; }
	EOF;

// Rule LogicalAndExpression
ruleLogicalAndExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getLogicalNotExpressionParserRuleCall_0());
		}
		this_LogicalNotExpression_0=ruleLogicalNotExpression
		{
			$current = $this_LogicalNotExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleLogicalAndOperator
				(
					(
						ruleLogicalNotExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalAndExpressionAccess().getLogicalAndExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getLogicalAndOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalAndOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalAndExpressionAccess().getRightOperandLogicalNotExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalNotExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalAndExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalNotExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalNotExpression
entryRuleLogicalNotExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalNotExpressionRule()); }
	iv_ruleLogicalNotExpression=ruleLogicalNotExpression
	{ $current=$iv_ruleLogicalNotExpression.current; }
	EOF;

// Rule LogicalNotExpression
ruleLogicalNotExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getBitwiseOrExpressionParserRuleCall_0());
		}
		this_BitwiseOrExpression_0=ruleBitwiseOrExpression
		{
			$current = $this_BitwiseOrExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			((
				(
				)
				ruleLogicalNotOperator
				(
					(
						ruleBitwiseOrExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getLogicalNotExpressionAccess().getLogicalNotExpressionAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getLogicalNotOperatorParserRuleCall_1_0_1());
				}
				ruleLogicalNotOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalNotExpressionAccess().getOperandBitwiseOrExpressionParserRuleCall_1_0_2_0());
						}
						lv_operand_3_0=ruleBitwiseOrExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalNotExpressionRule());
							}
							set(
								$current,
								"operand",
								lv_operand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseOrExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleBitwiseOrExpression
entryRuleBitwiseOrExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseOrExpressionRule()); }
	iv_ruleBitwiseOrExpression=ruleBitwiseOrExpression
	{ $current=$iv_ruleBitwiseOrExpression.current; }
	EOF;

// Rule BitwiseOrExpression
ruleBitwiseOrExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseXorExpressionParserRuleCall_0());
		}
		this_BitwiseXorExpression_0=ruleBitwiseXorExpression
		{
			$current = $this_BitwiseXorExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseOrOperator
				(
					(
						ruleBitwiseXorExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getBitwiseOrOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseOrExpressionAccess().getRightOperandBitwiseXorExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleBitwiseXorExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseOrExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseXorExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleBitwiseXorExpression
entryRuleBitwiseXorExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseXorExpressionRule()); }
	iv_ruleBitwiseXorExpression=ruleBitwiseXorExpression
	{ $current=$iv_ruleBitwiseXorExpression.current; }
	EOF;

// Rule BitwiseXorExpression
ruleBitwiseXorExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseAndExpressionParserRuleCall_0());
		}
		this_BitwiseAndExpression_0=ruleBitwiseAndExpression
		{
			$current = $this_BitwiseAndExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseXOrOperator
				(
					(
						ruleBitwiseAndExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXorExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getBitwiseXOrOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseXOrOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseXorExpressionAccess().getRightOperandBitwiseAndExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleBitwiseAndExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseXorExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.BitwiseAndExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleBitwiseAndExpression
entryRuleBitwiseAndExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseAndExpressionRule()); }
	iv_ruleBitwiseAndExpression=ruleBitwiseAndExpression
	{ $current=$iv_ruleBitwiseAndExpression.current; }
	EOF;

// Rule BitwiseAndExpression
ruleBitwiseAndExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getLogicalRelationExpressionParserRuleCall_0());
		}
		this_LogicalRelationExpression_0=ruleLogicalRelationExpression
		{
			$current = $this_LogicalRelationExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				ruleBitwiseAndOperator
				(
					(
						ruleLogicalRelationExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				{
					newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getBitwiseAndOperatorParserRuleCall_1_0_1());
				}
				ruleBitwiseAndOperator
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getBitwiseAndExpressionAccess().getRightOperandLogicalRelationExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleLogicalRelationExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getBitwiseAndExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.LogicalRelationExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleLogicalRelationExpression
entryRuleLogicalRelationExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLogicalRelationExpressionRule()); }
	iv_ruleLogicalRelationExpression=ruleLogicalRelationExpression
	{ $current=$iv_ruleLogicalRelationExpression.current; }
	EOF;

// Rule LogicalRelationExpression
ruleLogicalRelationExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getShiftExpressionParserRuleCall_0());
		}
		this_ShiftExpression_0=ruleShiftExpression
		{
			$current = $this_ShiftExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleRelationalOperator
					)
				)
				(
					(
						ruleShiftExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getLogicalRelationExpressionAccess().getLogicalRelationExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getOperatorRelationalOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleRelationalOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalRelationExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.RelationalOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getLogicalRelationExpressionAccess().getRightOperandShiftExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleShiftExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLogicalRelationExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.ShiftExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleShiftExpression
entryRuleShiftExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getShiftExpressionRule()); }
	iv_ruleShiftExpression=ruleShiftExpression
	{ $current=$iv_ruleShiftExpression.current; }
	EOF;

// Rule ShiftExpression
ruleShiftExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getShiftExpressionAccess().getNumericalAddSubtractExpressionParserRuleCall_0());
		}
		this_NumericalAddSubtractExpression_0=ruleNumericalAddSubtractExpression
		{
			$current = $this_NumericalAddSubtractExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleShiftOperator
					)
				)
				(
					(
						ruleNumericalAddSubtractExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getShiftExpressionAccess().getShiftExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getShiftExpressionAccess().getOperatorShiftOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleShiftOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getShiftExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.ShiftOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getShiftExpressionAccess().getRightOperandNumericalAddSubtractExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalAddSubtractExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getShiftExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalAddSubtractExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalAddSubtractExpression
entryRuleNumericalAddSubtractExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionRule()); }
	iv_ruleNumericalAddSubtractExpression=ruleNumericalAddSubtractExpression
	{ $current=$iv_ruleNumericalAddSubtractExpression.current; }
	EOF;

// Rule NumericalAddSubtractExpression
ruleNumericalAddSubtractExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalMultiplyDivideExpressionParserRuleCall_0());
		}
		this_NumericalMultiplyDivideExpression_0=ruleNumericalMultiplyDivideExpression
		{
			$current = $this_NumericalMultiplyDivideExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleAdditiveOperator
					)
				)
				(
					(
						ruleNumericalMultiplyDivideExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getNumericalAddSubtractExpressionAccess().getNumericalAddSubtractExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getOperatorAdditiveOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleAdditiveOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalAddSubtractExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.AdditiveOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalAddSubtractExpressionAccess().getRightOperandNumericalMultiplyDivideExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalMultiplyDivideExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalAddSubtractExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalMultiplyDivideExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalMultiplyDivideExpression
entryRuleNumericalMultiplyDivideExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionRule()); }
	iv_ruleNumericalMultiplyDivideExpression=ruleNumericalMultiplyDivideExpression
	{ $current=$iv_ruleNumericalMultiplyDivideExpression.current; }
	EOF;

// Rule NumericalMultiplyDivideExpression
ruleNumericalMultiplyDivideExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalUnaryExpressionParserRuleCall_0());
		}
		this_NumericalUnaryExpression_0=ruleNumericalUnaryExpression
		{
			$current = $this_NumericalUnaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						ruleMultiplicativeOperator
					)
				)
				(
					(
						ruleNumericalUnaryExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getNumericalMultiplyDivideExpressionAccess().getNumericalMultiplyDivideExpressionLeftOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getOperatorMultiplicativeOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleMultiplicativeOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalMultiplyDivideExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.MultiplicativeOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalMultiplyDivideExpressionAccess().getRightOperandNumericalUnaryExpressionParserRuleCall_1_0_2_0());
						}
						lv_rightOperand_3_0=ruleNumericalUnaryExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalMultiplyDivideExpressionRule());
							}
							set(
								$current,
								"rightOperand",
								lv_rightOperand_3_0,
								"com.yakindu.base.expressions.Expressions.NumericalUnaryExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleNumericalUnaryExpression
entryRuleNumericalUnaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNumericalUnaryExpressionRule()); }
	iv_ruleNumericalUnaryExpression=ruleNumericalUnaryExpression
	{ $current=$iv_ruleNumericalUnaryExpression.current; }
	EOF;

// Rule NumericalUnaryExpression
ruleNumericalUnaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getPostFixUnaryExpressionParserRuleCall_0());
		}
		this_PostFixUnaryExpression_0=rulePostFixUnaryExpression
		{
			$current = $this_PostFixUnaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			((
				(
				)
				(
					(
						ruleUnaryOperator
					)
				)
				(
					(
						rulePostFixUnaryExpression
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElement(
							grammarAccess.getNumericalUnaryExpressionAccess().getNumericalUnaryExpressionAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getOperatorUnaryOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=ruleUnaryOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalUnaryExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.UnaryOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getNumericalUnaryExpressionAccess().getOperandPostFixUnaryExpressionParserRuleCall_1_0_2_0());
						}
						lv_operand_3_0=rulePostFixUnaryExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNumericalUnaryExpressionRule());
							}
							set(
								$current,
								"operand",
								lv_operand_3_0,
								"com.yakindu.base.expressions.Expressions.PostFixUnaryExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRulePostFixUnaryExpression
entryRulePostFixUnaryExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPostFixUnaryExpressionRule()); }
	iv_rulePostFixUnaryExpression=rulePostFixUnaryExpression
	{ $current=$iv_rulePostFixUnaryExpression.current; }
	EOF;

// Rule PostFixUnaryExpression
rulePostFixUnaryExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPostFixUnaryExpressionAccess().getTypeCastExpressionParserRuleCall_0());
		}
		this_TypeCastExpression_0=ruleTypeCastExpression
		{
			$current = $this_TypeCastExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
				)
				(
					(
						rulePostFixOperator
					)
				)
			)
			)=>
			(
				(
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getPostFixUnaryExpressionAccess().getPostFixUnaryExpressionOperandAction_1_0_0(),
							$current);
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getPostFixUnaryExpressionAccess().getOperatorPostFixOperatorEnumRuleCall_1_0_1_0());
						}
						lv_operator_2_0=rulePostFixOperator
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPostFixUnaryExpressionRule());
							}
							set(
								$current,
								"operator",
								lv_operator_2_0,
								"com.yakindu.base.expressions.Expressions.PostFixOperator");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleTypeCastExpression
entryRuleTypeCastExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeCastExpressionRule()); }
	iv_ruleTypeCastExpression=ruleTypeCastExpression
	{ $current=$iv_ruleTypeCastExpression.current; }
	EOF;

// Rule TypeCastExpression
ruleTypeCastExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTypeCastExpressionAccess().getFeatureCallParserRuleCall_0());
		}
		this_FeatureCall_0=ruleFeatureCall
		{
			$current = $this_FeatureCall_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
					(
					)
					'as'
				)
				(
					(
						ruleTypeSpecifier
					)
				)
			)
			)=>
			(
				(
					(
						{
							$current = forceCreateModelElementAndSet(
								grammarAccess.getTypeCastExpressionAccess().getTypeCastExpressionOperandAction_1_0_0_0(),
								$current);
						}
					)
					otherlv_2='as'
					{
						newLeafNode(otherlv_2, grammarAccess.getTypeCastExpressionAccess().getAsKeyword_1_0_0_1());
					}
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getTypeCastExpressionAccess().getTypeSpecifierTypeSpecifierParserRuleCall_1_0_1_0());
						}
						lv_typeSpecifier_3_0=ruleTypeSpecifier
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getTypeCastExpressionRule());
							}
							set(
								$current,
								"typeSpecifier",
								lv_typeSpecifier_3_0,
								"com.yakindu.base.expressions.Expressions.TypeSpecifier");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRuleFeatureCall
entryRuleFeatureCall returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFeatureCallRule()); }
	iv_ruleFeatureCall=ruleFeatureCall
	{ $current=$iv_ruleFeatureCall.current; }
	EOF;

// Rule FeatureCall
ruleFeatureCall returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getFeatureCallAccess().getPrimaryExpressionParserRuleCall_0());
		}
		this_PrimaryExpression_0=rulePrimaryExpression
		{
			$current = $this_PrimaryExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			((
				(
					(
						(
						)
						(
							('.')=>
							'.'
						)
					)
					    |
					(
						(
						)
						'.@'
					)
				)
				(
					(
						ruleRefIDWithKeywords
					)
				)
				(
					(
						(
							((
								'('
							)
							)=>
							(
								'('
							)
						)
						(
							(
								(
									ruleArgument
								)
							)
							(
								','
								(
									(
										ruleArgument
									)
								)
							)*
						)?
						')'
					)
					    |
					(
						(
							((
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
						)
						(
							((
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
						)*
					)
				)?
			)
			)=>
			(
				(
					(
						(
							{
								$current = forceCreateModelElementAndSet(
									grammarAccess.getFeatureCallAccess().getFeatureCallOwnerAction_1_0_0_0_0(),
									$current);
							}
						)
						(
							('.')=>
							otherlv_2='.'
							{
								newLeafNode(otherlv_2, grammarAccess.getFeatureCallAccess().getFullStopKeyword_1_0_0_0_1());
							}
						)
					)
					    |
					(
						(
							{
								$current = forceCreateModelElementAndSet(
									grammarAccess.getFeatureCallAccess().getMetaCallOwnerAction_1_0_0_1_0(),
									$current);
							}
						)
						otherlv_4='.@'
						{
							newLeafNode(otherlv_4, grammarAccess.getFeatureCallAccess().getFullStopCommercialAtKeyword_1_0_0_1_1());
						}
					)
				)
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getFeatureCallRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getFeatureCallAccess().getFeatureEObjectCrossReference_1_0_1_0());
						}
						ruleRefIDWithKeywords
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						(
							((
								'('
							)
							)=>
							(
								lv_operationCall_6_0='('
								{
									newLeafNode(lv_operationCall_6_0, grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_0_2_0_0_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getFeatureCallRule());
									}
									setWithLastConsumed($current, "operationCall", lv_operationCall_6_0 != null, "(");
								}
							)
						)
						(
							(
								(
									{
										newCompositeNode(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_0_0());
									}
									lv_arguments_7_0=ruleArgument
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
										}
										add(
											$current,
											"arguments",
											lv_arguments_7_0,
											"com.yakindu.base.expressions.Expressions.Argument");
										afterParserOrEnumRuleCall();
									}
								)
							)
							(
								otherlv_8=','
								{
									newLeafNode(otherlv_8, grammarAccess.getFeatureCallAccess().getCommaKeyword_1_0_2_0_1_1_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArgumentsArgumentParserRuleCall_1_0_2_0_1_1_1_0());
										}
										lv_arguments_9_0=ruleArgument
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arguments",
												lv_arguments_9_0,
												"com.yakindu.base.expressions.Expressions.Argument");
											afterParserOrEnumRuleCall();
										}
									)
								)
							)*
						)?
						otherlv_10=')'
						{
							newLeafNode(otherlv_10, grammarAccess.getFeatureCallAccess().getRightParenthesisKeyword_1_0_2_0_2());
						}
					)
					    |
					(
						(
							((
								(
									(
										'['
									)
								)
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								(
									(
										lv_arrayAccess_11_0='['
										{
											newLeafNode(lv_arrayAccess_11_0, grammarAccess.getFeatureCallAccess().getArrayAccessLeftSquareBracketKeyword_1_0_2_1_0_0_0_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getFeatureCallRule());
											}
											setWithLastConsumed($current, "arrayAccess", lv_arrayAccess_11_0 != null, "[");
										}
									)
								)
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_0_0_1_0());
										}
										lv_arraySelector_12_0=ruleExpression
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arraySelector",
												lv_arraySelector_12_0,
												"com.yakindu.base.expressions.Expressions.Expression");
											afterParserOrEnumRuleCall();
										}
									)
								)
								otherlv_13=']'
								{
									newLeafNode(otherlv_13, grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_0_0_2());
								}
							)
						)
						(
							((
								'['
								(
									(
										ruleExpression
									)
								)
								']'
							)
							)=>
							(
								otherlv_14='['
								{
									newLeafNode(otherlv_14, grammarAccess.getFeatureCallAccess().getLeftSquareBracketKeyword_1_0_2_1_1_0_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFeatureCallAccess().getArraySelectorExpressionParserRuleCall_1_0_2_1_1_0_1_0());
										}
										lv_arraySelector_15_0=ruleExpression
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFeatureCallRule());
											}
											add(
												$current,
												"arraySelector",
												lv_arraySelector_15_0,
												"com.yakindu.base.expressions.Expressions.Expression");
											afterParserOrEnumRuleCall();
										}
									)
								)
								otherlv_16=']'
								{
									newLeafNode(otherlv_16, grammarAccess.getFeatureCallAccess().getRightSquareBracketKeyword_1_0_2_1_1_0_2());
								}
							)
						)*
					)
				)?
			)
		)*
	)
;

// Entry rule entryRuleElementReferenceExpression
entryRuleElementReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getElementReferenceExpressionRule()); }
	iv_ruleElementReferenceExpression=ruleElementReferenceExpression
	{ $current=$iv_ruleElementReferenceExpression.current; }
	EOF;

// Rule ElementReferenceExpression
ruleElementReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getElementReferenceExpressionAccess().getElementReferenceExpressionAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getReferenceEObjectCrossReference_1_0());
				}
				ruleRefIDWithKeywords
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(
					((
						'('
					)
					)=>
					(
						lv_operationCall_2_0='('
						{
							newLeafNode(lv_operationCall_2_0, grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
							}
							setWithLastConsumed($current, "operationCall", lv_operationCall_2_0 != null, "(");
						}
					)
				)
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_0_0());
							}
							lv_arguments_3_0=ruleArgument
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
								}
								add(
									$current,
									"arguments",
									lv_arguments_3_0,
									"com.yakindu.base.expressions.Expressions.Argument");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_4=','
						{
							newLeafNode(otherlv_4, grammarAccess.getElementReferenceExpressionAccess().getCommaKeyword_2_0_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_1_1_1_0());
								}
								lv_arguments_5_0=ruleArgument
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arguments",
										lv_arguments_5_0,
										"com.yakindu.base.expressions.Expressions.Argument");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_6=')'
				{
					newLeafNode(otherlv_6, grammarAccess.getElementReferenceExpressionAccess().getRightParenthesisKeyword_2_0_2());
				}
			)
			    |
			(
				(
					((
						(
							(
								'['
							)
						)
						(
							(
								ruleExpression
							)
						)
						']'
					)
					)=>
					(
						(
							(
								lv_arrayAccess_7_0='['
								{
									newLeafNode(lv_arrayAccess_7_0, grammarAccess.getElementReferenceExpressionAccess().getArrayAccessLeftSquareBracketKeyword_2_1_0_0_0_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getElementReferenceExpressionRule());
									}
									setWithLastConsumed($current, "arrayAccess", lv_arrayAccess_7_0 != null, "[");
								}
							)
						)
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_0_0_1_0());
								}
								lv_arraySelector_8_0=ruleExpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arraySelector",
										lv_arraySelector_8_0,
										"com.yakindu.base.expressions.Expressions.Expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_9=']'
						{
							newLeafNode(otherlv_9, grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_0_0_2());
						}
					)
				)
				(
					((
						'['
						(
							(
								ruleExpression
							)
						)
						']'
					)
					)=>
					(
						otherlv_10='['
						{
							newLeafNode(otherlv_10, grammarAccess.getElementReferenceExpressionAccess().getLeftSquareBracketKeyword_2_1_1_0_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getElementReferenceExpressionAccess().getArraySelectorExpressionParserRuleCall_2_1_1_0_1_0());
								}
								lv_arraySelector_11_0=ruleExpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getElementReferenceExpressionRule());
									}
									add(
										$current,
										"arraySelector",
										lv_arraySelector_11_0,
										"com.yakindu.base.expressions.Expressions.Expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_12=']'
						{
							newLeafNode(otherlv_12, grammarAccess.getElementReferenceExpressionAccess().getRightSquareBracketKeyword_2_1_1_0_2());
						}
					)
				)*
			)
		)?
	)
;

// Entry rule entryRulePrimitiveValueExpression
entryRulePrimitiveValueExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimitiveValueExpressionRule()); }
	iv_rulePrimitiveValueExpression=rulePrimitiveValueExpression
	{ $current=$iv_rulePrimitiveValueExpression.current; }
	EOF;

// Rule PrimitiveValueExpression
rulePrimitiveValueExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPrimitiveValueExpressionAccess().getPrimitiveValueExpressionAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getPrimitiveValueExpressionAccess().getValueLiteralParserRuleCall_1_0());
				}
				lv_value_1_0=ruleLiteral
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPrimitiveValueExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.Literal");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleEventRaisingExpression
entryRuleEventRaisingExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventRaisingExpressionRule()); }
	iv_ruleEventRaisingExpression=ruleEventRaisingExpression
	{ $current=$iv_ruleEventRaisingExpression.current; }
	EOF;

// Rule EventRaisingExpression
ruleEventRaisingExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEventRaisingExpressionAccess().getEventRaisingExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='raise'
		{
			newLeafNode(otherlv_1, grammarAccess.getEventRaisingExpressionAccess().getRaiseKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEventRaisingExpressionAccess().getEventFeatureCallParserRuleCall_2_0());
				}
				lv_event_2_0=ruleFeatureCall
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEventRaisingExpressionRule());
					}
					set(
						$current,
						"event",
						lv_event_2_0,
						"com.yakindu.base.expressions.Expressions.FeatureCall");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				(':')=>
				otherlv_3=':'
				{
					newLeafNode(otherlv_3, grammarAccess.getEventRaisingExpressionAccess().getColonKeyword_3_0());
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getEventRaisingExpressionAccess().getValueExpressionParserRuleCall_3_1_0());
					}
					lv_value_4_0=ruleExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEventRaisingExpressionRule());
						}
						set(
							$current,
							"value",
							lv_value_4_0,
							"com.yakindu.base.expressions.Expressions.Expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleEventValueReferenceExpression
entryRuleEventValueReferenceExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventValueReferenceExpressionRule()); }
	iv_ruleEventValueReferenceExpression=ruleEventValueReferenceExpression
	{ $current=$iv_ruleEventValueReferenceExpression.current; }
	EOF;

// Rule EventValueReferenceExpression
ruleEventValueReferenceExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEventValueReferenceExpressionAccess().getEventValueReferenceExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='valueof'
		{
			newLeafNode(otherlv_1, grammarAccess.getEventValueReferenceExpressionAccess().getValueofKeyword_1());
		}
		otherlv_2='('
		{
			newLeafNode(otherlv_2, grammarAccess.getEventValueReferenceExpressionAccess().getLeftParenthesisKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEventValueReferenceExpressionAccess().getValueFeatureCallParserRuleCall_3_0());
				}
				lv_value_3_0=ruleFeatureCall
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEventValueReferenceExpressionRule());
					}
					set(
						$current,
						"value",
						lv_value_3_0,
						"com.yakindu.base.expressions.Expressions.FeatureCall");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=')'
		{
			newLeafNode(otherlv_4, grammarAccess.getEventValueReferenceExpressionAccess().getRightParenthesisKeyword_4());
		}
	)
;

// Entry rule entryRuleInitializationExpression
entryRuleInitializationExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInitializationExpressionRule()); }
	iv_ruleInitializationExpression=ruleInitializationExpression
	{ $current=$iv_ruleInitializationExpression.current; }
	EOF;

// Rule InitializationExpression
ruleInitializationExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getInitializationExpressionAccess().getInitializationExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getInitializationExpressionAccess().getLeftCurlyBracketKeyword_1());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_0_0());
					}
					lv_arguments_2_0=ruleArgument
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getInitializationExpressionRule());
						}
						add(
							$current,
							"arguments",
							lv_arguments_2_0,
							"com.yakindu.base.expressions.Expressions.Argument");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_3=','
				{
					newLeafNode(otherlv_3, grammarAccess.getInitializationExpressionAccess().getCommaKeyword_2_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getInitializationExpressionAccess().getArgumentsArgumentParserRuleCall_2_1_1_0());
						}
						lv_arguments_4_0=ruleArgument
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getInitializationExpressionRule());
							}
							add(
								$current,
								"arguments",
								lv_arguments_4_0,
								"com.yakindu.base.expressions.Expressions.Argument");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_5='}'
		{
			newLeafNode(otherlv_5, grammarAccess.getInitializationExpressionAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleArgument
entryRuleArgument returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getArgumentRule()); }
	iv_ruleArgument=ruleArgument
	{ $current=$iv_ruleArgument.current; }
	EOF;

// Rule Argument
ruleArgument returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getArgumentRule());
						}
					}
					otherlv_0=RULE_ID
					{
						newLeafNode(otherlv_0, grammarAccess.getArgumentAccess().getParameterTypedDeclarationCrossReference_0_0_0());
					}
				)
			)
			otherlv_1='='
			{
				newLeafNode(otherlv_1, grammarAccess.getArgumentAccess().getEqualsSignKeyword_0_1());
			}
		)?
		(
			((
				(
					(
						rulePrimitiveValueExpression
					)
				)
				':'
			)
			)=>
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getArgumentAccess().getKeyPrimitiveValueExpressionParserRuleCall_1_0_0_0());
						}
						lv_key_2_0=rulePrimitiveValueExpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getArgumentRule());
							}
							set(
								$current,
								"key",
								lv_key_2_0,
								"com.yakindu.base.expressions.Expressions.PrimitiveValueExpression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_3=':'
				{
					newLeafNode(otherlv_3, grammarAccess.getArgumentAccess().getColonKeyword_1_0_1());
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getArgumentAccess().getValueConditionalExpressionParserRuleCall_2_0());
				}
				lv_value_4_0=ruleConditionalExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getArgumentRule());
					}
					set(
						$current,
						"value",
						lv_value_4_0,
						"com.yakindu.base.expressions.Expressions.ConditionalExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleParenthesizedExpression
entryRuleParenthesizedExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getParenthesizedExpressionRule()); }
	iv_ruleParenthesizedExpression=ruleParenthesizedExpression
	{ $current=$iv_ruleParenthesizedExpression.current; }
	EOF;

// Rule ParenthesizedExpression
ruleParenthesizedExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getParenthesizedExpressionAccess().getParenthesizedExpressionAction_0(),
					$current);
			}
		)
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getParenthesizedExpressionAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getParenthesizedExpressionAccess().getExpressionExpressionParserRuleCall_2_0());
				}
				lv_expression_2_0=ruleExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getParenthesizedExpressionRule());
					}
					set(
						$current,
						"expression",
						lv_expression_2_0,
						"com.yakindu.base.expressions.Expressions.Expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=')'
		{
			newLeafNode(otherlv_3, grammarAccess.getParenthesizedExpressionAccess().getRightParenthesisKeyword_3());
		}
	)
;

// Entry rule entryRuleTypeSpecifier
entryRuleTypeSpecifier returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeSpecifierRule()); }
	iv_ruleTypeSpecifier=ruleTypeSpecifier
	{ $current=$iv_ruleTypeSpecifier.current; }
	EOF;

// Rule TypeSpecifier
ruleTypeSpecifier returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTypeSpecifierRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeTypeCrossReference_0_0());
				}
				ruleQID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			((
				'<'
				(
					(
						(
							ruleTypeSpecifier
						)
					)
					(
						','
						(
							(
								ruleTypeSpecifier
							)
						)
					)*
				)?
				'>'
			)
			)=>
			(
				otherlv_1='<'
				{
					newLeafNode(otherlv_1, grammarAccess.getTypeSpecifierAccess().getLessThanSignKeyword_1_0_0());
				}
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_0_0());
							}
							lv_typeArguments_2_0=ruleTypeSpecifier
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getTypeSpecifierRule());
								}
								add(
									$current,
									"typeArguments",
									lv_typeArguments_2_0,
									"com.yakindu.base.expressions.Expressions.TypeSpecifier");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_3=','
						{
							newLeafNode(otherlv_3, grammarAccess.getTypeSpecifierAccess().getCommaKeyword_1_0_1_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getTypeSpecifierAccess().getTypeArgumentsTypeSpecifierParserRuleCall_1_0_1_1_1_0());
								}
								lv_typeArguments_4_0=ruleTypeSpecifier
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getTypeSpecifierRule());
									}
									add(
										$current,
										"typeArguments",
										lv_typeArguments_4_0,
										"com.yakindu.base.expressions.Expressions.TypeSpecifier");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_5='>'
				{
					newLeafNode(otherlv_5, grammarAccess.getTypeSpecifierAccess().getGreaterThanSignKeyword_1_0_2());
				}
			)
		)?
	)
;

// Entry rule entryRuleQID
entryRuleQID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getQIDRule()); }
	iv_ruleQID=ruleQID
	{ $current=$iv_ruleQID.current.getText(); }
	EOF;

// Rule QID
ruleQID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getQIDAccess().getIDTerminalRuleCall_0());
		}
		(
			(
				('.')=>
				kw='.'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getQIDAccess().getFullStopKeyword_1_0());
				}
			)
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getQIDAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleIDWithKeywords
entryRuleIDWithKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIDWithKeywordsRule()); }
	iv_ruleIDWithKeywords=ruleIDWithKeywords
	{ $current=$iv_ruleIDWithKeywords.current.getText(); }
	EOF;

// Rule IDWithKeywords
ruleIDWithKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getIDWithKeywordsAccess().getIDTerminalRuleCall_0());
		}
		    |
		{
			newCompositeNode(grammarAccess.getIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1());
		}
		this_ReferenceKeywords_1=ruleReferenceKeywords
		{
			$current.merge(this_ReferenceKeywords_1);
		}
		{
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getIDWithKeywordsAccess().getOtherKeywordsParserRuleCall_2());
		}
		this_OtherKeywords_2=ruleOtherKeywords
		{
			$current.merge(this_OtherKeywords_2);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleRefIDWithKeywords
entryRuleRefIDWithKeywords returns [String current=null]:
	{ newCompositeNode(grammarAccess.getRefIDWithKeywordsRule()); }
	iv_ruleRefIDWithKeywords=ruleRefIDWithKeywords
	{ $current=$iv_ruleRefIDWithKeywords.current.getText(); }
	EOF;

// Rule RefIDWithKeywords
ruleRefIDWithKeywords returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getRefIDWithKeywordsAccess().getIDTerminalRuleCall_0());
		}
		    |
		{
			newCompositeNode(grammarAccess.getRefIDWithKeywordsAccess().getReferenceKeywordsParserRuleCall_1());
		}
		this_ReferenceKeywords_1=ruleReferenceKeywords
		{
			$current.merge(this_ReferenceKeywords_1);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleLiteral
entryRuleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLiteralRule()); }
	iv_ruleLiteral=ruleLiteral
	{ $current=$iv_ruleLiteral.current; }
	EOF;

// Rule Literal
ruleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getBoolLiteralParserRuleCall_0());
		}
		this_BoolLiteral_0=ruleBoolLiteral
		{
			$current = $this_BoolLiteral_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getIntLiteralParserRuleCall_1());
		}
		this_IntLiteral_1=ruleIntLiteral
		{
			$current = $this_IntLiteral_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getHexLiteralParserRuleCall_2());
		}
		this_HexLiteral_2=ruleHexLiteral
		{
			$current = $this_HexLiteral_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getBinaryLiteralParserRuleCall_3());
		}
		this_BinaryLiteral_3=ruleBinaryLiteral
		{
			$current = $this_BinaryLiteral_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getDoubleLiteralParserRuleCall_4());
		}
		this_DoubleLiteral_4=ruleDoubleLiteral
		{
			$current = $this_DoubleLiteral_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getFloatLiteralParserRuleCall_5());
		}
		this_FloatLiteral_5=ruleFloatLiteral
		{
			$current = $this_FloatLiteral_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_6());
		}
		this_StringLiteral_6=ruleStringLiteral
		{
			$current = $this_StringLiteral_6.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_7());
		}
		this_NullLiteral_7=ruleNullLiteral
		{
			$current = $this_NullLiteral_7.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleBoolLiteral
entryRuleBoolLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBoolLiteralRule()); }
	iv_ruleBoolLiteral=ruleBoolLiteral
	{ $current=$iv_ruleBoolLiteral.current; }
	EOF;

// Rule BoolLiteral
ruleBoolLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBoolLiteralAccess().getBoolLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_BOOL
				{
					newLeafNode(lv_value_1_0, grammarAccess.getBoolLiteralAccess().getValueBOOLTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getBoolLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.BOOL");
				}
			)
		)
	)
;

// Entry rule entryRuleIntLiteral
entryRuleIntLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntLiteralRule()); }
	iv_ruleIntLiteral=ruleIntLiteral
	{ $current=$iv_ruleIntLiteral.current; }
	EOF;

// Rule IntLiteral
ruleIntLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getIntLiteralAccess().getIntLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_LONG
				{
					newLeafNode(lv_value_1_0, grammarAccess.getIntLiteralAccess().getValueLONGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.LONG");
				}
			)
		)
	)
;

// Entry rule entryRuleDoubleLiteral
entryRuleDoubleLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDoubleLiteralRule()); }
	iv_ruleDoubleLiteral=ruleDoubleLiteral
	{ $current=$iv_ruleDoubleLiteral.current; }
	EOF;

// Rule DoubleLiteral
ruleDoubleLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDoubleLiteralAccess().getDoubleLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_DOUBLE
				{
					newLeafNode(lv_value_1_0, grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDoubleLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.DOUBLE");
				}
			)
		)
	)
;

// Entry rule entryRuleFloatLiteral
entryRuleFloatLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFloatLiteralRule()); }
	iv_ruleFloatLiteral=ruleFloatLiteral
	{ $current=$iv_ruleFloatLiteral.current; }
	EOF;

// Rule FloatLiteral
ruleFloatLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getFloatLiteralAccess().getFloatLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_FLOAT
				{
					newLeafNode(lv_value_1_0, grammarAccess.getFloatLiteralAccess().getValueFLOATTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFloatLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.FLOAT");
				}
			)
		)
	)
;

// Entry rule entryRuleHexLiteral
entryRuleHexLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getHexLiteralRule()); }
	iv_ruleHexLiteral=ruleHexLiteral
	{ $current=$iv_ruleHexLiteral.current; }
	EOF;

// Rule HexLiteral
ruleHexLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getHexLiteralAccess().getHexLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_HEX
				{
					newLeafNode(lv_value_1_0, grammarAccess.getHexLiteralAccess().getValueHEXTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getHexLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.HEX");
				}
			)
		)
	)
;

// Entry rule entryRuleBinaryLiteral
entryRuleBinaryLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBinaryLiteralRule()); }
	iv_ruleBinaryLiteral=ruleBinaryLiteral
	{ $current=$iv_ruleBinaryLiteral.current; }
	EOF;

// Rule BinaryLiteral
ruleBinaryLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBinaryLiteralAccess().getBinaryLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_BINARY
				{
					newLeafNode(lv_value_1_0, grammarAccess.getBinaryLiteralAccess().getValueBINARYTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getBinaryLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.BINARY");
				}
			)
		)
	)
;

// Entry rule entryRuleStringLiteral
entryRuleStringLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStringLiteralRule()); }
	iv_ruleStringLiteral=ruleStringLiteral
	{ $current=$iv_ruleStringLiteral.current; }
	EOF;

// Rule StringLiteral
ruleStringLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStringLiteralAccess().getStringLiteralAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_STRING
				{
					newLeafNode(lv_value_1_0, grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getStringLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"com.yakindu.base.expressions.Expressions.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleNullLiteral
entryRuleNullLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNullLiteralRule()); }
	iv_ruleNullLiteral=ruleNullLiteral
	{ $current=$iv_ruleNullLiteral.current; }
	EOF;

// Rule NullLiteral
ruleNullLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getNullLiteralAccess().getNullLiteralAction_0(),
					$current);
			}
		)
		otherlv_1='null'
		{
			newLeafNode(otherlv_1, grammarAccess.getNullLiteralAccess().getNullKeyword_1());
		}
	)
;

// Entry rule entryRuleLogicalAndOperator
entryRuleLogicalAndOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalAndOperatorRule()); }
	iv_ruleLogicalAndOperator=ruleLogicalAndOperator
	{ $current=$iv_ruleLogicalAndOperator.current.getText(); }
	EOF;

// Rule LogicalAndOperator
ruleLogicalAndOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='&&'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalAndOperatorAccess().getAmpersandAmpersandKeyword());
	}
;

// Entry rule entryRuleLogicalOrOperator
entryRuleLogicalOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalOrOperatorRule()); }
	iv_ruleLogicalOrOperator=ruleLogicalOrOperator
	{ $current=$iv_ruleLogicalOrOperator.current.getText(); }
	EOF;

// Rule LogicalOrOperator
ruleLogicalOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='||'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalOrOperatorAccess().getVerticalLineVerticalLineKeyword());
	}
;

// Entry rule entryRuleLogicalNotOperator
entryRuleLogicalNotOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getLogicalNotOperatorRule()); }
	iv_ruleLogicalNotOperator=ruleLogicalNotOperator
	{ $current=$iv_ruleLogicalNotOperator.current.getText(); }
	EOF;

// Rule LogicalNotOperator
ruleLogicalNotOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='!'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getLogicalNotOperatorAccess().getExclamationMarkKeyword());
	}
;

// Entry rule entryRuleBitwiseXOrOperator
entryRuleBitwiseXOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseXOrOperatorRule()); }
	iv_ruleBitwiseXOrOperator=ruleBitwiseXOrOperator
	{ $current=$iv_ruleBitwiseXOrOperator.current.getText(); }
	EOF;

// Rule BitwiseXOrOperator
ruleBitwiseXOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='^'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseXOrOperatorAccess().getCircumflexAccentKeyword());
	}
;

// Entry rule entryRuleBitwiseOrOperator
entryRuleBitwiseOrOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseOrOperatorRule()); }
	iv_ruleBitwiseOrOperator=ruleBitwiseOrOperator
	{ $current=$iv_ruleBitwiseOrOperator.current.getText(); }
	EOF;

// Rule BitwiseOrOperator
ruleBitwiseOrOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='|'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseOrOperatorAccess().getVerticalLineKeyword());
	}
;

// Entry rule entryRuleBitwiseAndOperator
entryRuleBitwiseAndOperator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBitwiseAndOperatorRule()); }
	iv_ruleBitwiseAndOperator=ruleBitwiseAndOperator
	{ $current=$iv_ruleBitwiseAndOperator.current.getText(); }
	EOF;

// Rule BitwiseAndOperator
ruleBitwiseAndOperator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	kw='&'
	{
		$current.merge(kw);
		newLeafNode(kw, grammarAccess.getBitwiseAndOperatorAccess().getAmpersandKeyword());
	}
;

// Rule ProceedUnit
ruleProceedUnit returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='s'
			{
				$current = grammarAccess.getProceedUnitAccess().getSecondEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getProceedUnitAccess().getSecondEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='ms'
			{
				$current = grammarAccess.getProceedUnitAccess().getMillisecondEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getProceedUnitAccess().getMillisecondEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='us'
			{
				$current = grammarAccess.getProceedUnitAccess().getMicrosecondEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getProceedUnitAccess().getMicrosecondEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='ns'
			{
				$current = grammarAccess.getProceedUnitAccess().getNanosecondEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getProceedUnitAccess().getNanosecondEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='cycle'
			{
				$current = grammarAccess.getProceedUnitAccess().getCyclesEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getProceedUnitAccess().getCyclesEnumLiteralDeclaration_4());
			}
		)
	)
;

// Rule PostFixOperator
rulePostFixOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='++'
			{
				$current = grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getPostFixOperatorAccess().getIncrementEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='--'
			{
				$current = grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getPostFixOperatorAccess().getDecrementEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule AssignmentOperator
ruleAssignmentOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getAssignmentOperatorAccess().getAssignEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='*='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getAssignmentOperatorAccess().getMultAssignEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='/='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getAssignmentOperatorAccess().getDivAssignEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='%='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getAssignmentOperatorAccess().getModAssignEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='+='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getAssignmentOperatorAccess().getAddAssignEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='-='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getAssignmentOperatorAccess().getSubAssignEnumLiteralDeclaration_5());
			}
		)
		    |
		(
			enumLiteral_6='<<='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_6, grammarAccess.getAssignmentOperatorAccess().getLeftShiftAssignEnumLiteralDeclaration_6());
			}
		)
		    |
		(
			enumLiteral_7='>>='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_7, grammarAccess.getAssignmentOperatorAccess().getRightShiftAssignEnumLiteralDeclaration_7());
			}
		)
		    |
		(
			enumLiteral_8='&='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_8, grammarAccess.getAssignmentOperatorAccess().getAndAssignEnumLiteralDeclaration_8());
			}
		)
		    |
		(
			enumLiteral_9='^='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_9, grammarAccess.getAssignmentOperatorAccess().getXorAssignEnumLiteralDeclaration_9());
			}
		)
		    |
		(
			enumLiteral_10='|='
			{
				$current = grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_10, grammarAccess.getAssignmentOperatorAccess().getOrAssignEnumLiteralDeclaration_10());
			}
		)
	)
;

// Rule ShiftOperator
ruleShiftOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='<<'
			{
				$current = grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getShiftOperatorAccess().getLeftEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='>>'
			{
				$current = grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getShiftOperatorAccess().getRightEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule AdditiveOperator
ruleAdditiveOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='+'
			{
				$current = grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getAdditiveOperatorAccess().getPlusEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='-'
			{
				$current = grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getAdditiveOperatorAccess().getMinusEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule MultiplicativeOperator
ruleMultiplicativeOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='*'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getMultiplicativeOperatorAccess().getMulEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='/'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getMultiplicativeOperatorAccess().getDivEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='%'
			{
				$current = grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getMultiplicativeOperatorAccess().getModEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule UnaryOperator
ruleUnaryOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='+'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getUnaryOperatorAccess().getPositiveEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='-'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getUnaryOperatorAccess().getNegativeEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='~'
			{
				$current = grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getUnaryOperatorAccess().getComplementEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule RelationalOperator
ruleRelationalOperator returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='<'
			{
				$current = grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getRelationalOperatorAccess().getSmallerEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='<='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getRelationalOperatorAccess().getSmallerEqualEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='>'
			{
				$current = grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getRelationalOperatorAccess().getGreaterEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='>='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getRelationalOperatorAccess().getGreaterEqualEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='=='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getRelationalOperatorAccess().getEqualsEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='!='
			{
				$current = grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getRelationalOperatorAccess().getNotEqualsEnumLiteralDeclaration_5());
			}
		)
	)
;

RULE_LONG : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_BOOL : ('true'|'false'|'yes'|'no');

RULE_HEX : '0' ('x'|'X') ('0'..'9'|'a'..'f'|'A'..'F')+;

RULE_BINARY : '0' ('b'|'B') ('0'|'1')+;

RULE_DOUBLE : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('d'|'D')?;

RULE_FLOAT : RULE_INT '.' RULE_INT (('e'|'E') ('-'|'+')? RULE_INT)? ('f'|'F')?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

fragment RULE_INT : ('0'..'9')+;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
