/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.base.extensions

import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Property
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitElement
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.sCTUnit.TestPackage
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.xtext.EcoreUtil2

/**
 * 
 * @author Jonathan Thoene - Initial contribution and API
 * 
 */
class BaseNavigationExtensions {
	
	def List<SCTUnitOperation> getCalledOperations(SCTUnitOperation it, List<SCTUnitOperation> operations) {
		if (operations.contains(it)) {
			return operations;
		}
		operations.add(it)
		val refs = EcoreUtil2.getAllContentsOfType(body, ElementReferenceExpression)
		for (exp : refs) {
			val refe = exp.reference
			if (refe instanceof SCTUnitOperation) {
				return getCalledOperations(refe, operations)
			}
		}
		return operations;
	}
	
	def dispatch Scope getScope(EObject it) {
		getContainerOfType(it, typeof(Scope)) as Scope
	}

	def dispatch Scope getScope(Declaration it) {
		EcoreUtil2.getContainerOfType(it,typeof(Scope))
	}

	def dispatch Scope getScope(ElementReferenceExpression it) {
		reference.scope
	}
	
	def dispatch Scope getScope(FeatureCall it) {
		owner.scope
	}
	
	def protected getContainerOfType(EObject it, Class<? extends EObject> type) {
		EcoreUtil2.getContainerOfType(it, type)
	}
	
	def dispatch Statechart getStatechart(Scope it){
		EcoreUtil2.getContainerOfType(it, typeof(Statechart))
	}

	def dispatch Statechart getStatechart(EObject it) {
		EcoreUtil2.getContainerOfType(it, typeof(SCTUnitClass))?.statechart
	}

	def EventDefinition eventDefinition(EventRaisingExpression it) {
		if (event instanceof ElementReferenceExpression) {
			(event as ElementReferenceExpression).reference as EventDefinition
		} else if (event instanceof FeatureCall) {
			(event as FeatureCall).feature as EventDefinition
		} else {
			null
		}
	}
	
	def EventDefinition eventDefinition(EventValueReferenceExpression it) {
		if (value instanceof ElementReferenceExpression) {
			(value as ElementReferenceExpression).reference as EventDefinition
		} else if (value instanceof FeatureCall) {
			(value as FeatureCall).feature as EventDefinition
		} else {
			null
		}
	}
	
	
	def dispatch boolean isLocal(ElementReferenceExpression expr) {
		return expr.reference.isLocal
	}

	def dispatch boolean isLocal(EObject e) {
		EcoreUtil::getRootContainer(e) instanceof TestPackage
	}

	def dispatch boolean isLocal(FeatureCall it) {
		return owner.isLocal
	}
	
	def dispatch boolean isStatechartLocal(ElementReferenceExpression it) {
		return reference.isStatechartLocal
	}
	
	def dispatch boolean isStatechartLocal(EObject e) {
		EcoreUtil::getRootContainer(e) instanceof Statechart
	}
	
	def dispatch boolean isStatechartLocal(FeatureCall it) {
		return owner.isStatechartLocal
	}

	def getSCTUnitClasses(SCTUnitSuite it) {
		features.filter(Property).map[prop|prop.propertyToSCTUnitClass]
	}
	
	def getSCTUnitClass(SCTUnitOperation it) {
		EcoreUtil2.getContainerOfType(it,typeof(SCTUnitClass))
	}
	
	protected def propertyToSCTUnitClass(Property it) {
		if (type instanceof SCTUnitClass) type as SCTUnitClass
	}

	def getSCTUnitElement(TestPackage it) {
		EcoreUtil2.getAllContentsOfType(it, typeof(SCTUnitElement)).get(0)
	}
	
	def getSCTUnitElement(GeneratorEntry it) {
		getTestPackage.getSCTUnitElement
	}
	
	def getTestPackage(GeneratorEntry entry) {
		return entry.elementRef.eContainer as TestPackage
	}
	
	def getSCTUnitOperations(SCTUnitClass it){
		EcoreUtil2.getAllContentsOfType(it,typeof(SCTUnitOperation))
	}
	
	def getSCTUnitClass(EObject it) {
		EcoreUtil2.getContainerOfType(it, typeof(SCTUnitClass))
	}
	
	def getTestPackage(SCTUnitElement it){
		EcoreUtil2.getContainerOfType(it,typeof(TestPackage))
	}
	
	def dispatch isTest(SCTUnitOperation it){
		!annotation.filter[a|a.getType.name.equals("Test")].nullOrEmpty
	}
	
	def dispatch isTest(EObject it){
		false
	}
	
	def isRun(SCTUnitOperation it){
		!annotation.filter[a|a.getType.name.equals("Run")].nullOrEmpty
	}
	
	def isIgnore(SCTUnitOperation it){
		!annotation.filter[a|a.getType.name.equals("Ignore")].nullOrEmpty
	}
	
	def getAllTestOps(SCTUnitClass it){
		SCTUnitOperations.filter[op|op.isTest]
	}
	
	def getAllAnnotationlessOps(SCTUnitClass it){
		SCTUnitOperations.filter[op|(!op.isTest && !op.isRun)]
	}
}
