/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.json.transformation.model

import java.util.ArrayList
import java.util.HashMap
import java.util.List
import java.util.Map
import org.eclipse.xtend.lib.annotations.Accessors
import org.eclipse.xtend.lib.annotations.ToString

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
@Accessors
@ToString
class JsonRoot {
	JsonGraph graph
}

@Accessors
@ToString
class JsonGraph {

	List<JsonCell> cells = newArrayList;

	def List<JsonRegion> findTopLevelRegions() {
		cells.filter(JsonRegion).filter[parent.nullOrEmpty].toList
	}

	def List<JsonCell> findTopLevelVertices() {
		cells.filter(JsonCell).filter[parent.nullOrEmpty].filter[!(it instanceof JsonStatechart)].filter [
			!(it instanceof JsonRegion)
		].filter[!(it instanceof JsonTransition)].toList
	}

	def List<JsonCell> findChildren(JsonCell parentCell) {
		cells.filter[parent == parentCell.id].toList
	}

	def JsonCell findParent(JsonCell cell) {
		cells.findFirst [
			it.id == cell.parent
		]
	}

	def JsonNodeLabel findNodeLabel(JsonEntry cell) {
		cells.findFirst[it.id == cell.embeds.head] as JsonNodeLabel
	}

	def JsonNodeLabel findNodeLabel(JsonExit cell) {
		cells.findFirst[it.id == cell.embeds.head] as JsonNodeLabel
	}

	def findStatechart() {
		cells.filter(JsonStatechart).head
	}

	def List<JsonCell> findContainerHierachy(JsonCell cell, List<JsonCell> container) {
		val parent = findParent(cell)
		if (parent !== null) {
			container += parent
			return findContainerHierachy(parent, container)
		}
		return container
	}

	def findOutgoingTransitions(JsonCell cell) {
		cells.filter(JsonTransition).filter[sourceId == cell.id]
	}
}

@Accessors
@ToString
class JsonPosition {
	public static val EMPTY = new JsonPosition => [
		x = 0
		y = 0
	]
	double x
	double y

	def shift(JsonPosition shift) {
		this.x += shift.x
		this.y += shift.y
	}
}

@Accessors
@ToString
class JsonSize {
	public static val EMPTY = new JsonSize => [
		width = 0
		height = 0
	]
	double width
	double height
}

@Accessors
@ToString
class JsonCell {
	JsonPosition position
	Map<String, Object> attrs = newHashMap
	JsonSize size
	String id
	String parent
	int z

	// Getters & Setters for Values that are part of attrs array for convenience
	def String getName() {
		(attrs?.get("name") as Map<String, Object>)?.get("text") as String
	}

	def void setName(String value) {
		if(attrs === null) attrs = newHashMap
		var nameMap = attrs.get("name") as Map<String, Object>
		if (nameMap === null) {
			nameMap = newHashMap
			attrs.put("name", nameMap)
		}
		nameMap.put("text", value)
	}

	def String getSpecification() {
		val map = attrs?.get("specification") as Map<String, Object>
		map?.get("text") as String
	}

	def void setSpecification(String value) {
		var specAttrs = attrs.get("specification") as Map<String, Object>
		if (specAttrs === null) {
			specAttrs = newHashMap
			attrs.put("specification", specAttrs)
		}
		specAttrs.put("text", value)
	}
}

@Accessors
@ToString
class JsonNodeLabel extends JsonCell {
	// Getters & Setters for Values that are part of attrs array for convenience
	override String getName() {
		(attrs?.get("label") as Map<String, Object>)?.get("text") as String
	}

	override void setName(String value) {
		if(attrs === null) attrs = newHashMap
		var nameMap = attrs.get("label") as Map<String, Object>
		if (nameMap === null) {
			nameMap = newHashMap
			attrs.put("label", nameMap)
		}
		nameMap.put("text", value)
	}
}

@Accessors
@ToString
class JsonStatechart extends JsonCell {
}

@Accessors
@ToString
class JsonState extends JsonCell {
	List<String> embeds = newArrayList;
}

@Accessors
@ToString
class JsonRegion extends JsonCell {
	List<String> embeds = newArrayList;
}

@Accessors
@ToString
class JsonEntry extends JsonCell {
	String entryKind
	List<String> embeds = newArrayList;
}

@Accessors
@ToString
class JsonExit extends JsonCell {
	List<String> embeds = newArrayList;
}

@Accessors
@ToString
class JsonFinal extends JsonCell {
}

@Accessors
@ToString
class JsonChoice extends JsonCell {
}

@Accessors
@ToString
class JsonSynchronization extends JsonCell {
}

@Accessors
@ToString
class JsonTransition extends JsonCell {
	JsonTransitionSource source
	JsonTransitionTarget target
	List<Map<String, Object>> labels = new ArrayList
	List<JsonPosition> vertices = newArrayList

	// Getters & Setters for Values that are part of attrs array for convenience
	override String getSpecification() {
		val labels = labels.head
		val map = labels?.get("attrs") as Map<String, Object>
		val innerText = map?.get("text") as Map<String, Object>
		innerText?.get("text") as String
	}

	override setSpecification(String value) {
		if (labels.size == 0)
			labels.add(new HashMap)
		val label = labels.head
		var map = label.get("attrs") as Map<String, Object>
		if (map === null) {
			map = newHashMap
			label.put("attrs", map)
		}
		var innerText = map.get("text") as Map<String, Object>
		if (innerText === null) {
			innerText = newHashMap
			map.put("text", innerText)
		}
		innerText?.put("text", value)
	}

	def String getSourceId() {
		source?.id
	}

	def String getTargetId() {
		target.id
	}
}

@Accessors
@ToString
class JsonTransitionSource {
	String id
	JsonTransitionAnchor anchor
}

@Accessors
@ToString
class JsonTransitionTarget {
	String id
	JsonTransitionAnchor anchor
}

@Accessors
@ToString
class JsonTransitionAnchor {
	String name
	Map<String, Object> args = new HashMap
}
