/**
 * Copyright (c) 2018-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	itemis AG - initial API and implementation
 * 
 */
package com.yakindu.base.expressions.util

import com.google.common.collect.Lists
import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.BoolLiteral
import com.yakindu.base.expressions.expressions.DoubleLiteral
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.expressions.expressions.NullLiteral
import com.yakindu.base.expressions.expressions.StringLiteral
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import java.util.Collections
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.naming.IQualifiedNameProvider

/**
 * Thomas Kutz - Initial API and contribution
 */
class ExpressionExtensions {

	@Inject
	protected extension IQualifiedNameProvider

	/**
	 * Transforms a feature call to its call stack by traversing through the owner hierarchy
	 * @return a list of feature calls starting from the root call, 
	 * i.e. for <code>MyInterface.myVar.x</code> it returns <code>[MyInterface, myVar, x]</code>
	 */
	def dispatch List<ArgumentExpression> toCallStack(FeatureCall call) {
		val callStack = Lists.newArrayList
		callStack.addAll(call.owner.toCallStack)
		callStack.add(call)
		callStack
	}

	def dispatch List<ArgumentExpression> toCallStack(ElementReferenceExpression ex) {
		Lists.newArrayList(ex)
	}

	def dispatch List<ArgumentExpression> toCallStack(Expression ex) {
		Collections.emptyList
	}

	/**
	 * Returns getFeature() for FeatureCall and getReference() for ElementReferenceExpression
	 */
	def dispatch EObject featureOrReference(Void it) {
		null
	}

	def dispatch EObject featureOrReference(Expression it) {
		null
	}

	def dispatch EObject featureOrReference(FeatureCall it) {
		feature
	}

	def dispatch EObject featureOrReference(ElementReferenceExpression it) {
		reference
	}

	def dispatch ComplexType getOriginType(InitializationExpression it) {
	}

	def dispatch ComplexType getOriginType(EventRaisingExpression it) {
	}

	def dispatch ComplexType getOriginType(Expression it) {
		null
	}

	def List<Type> allTypes(Type it, List<Type> tl) {
		if (it instanceof ComplexType) {
			features.filter(Property).forEach [ ct |
				if (ct instanceof ComplexType) {
					ct.allTypes(tl)
				}
				tl.add(ct.type)
			]
		} else {
			tl.add(it)
		}
		tl
	}
	
	def dispatch literalValue(IntLiteral literal) {
		return literal.value as long
	}

	def dispatch literalValue(BoolLiteral bool) {
		return bool.value
	}

	def dispatch literalValue(DoubleLiteral literal) {
		return literal.value
	}

	def dispatch literalValue(FloatLiteral literal) {
		return literal.value
	}

	def dispatch literalValue(StringLiteral literal) {
		return literal.value
	}

	def dispatch literalValue(NullLiteral literal) {
		return null
	}
}
