/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codemodel

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.csharp.codepattern.MethodCode
import com.itemis.create.base.generator.csharp.transformation.Slang2CsharpTransformation
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.library.CoreGenmodelEntries
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.types.lib.StatechartLibrary

/**
 * Creates and provides the C# code model of the base statemachine interfaces.
 * 
 * @author Axel Terfloth (terfloth@itemis.de)
 */
@Singleton
class CsharpStatemachineLibrary {

	public static final String FILE_NAME = "Statemachines"

	@Inject protected extension OriginTracing
	@Inject protected extension CsharpCompilationUnit
	@Inject protected extension Slang2CsharpTransformation transformation
	@Inject protected extension CsharpClass
	@Inject protected extension CsharpNamespace
	@Inject protected extension GeneratorAssignment
	@Inject protected extension CoreGenmodelEntries
	@Inject protected GeneratorEntry entry
	@Inject protected extension MethodCode
	@Inject protected StatechartLibrary lib

	def create slCu : transformStateMachineLibrary statemachineLibrary() {
		slCu.name = FILE_NAME
		slCu._compilationUnit(entry?.getLibraryPackage)

		slCu.member += hierarchyTransformation(statemachineInterface.interfaceTransformation)
		slCu.member += hierarchyTransformation(eventDrivenStatemachineInterface.interfaceTransformation)
		slCu.member += hierarchyTransformation(cycleBasedStatemachineInterface.interfaceTransformation)

	}

	def interfaceTransformation(ComplexType ct) {
		ct.name = "I" + ct.name
		ct._csharpInterface
		ct.features.filter(Operation).forEach [
			generateDefinitionWith[methodDeclarationCode]
		]
		ct
	}

	def hierarchyTransformation(ComplexType ct) {
		_compilationUnit => [ cu |
			cu.name = ct.name
			cu.member += _csNamespace => [ ns |
				ns.name = entry?.getLibraryPackage
				ns.member += ct
			]
		]
	}

	def protected transformStateMachineLibrary() {
		lib.typesPackage.transform as Package
	}

	def statemachineInterface() {
		lib.statemachine.asCsharpDeclaration as ComplexType
	}

	def eventDrivenStatemachineInterface() {
		lib.eventDriven.asCsharpDeclaration as ComplexType
	}

	def cycleBasedStatemachineInterface() {
		lib.cycleBased.asCsharpDeclaration as ComplexType
	}

	def create r : it.findCsharpDeclaration asCsharpDeclaration(Declaration it) {}

	def protected findCsharpDeclaration(Declaration it) {
		statemachineLibrary.eAllContents.findFirst[e|e.origin === it]
	}
}
