/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.Package

/**
 * Defines the standard code pattern for generating C# name spaces. 
 * 
 * @author Axel Terfloth
 */
class NamespaceCode {
	
	@Inject protected extension GeneratorAssignment
	
	def namespaceCode(Package ns) '''
	
	«IF ! ns.name.isNullOrEmpty»
	namespace «ns.name» {
	«ENDIF»
	
	«FOR m : ns.member»
		«m.definitionCode»
	«ENDFOR»

	«IF ! ns.name.isNullOrEmpty»
	}
	«ENDIF»
	
	'''
	
}