/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.python

import com.google.inject.Inject
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions

/**
 * @author Robin Herrmann
 */
class PythonObservables {

	@Inject extension SExecExtensions
	@Inject extension ShadowEventExtensions
	@Inject extension Naming

	def observerClass(ExecutionFlow it) '''
		«FOR event : getShadowEvents»
			class «event.asObserverClass»(Observer):
				"""Observer for «event.identifier».
				"""
				
				def __init__(self, statemachine):
					self.statemachine = statemachine
			
				def next(self, value=None):
					"""Raises the «event.identifier».
					"""
					self.statemachine.raise_«event.identifier»(«IF event.hasValue»value«ENDIF»)
			
			
		«ENDFOR»
	'''

}
