/**
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.scxml

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.ISCTUnitGenerator
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.generator.scxml.qt.files.AbstractTestsHeader
import com.yakindu.sctunit.generator.scxml.qt.files.AbstractTestsSource
import com.yakindu.sctunit.generator.scxml.qt.files.ProjectFile
import com.yakindu.sctunit.generator.scxml.qt.files.TestRunner
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import org.eclipse.xtext.generator.IFileSystemAccess
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.scxml.qt.files.TestClassHeader
import com.yakindu.sctunit.generator.scxml.qt.files.TestClassSource

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * @author oliver bohl
 * @author Johannes Dicks - Refactoring based on EFS encapsulation
 * 
 */
class SCXMLSCTUnitGenerator implements ISCTUnitGenerator {

	@Inject extension BaseNavigationExtensions

	@Inject ProjectFile projectFile
	@Inject AbstractTestsHeader abstractTestsHeader
	@Inject AbstractTestsSource abstractTestsSource
	@Inject TestClassHeader testClassHeader
	@Inject TestClassSource testClassSource
	@Inject TestRunner testRunner

	override generate(GeneratorEntry entry, IFileSystemAccess fsa) {
		abstractTestsHeader.generate(entry, fsa)
		abstractTestsSource.generate(entry, fsa)
		testRunner.generate(entry, fsa)

		var sctUnitElement = getSCTUnitElement(entry)

		switch (sctUnitElement) {
			SCTUnitClass: {
				testClassHeader.generate(entry, fsa)
				testClassSource.generate(entry, fsa)
			}
			SCTUnitSuite: {
				for (cls : sctUnitElement.SCTUnitClasses) {
					testClassHeader.generate(cls, fsa)
					testClassSource.generate(cls, fsa)
				}
			}
		}
		projectFile.generate(entry, fsa)
	}

}
